// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex data type that includes the profile configurations specified for field-level encryption.
 */
class FieldLevelEncryptionConfig private constructor(builder: BuilderImpl) {
    /**
     * A unique number that ensures the request can't be replayed.
     */
    val callerReference: String? = builder.callerReference
    /**
     * An optional comment about the configuration. The comment cannot be longer than 128
     * characters.
     */
    val comment: String? = builder.comment
    /**
     * A complex data type that specifies when to forward content if a content type isn't recognized and profiles to use as by default
     * in a request if a query argument doesn't specify a profile to use.
     */
    val contentTypeProfileConfig: ContentTypeProfileConfig? = builder.contentTypeProfileConfig
    /**
     * A complex data type that specifies when to forward content if a profile isn't found and the profile that can be provided as a
     * query argument in a request.
     */
    val queryArgProfileConfig: QueryArgProfileConfig? = builder.queryArgProfileConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FieldLevelEncryptionConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FieldLevelEncryptionConfig(")
        append("callerReference=$callerReference,")
        append("comment=$comment,")
        append("contentTypeProfileConfig=$contentTypeProfileConfig,")
        append("queryArgProfileConfig=$queryArgProfileConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (contentTypeProfileConfig?.hashCode() ?: 0)
        result = 31 * result + (queryArgProfileConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FieldLevelEncryptionConfig

        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (contentTypeProfileConfig != other.contentTypeProfileConfig) return false
        if (queryArgProfileConfig != other.queryArgProfileConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FieldLevelEncryptionConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FieldLevelEncryptionConfig
        /**
         * A unique number that ensures the request can't be replayed.
         */
        fun callerReference(callerReference: String): FluentBuilder
        /**
         * An optional comment about the configuration. The comment cannot be longer than 128
         * characters.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * A complex data type that specifies when to forward content if a content type isn't recognized and profiles to use as by default
         * in a request if a query argument doesn't specify a profile to use.
         */
        fun contentTypeProfileConfig(contentTypeProfileConfig: ContentTypeProfileConfig): FluentBuilder
        /**
         * A complex data type that specifies when to forward content if a profile isn't found and the profile that can be provided as a
         * query argument in a request.
         */
        fun queryArgProfileConfig(queryArgProfileConfig: QueryArgProfileConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique number that ensures the request can't be replayed.
         */
        var callerReference: String?
        /**
         * An optional comment about the configuration. The comment cannot be longer than 128
         * characters.
         */
        var comment: String?
        /**
         * A complex data type that specifies when to forward content if a content type isn't recognized and profiles to use as by default
         * in a request if a query argument doesn't specify a profile to use.
         */
        var contentTypeProfileConfig: ContentTypeProfileConfig?
        /**
         * A complex data type that specifies when to forward content if a profile isn't found and the profile that can be provided as a
         * query argument in a request.
         */
        var queryArgProfileConfig: QueryArgProfileConfig?

        fun build(): FieldLevelEncryptionConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ContentTypeProfileConfig] inside the given [block]
         */
        fun contentTypeProfileConfig(block: ContentTypeProfileConfig.DslBuilder.() -> kotlin.Unit) {
            this.contentTypeProfileConfig = ContentTypeProfileConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.QueryArgProfileConfig] inside the given [block]
         */
        fun queryArgProfileConfig(block: QueryArgProfileConfig.DslBuilder.() -> kotlin.Unit) {
            this.queryArgProfileConfig = QueryArgProfileConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var callerReference: String? = null
        override var comment: String? = null
        override var contentTypeProfileConfig: ContentTypeProfileConfig? = null
        override var queryArgProfileConfig: QueryArgProfileConfig? = null

        constructor(x: FieldLevelEncryptionConfig) : this() {
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.contentTypeProfileConfig = x.contentTypeProfileConfig
            this.queryArgProfileConfig = x.queryArgProfileConfig
        }

        override fun build(): FieldLevelEncryptionConfig = FieldLevelEncryptionConfig(this)
        override fun callerReference(callerReference: String): FluentBuilder = apply { this.callerReference = callerReference }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun contentTypeProfileConfig(contentTypeProfileConfig: ContentTypeProfileConfig): FluentBuilder = apply { this.contentTypeProfileConfig = contentTypeProfileConfig }
        override fun queryArgProfileConfig(queryArgProfileConfig: QueryArgProfileConfig): FluentBuilder = apply { this.queryArgProfileConfig = queryArgProfileConfig }
    }
}
