// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Complex data type for field-level encryption profiles that includes the encryption key and field pattern specifications.
 */
class EncryptionEntity private constructor(builder: BuilderImpl) {
    /**
     * Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted. You can provide the
     * full field name, or any beginning characters followed by a wildcard (*). You can't overlap field patterns. For example, you can't have
     * both ABC* and AB*. Note that field patterns are case-sensitive.
     */
    val fieldPatterns: FieldPatterns? = builder.fieldPatterns
    /**
     * The provider associated with the public key being used for encryption. This value must also be provided with the private key
     * for applications to be able to decrypt data.
     */
    val providerId: String? = builder.providerId
    /**
     * The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match
     * the patterns.
     */
    val publicKeyId: String? = builder.publicKeyId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EncryptionEntity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionEntity(")
        append("fieldPatterns=$fieldPatterns,")
        append("providerId=$providerId,")
        append("publicKeyId=$publicKeyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldPatterns?.hashCode() ?: 0
        result = 31 * result + (providerId?.hashCode() ?: 0)
        result = 31 * result + (publicKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EncryptionEntity

        if (fieldPatterns != other.fieldPatterns) return false
        if (providerId != other.providerId) return false
        if (publicKeyId != other.publicKeyId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EncryptionEntity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EncryptionEntity
        /**
         * Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted. You can provide the
         * full field name, or any beginning characters followed by a wildcard (*). You can't overlap field patterns. For example, you can't have
         * both ABC* and AB*. Note that field patterns are case-sensitive.
         */
        fun fieldPatterns(fieldPatterns: FieldPatterns): FluentBuilder
        /**
         * The provider associated with the public key being used for encryption. This value must also be provided with the private key
         * for applications to be able to decrypt data.
         */
        fun providerId(providerId: String): FluentBuilder
        /**
         * The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match
         * the patterns.
         */
        fun publicKeyId(publicKeyId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted. You can provide the
         * full field name, or any beginning characters followed by a wildcard (*). You can't overlap field patterns. For example, you can't have
         * both ABC* and AB*. Note that field patterns are case-sensitive.
         */
        var fieldPatterns: FieldPatterns?
        /**
         * The provider associated with the public key being used for encryption. This value must also be provided with the private key
         * for applications to be able to decrypt data.
         */
        var providerId: String?
        /**
         * The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match
         * the patterns.
         */
        var publicKeyId: String?

        fun build(): EncryptionEntity
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FieldPatterns] inside the given [block]
         */
        fun fieldPatterns(block: FieldPatterns.DslBuilder.() -> kotlin.Unit) {
            this.fieldPatterns = FieldPatterns.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fieldPatterns: FieldPatterns? = null
        override var providerId: String? = null
        override var publicKeyId: String? = null

        constructor(x: EncryptionEntity) : this() {
            this.fieldPatterns = x.fieldPatterns
            this.providerId = x.providerId
            this.publicKeyId = x.publicKeyId
        }

        override fun build(): EncryptionEntity = EncryptionEntity(this)
        override fun fieldPatterns(fieldPatterns: FieldPatterns): FluentBuilder = apply { this.fieldPatterns = fieldPatterns }
        override fun providerId(providerId: String): FluentBuilder = apply { this.providerId = providerId }
        override fun publicKeyId(publicKeyId: String): FluentBuilder = apply { this.publicKeyId = publicKeyId }
    }
}
