// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the information about a CloudFront distribution.
 */
class DistributionSummary private constructor(builder: BuilderImpl) {
    /**
     * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
     * publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
     * recordal status for CNAMEs associated with distributions.
     * For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
     * Signup, Accounts, and Credentials in Getting Started with Amazon Web Services services in China.
     */
    val aliasIcpRecordals: List<AliasIcpRecordal>? = builder.aliasIcpRecordals
    /**
     * A complex type that contains information about CNAMEs (alternate domain names), if any,
     * for this distribution.
     */
    val aliases: Aliases? = builder.aliases
    /**
     * The ARN (Amazon Resource Name) for the distribution. For example:
     * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
     * 123456789012 is your account ID.
     */
    val arn: String? = builder.arn
    /**
     * A complex type that contains zero or more CacheBehavior
     * elements.
     */
    val cacheBehaviors: CacheBehaviors? = builder.cacheBehaviors
    /**
     * The comment originally specified when this distribution was created.
     */
    val comment: String? = builder.comment
    /**
     * A complex type that contains zero or more CustomErrorResponses
     * elements.
     */
    val customErrorResponses: CustomErrorResponses? = builder.customErrorResponses
    /**
     * A complex type that describes the default cache behavior if you don't specify a
     * CacheBehavior element or if files don't match any of the values of
     * PathPattern in CacheBehavior elements. You must create exactly one
     * default cache behavior.
     */
    val defaultCacheBehavior: DefaultCacheBehavior? = builder.defaultCacheBehavior
    /**
     * The domain name that corresponds to the distribution, for example, d111111abcdef8.cloudfront.net.
     */
    val domainName: String? = builder.domainName
    /**
     * Whether the distribution is enabled to accept user requests for content.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * Specify the maximum HTTP version that you want viewers to use to communicate with
     * CloudFront. The default value for new web distributions is http2. Viewers that don't
     * support HTTP/2 will automatically use an earlier version.
     */
    val httpVersion: HttpVersion? = builder.httpVersion
    /**
     * The identifier for the distribution. For example:
     * EDFDVBD632BHDS5.
     */
    val id: String? = builder.id
    /**
     * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your
     * distribution.
     */
    val isIpv6Enabled: Boolean? = builder.isIpv6Enabled
    /**
     * The date and time the distribution was last modified.
     */
    val lastModifiedTime: Instant? = builder.lastModifiedTime
    /**
     * A complex type that contains information about origin groups for this
     * distribution.
     */
    val originGroups: OriginGroups? = builder.originGroups
    /**
     * A complex type that contains information about origins for this distribution.
     */
    val origins: Origins? = builder.origins
    /**
     * A complex type that contains information about price class for this streaming
     * distribution.
     */
    val priceClass: PriceClass? = builder.priceClass
    /**
     * A complex type that identifies ways in which you want to restrict distribution of your
     * content.
     */
    val restrictions: Restrictions? = builder.restrictions
    /**
     * The current status of the distribution. When the status is Deployed, the
     * distribution's information is propagated to all CloudFront edge locations.
     */
    val status: String? = builder.status
    /**
     * A complex type that determines the distribution’s SSL/TLS configuration for
     * communicating with viewers.
     */
    val viewerCertificate: ViewerCertificate? = builder.viewerCertificate
    /**
     * The Web ACL Id (if any) associated with the distribution.
     */
    val webAclId: String? = builder.webAclId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DistributionSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionSummary(")
        append("aliasIcpRecordals=$aliasIcpRecordals,")
        append("aliases=$aliases,")
        append("arn=$arn,")
        append("cacheBehaviors=$cacheBehaviors,")
        append("comment=$comment,")
        append("customErrorResponses=$customErrorResponses,")
        append("defaultCacheBehavior=$defaultCacheBehavior,")
        append("domainName=$domainName,")
        append("enabled=$enabled,")
        append("httpVersion=$httpVersion,")
        append("id=$id,")
        append("isIpv6Enabled=$isIpv6Enabled,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("originGroups=$originGroups,")
        append("origins=$origins,")
        append("priceClass=$priceClass,")
        append("restrictions=$restrictions,")
        append("status=$status,")
        append("viewerCertificate=$viewerCertificate,")
        append("webAclId=$webAclId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasIcpRecordals?.hashCode() ?: 0
        result = 31 * result + (aliases?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (cacheBehaviors?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (customErrorResponses?.hashCode() ?: 0)
        result = 31 * result + (defaultCacheBehavior?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (httpVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isIpv6Enabled?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (originGroups?.hashCode() ?: 0)
        result = 31 * result + (origins?.hashCode() ?: 0)
        result = 31 * result + (priceClass?.hashCode() ?: 0)
        result = 31 * result + (restrictions?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (viewerCertificate?.hashCode() ?: 0)
        result = 31 * result + (webAclId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DistributionSummary

        if (aliasIcpRecordals != other.aliasIcpRecordals) return false
        if (aliases != other.aliases) return false
        if (arn != other.arn) return false
        if (cacheBehaviors != other.cacheBehaviors) return false
        if (comment != other.comment) return false
        if (customErrorResponses != other.customErrorResponses) return false
        if (defaultCacheBehavior != other.defaultCacheBehavior) return false
        if (domainName != other.domainName) return false
        if (enabled != other.enabled) return false
        if (httpVersion != other.httpVersion) return false
        if (id != other.id) return false
        if (isIpv6Enabled != other.isIpv6Enabled) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (originGroups != other.originGroups) return false
        if (origins != other.origins) return false
        if (priceClass != other.priceClass) return false
        if (restrictions != other.restrictions) return false
        if (status != other.status) return false
        if (viewerCertificate != other.viewerCertificate) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DistributionSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DistributionSummary
        /**
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
         * publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
         * recordal status for CNAMEs associated with distributions.
         * For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
         * Signup, Accounts, and Credentials in Getting Started with Amazon Web Services services in China.
         */
        fun aliasIcpRecordals(aliasIcpRecordals: List<AliasIcpRecordal>): FluentBuilder
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any,
         * for this distribution.
         */
        fun aliases(aliases: Aliases): FluentBuilder
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
         * 123456789012 is your account ID.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * A complex type that contains zero or more CacheBehavior
         * elements.
         */
        fun cacheBehaviors(cacheBehaviors: CacheBehaviors): FluentBuilder
        /**
         * The comment originally specified when this distribution was created.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * A complex type that contains zero or more CustomErrorResponses
         * elements.
         */
        fun customErrorResponses(customErrorResponses: CustomErrorResponses): FluentBuilder
        /**
         * A complex type that describes the default cache behavior if you don't specify a
         * CacheBehavior element or if files don't match any of the values of
         * PathPattern in CacheBehavior elements. You must create exactly one
         * default cache behavior.
         */
        fun defaultCacheBehavior(defaultCacheBehavior: DefaultCacheBehavior): FluentBuilder
        /**
         * The domain name that corresponds to the distribution, for example, d111111abcdef8.cloudfront.net.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * Whether the distribution is enabled to accept user requests for content.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * Specify the maximum HTTP version that you want viewers to use to communicate with
         * CloudFront. The default value for new web distributions is http2. Viewers that don't
         * support HTTP/2 will automatically use an earlier version.
         */
        fun httpVersion(httpVersion: HttpVersion): FluentBuilder
        /**
         * The identifier for the distribution. For example:
         * EDFDVBD632BHDS5.
         */
        fun id(id: String): FluentBuilder
        /**
         * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your
         * distribution.
         */
        fun isIpv6Enabled(isIpv6Enabled: Boolean): FluentBuilder
        /**
         * The date and time the distribution was last modified.
         */
        fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder
        /**
         * A complex type that contains information about origin groups for this
         * distribution.
         */
        fun originGroups(originGroups: OriginGroups): FluentBuilder
        /**
         * A complex type that contains information about origins for this distribution.
         */
        fun origins(origins: Origins): FluentBuilder
        /**
         * A complex type that contains information about price class for this streaming
         * distribution.
         */
        fun priceClass(priceClass: PriceClass): FluentBuilder
        /**
         * A complex type that identifies ways in which you want to restrict distribution of your
         * content.
         */
        fun restrictions(restrictions: Restrictions): FluentBuilder
        /**
         * The current status of the distribution. When the status is Deployed, the
         * distribution's information is propagated to all CloudFront edge locations.
         */
        fun status(status: String): FluentBuilder
        /**
         * A complex type that determines the distribution’s SSL/TLS configuration for
         * communicating with viewers.
         */
        fun viewerCertificate(viewerCertificate: ViewerCertificate): FluentBuilder
        /**
         * The Web ACL Id (if any) associated with the distribution.
         */
        fun webAclId(webAclId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
         * publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
         * recordal status for CNAMEs associated with distributions.
         * For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
         * Signup, Accounts, and Credentials in Getting Started with Amazon Web Services services in China.
         */
        var aliasIcpRecordals: List<AliasIcpRecordal>?
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any,
         * for this distribution.
         */
        var aliases: Aliases?
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
         * 123456789012 is your account ID.
         */
        var arn: String?
        /**
         * A complex type that contains zero or more CacheBehavior
         * elements.
         */
        var cacheBehaviors: CacheBehaviors?
        /**
         * The comment originally specified when this distribution was created.
         */
        var comment: String?
        /**
         * A complex type that contains zero or more CustomErrorResponses
         * elements.
         */
        var customErrorResponses: CustomErrorResponses?
        /**
         * A complex type that describes the default cache behavior if you don't specify a
         * CacheBehavior element or if files don't match any of the values of
         * PathPattern in CacheBehavior elements. You must create exactly one
         * default cache behavior.
         */
        var defaultCacheBehavior: DefaultCacheBehavior?
        /**
         * The domain name that corresponds to the distribution, for example, d111111abcdef8.cloudfront.net.
         */
        var domainName: String?
        /**
         * Whether the distribution is enabled to accept user requests for content.
         */
        var enabled: Boolean?
        /**
         * Specify the maximum HTTP version that you want viewers to use to communicate with
         * CloudFront. The default value for new web distributions is http2. Viewers that don't
         * support HTTP/2 will automatically use an earlier version.
         */
        var httpVersion: HttpVersion?
        /**
         * The identifier for the distribution. For example:
         * EDFDVBD632BHDS5.
         */
        var id: String?
        /**
         * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your
         * distribution.
         */
        var isIpv6Enabled: Boolean?
        /**
         * The date and time the distribution was last modified.
         */
        var lastModifiedTime: Instant?
        /**
         * A complex type that contains information about origin groups for this
         * distribution.
         */
        var originGroups: OriginGroups?
        /**
         * A complex type that contains information about origins for this distribution.
         */
        var origins: Origins?
        /**
         * A complex type that contains information about price class for this streaming
         * distribution.
         */
        var priceClass: PriceClass?
        /**
         * A complex type that identifies ways in which you want to restrict distribution of your
         * content.
         */
        var restrictions: Restrictions?
        /**
         * The current status of the distribution. When the status is Deployed, the
         * distribution's information is propagated to all CloudFront edge locations.
         */
        var status: String?
        /**
         * A complex type that determines the distribution’s SSL/TLS configuration for
         * communicating with viewers.
         */
        var viewerCertificate: ViewerCertificate?
        /**
         * The Web ACL Id (if any) associated with the distribution.
         */
        var webAclId: String?

        fun build(): DistributionSummary
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Aliases] inside the given [block]
         */
        fun aliases(block: Aliases.DslBuilder.() -> kotlin.Unit) {
            this.aliases = Aliases.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors] inside the given [block]
         */
        fun cacheBehaviors(block: CacheBehaviors.DslBuilder.() -> kotlin.Unit) {
            this.cacheBehaviors = CacheBehaviors.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses] inside the given [block]
         */
        fun customErrorResponses(block: CustomErrorResponses.DslBuilder.() -> kotlin.Unit) {
            this.customErrorResponses = CustomErrorResponses.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior] inside the given [block]
         */
        fun defaultCacheBehavior(block: DefaultCacheBehavior.DslBuilder.() -> kotlin.Unit) {
            this.defaultCacheBehavior = DefaultCacheBehavior.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginGroups] inside the given [block]
         */
        fun originGroups(block: OriginGroups.DslBuilder.() -> kotlin.Unit) {
            this.originGroups = OriginGroups.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Origins] inside the given [block]
         */
        fun origins(block: Origins.DslBuilder.() -> kotlin.Unit) {
            this.origins = Origins.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Restrictions] inside the given [block]
         */
        fun restrictions(block: Restrictions.DslBuilder.() -> kotlin.Unit) {
            this.restrictions = Restrictions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate] inside the given [block]
         */
        fun viewerCertificate(block: ViewerCertificate.DslBuilder.() -> kotlin.Unit) {
            this.viewerCertificate = ViewerCertificate.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var aliasIcpRecordals: List<AliasIcpRecordal>? = null
        override var aliases: Aliases? = null
        override var arn: String? = null
        override var cacheBehaviors: CacheBehaviors? = null
        override var comment: String? = null
        override var customErrorResponses: CustomErrorResponses? = null
        override var defaultCacheBehavior: DefaultCacheBehavior? = null
        override var domainName: String? = null
        override var enabled: Boolean? = null
        override var httpVersion: HttpVersion? = null
        override var id: String? = null
        override var isIpv6Enabled: Boolean? = null
        override var lastModifiedTime: Instant? = null
        override var originGroups: OriginGroups? = null
        override var origins: Origins? = null
        override var priceClass: PriceClass? = null
        override var restrictions: Restrictions? = null
        override var status: String? = null
        override var viewerCertificate: ViewerCertificate? = null
        override var webAclId: String? = null

        constructor(x: DistributionSummary) : this() {
            this.aliasIcpRecordals = x.aliasIcpRecordals
            this.aliases = x.aliases
            this.arn = x.arn
            this.cacheBehaviors = x.cacheBehaviors
            this.comment = x.comment
            this.customErrorResponses = x.customErrorResponses
            this.defaultCacheBehavior = x.defaultCacheBehavior
            this.domainName = x.domainName
            this.enabled = x.enabled
            this.httpVersion = x.httpVersion
            this.id = x.id
            this.isIpv6Enabled = x.isIpv6Enabled
            this.lastModifiedTime = x.lastModifiedTime
            this.originGroups = x.originGroups
            this.origins = x.origins
            this.priceClass = x.priceClass
            this.restrictions = x.restrictions
            this.status = x.status
            this.viewerCertificate = x.viewerCertificate
            this.webAclId = x.webAclId
        }

        override fun build(): DistributionSummary = DistributionSummary(this)
        override fun aliasIcpRecordals(aliasIcpRecordals: List<AliasIcpRecordal>): FluentBuilder = apply { this.aliasIcpRecordals = aliasIcpRecordals }
        override fun aliases(aliases: Aliases): FluentBuilder = apply { this.aliases = aliases }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun cacheBehaviors(cacheBehaviors: CacheBehaviors): FluentBuilder = apply { this.cacheBehaviors = cacheBehaviors }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun customErrorResponses(customErrorResponses: CustomErrorResponses): FluentBuilder = apply { this.customErrorResponses = customErrorResponses }
        override fun defaultCacheBehavior(defaultCacheBehavior: DefaultCacheBehavior): FluentBuilder = apply { this.defaultCacheBehavior = defaultCacheBehavior }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun httpVersion(httpVersion: HttpVersion): FluentBuilder = apply { this.httpVersion = httpVersion }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun isIpv6Enabled(isIpv6Enabled: Boolean): FluentBuilder = apply { this.isIpv6Enabled = isIpv6Enabled }
        override fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder = apply { this.lastModifiedTime = lastModifiedTime }
        override fun originGroups(originGroups: OriginGroups): FluentBuilder = apply { this.originGroups = originGroups }
        override fun origins(origins: Origins): FluentBuilder = apply { this.origins = origins }
        override fun priceClass(priceClass: PriceClass): FluentBuilder = apply { this.priceClass = priceClass }
        override fun restrictions(restrictions: Restrictions): FluentBuilder = apply { this.restrictions = restrictions }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun viewerCertificate(viewerCertificate: ViewerCertificate): FluentBuilder = apply { this.viewerCertificate = viewerCertificate }
        override fun webAclId(webAclId: String): FluentBuilder = apply { this.webAclId = webAclId }
    }
}
