// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of distribution IDs.
 */
class DistributionIdList private constructor(builder: BuilderImpl) {
    /**
     * A flag that indicates whether more distribution IDs remain to be listed. If your
     * results were truncated, you can make a subsequent request using the Marker
     * request field to retrieve more distribution IDs in the list.
     */
    val isTruncated: Boolean? = builder.isTruncated
    /**
     * Contains the distribution IDs in the list.
     */
    val items: List<String>? = builder.items
    /**
     * The value provided in the Marker request field.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of distribution IDs requested.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * Contains the value that you should use in the Marker field of a
     * subsequent request to continue listing distribution IDs where you left off.
     */
    val nextMarker: String? = builder.nextMarker
    /**
     * The total number of distribution IDs returned in the response.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DistributionIdList = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionIdList(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DistributionIdList

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DistributionIdList = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DistributionIdList
        /**
         * A flag that indicates whether more distribution IDs remain to be listed. If your
         * results were truncated, you can make a subsequent request using the Marker
         * request field to retrieve more distribution IDs in the list.
         */
        fun isTruncated(isTruncated: Boolean): FluentBuilder
        /**
         * Contains the distribution IDs in the list.
         */
        fun items(items: List<String>): FluentBuilder
        /**
         * The value provided in the Marker request field.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of distribution IDs requested.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * Contains the value that you should use in the Marker field of a
         * subsequent request to continue listing distribution IDs where you left off.
         */
        fun nextMarker(nextMarker: String): FluentBuilder
        /**
         * The total number of distribution IDs returned in the response.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A flag that indicates whether more distribution IDs remain to be listed. If your
         * results were truncated, you can make a subsequent request using the Marker
         * request field to retrieve more distribution IDs in the list.
         */
        var isTruncated: Boolean?
        /**
         * Contains the distribution IDs in the list.
         */
        var items: List<String>?
        /**
         * The value provided in the Marker request field.
         */
        var marker: String?
        /**
         * The maximum number of distribution IDs requested.
         */
        var maxItems: Int?
        /**
         * Contains the value that you should use in the Marker field of a
         * subsequent request to continue listing distribution IDs where you left off.
         */
        var nextMarker: String?
        /**
         * The total number of distribution IDs returned in the response.
         */
        var quantity: Int?

        fun build(): DistributionIdList
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var isTruncated: Boolean? = null
        override var items: List<String>? = null
        override var marker: String? = null
        override var maxItems: Int? = null
        override var nextMarker: String? = null
        override var quantity: Int? = null

        constructor(x: DistributionIdList) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        override fun build(): DistributionIdList = DistributionIdList(this)
        override fun isTruncated(isTruncated: Boolean): FluentBuilder = apply { this.isTruncated = isTruncated }
        override fun items(items: List<String>): FluentBuilder = apply { this.items = items }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun nextMarker(nextMarker: String): FluentBuilder = apply { this.nextMarker = nextMarker }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
