// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A distribution configuration.
 */
class DistributionConfig private constructor(builder: BuilderImpl) {
    /**
     * A complex type that contains information about CNAMEs (alternate domain names), if any,
     * for this distribution.
     */
    val aliases: Aliases? = builder.aliases
    /**
     * A complex type that contains zero or more CacheBehavior elements.
     */
    val cacheBehaviors: CacheBehaviors? = builder.cacheBehaviors
    /**
     * A unique value (for example, a date-time stamp) that ensures that the request can't be
     * replayed.
     * If the value of CallerReference is new (regardless of the content of the
     * DistributionConfig object), CloudFront creates a new distribution.
     * If CallerReference is a value that you already sent in a previous request to
     * create a distribution, CloudFront returns a DistributionAlreadyExists error.
     */
    val callerReference: String? = builder.callerReference
    /**
     * An optional comment to describe the distribution. The comment cannot be longer than 128
     * characters.
     */
    val comment: String? = builder.comment
    /**
     * A complex type that controls the following:
     * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
     * messages before returning the response to the viewer.
     * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
     * For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses in the
     * Amazon CloudFront Developer Guide.
     */
    val customErrorResponses: CustomErrorResponses? = builder.customErrorResponses
    /**
     * A complex type that describes the default cache behavior if you don't specify a
     * CacheBehavior element or if files don't match any of the values of
     * PathPattern in CacheBehavior elements. You must create exactly one
     * default cache behavior.
     */
    val defaultCacheBehavior: DefaultCacheBehavior? = builder.defaultCacheBehavior
    /**
     * The object that you want CloudFront to request from your origin (for example,
     * index.html) when a viewer requests the root URL for your distribution
     * (http://www.example.com) instead of an object in your distribution
     * (http://www.example.com/product-description.html). Specifying a default root
     * object avoids exposing the contents of your distribution.
     * Specify only the object name, for example, index.html. Don't add a
     * / before the object name.
     * If you don't want to specify a default root object when you create a distribution,
     * include an empty DefaultRootObject element.
     * To delete the default root object from an existing distribution, update the
     * distribution configuration and include an empty DefaultRootObject
     * element.
     * To replace the default root object, update the distribution configuration and specify
     * the new object.
     * For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object in the
     * Amazon CloudFront Developer Guide.
     */
    val defaultRootObject: String? = builder.defaultRootObject
    /**
     * From this field, you can enable or disable the selected distribution.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * (Optional) Specify the maximum HTTP version that you want viewers to use to communicate
     * with CloudFront. The default value for new web distributions is http2. Viewers that don't support
     * HTTP/2 automatically use an earlier HTTP version.
     * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must
     * support Server Name Identification (SNI).
     * In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency.
     * You can improve performance by optimizing for HTTP/2. For more information, do an Internet
     * search for "http/2 optimization."
     */
    val httpVersion: HttpVersion? = builder.httpVersion
    /**
     * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your
     * distribution, specify true. If you specify false, CloudFront responds to
     * IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
     * This allows viewers to submit a second request, for an IPv4 address for your distribution.
     * In general, you should enable IPv6 if you have users on IPv6 networks who want to
     * access your content. However, if you're using signed URLs or signed cookies to restrict access
     * to your content, and if you're using a custom policy that includes the IpAddress
     * parameter to restrict the IP addresses that can access your content, don't enable IPv6. If
     * you want to restrict access to some content by IP address and not restrict access to other
     * content (or restrict access but not by IP address), you can create two distributions. For more
     * information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy in the Amazon CloudFront Developer Guide.
     * If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront
     * distribution, you need to create a second alias resource record set when both of the following
     * are true:
     * You enable IPv6 for the distribution
     * You're using alternate domain names in the URLs for your objects
     * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic
     * to an Amazon CloudFront Web Distribution by Using Your Domain Name in the Route 53 Amazon Web Services Integration
     * Developer Guide.
     * If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS
     * service, you don't need to make any changes. A CNAME record will route traffic to your
     * distribution regardless of the IP address format of the viewer request.
     */
    val isIpv6Enabled: Boolean? = builder.isIpv6Enabled
    /**
     * A complex type that controls whether access logs are written for the
     * distribution.
     * For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
     * Logs in the Amazon CloudFront Developer Guide.
     */
    val logging: LoggingConfig? = builder.logging
    /**
     * A complex type that contains information about origin groups for this
     * distribution.
     */
    val originGroups: OriginGroups? = builder.originGroups
    /**
     * A complex type that contains information about origins for this distribution.
     */
    val origins: Origins? = builder.origins
    /**
     * The price class that corresponds with the maximum price that you want to pay for CloudFront
     * service. If you specify PriceClass_All, CloudFront responds to requests for your
     * objects from all CloudFront edge locations.
     * If you specify a price class other than PriceClass_All, CloudFront serves your
     * objects from the CloudFront edge location that has the lowest latency among the edge locations in
     * your price class. Viewers who are in or near regions that are excluded from your specified
     * price class may encounter slower performance.
     * For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
     * for a CloudFront Distribution in the Amazon CloudFront Developer Guide. For
     * information about CloudFront pricing, including how price classes (such as Price Class 100)
     * map to CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
     * Pricing.
     */
    val priceClass: PriceClass? = builder.priceClass
    /**
     * A complex type that identifies ways in which you want to restrict distribution of your
     * content.
     */
    val restrictions: Restrictions? = builder.restrictions
    /**
     * A complex type that determines the distribution’s SSL/TLS configuration for
     * communicating with viewers.
     */
    val viewerCertificate: ViewerCertificate? = builder.viewerCertificate
    /**
     * A unique identifier that specifies the WAF web ACL, if any, to associate
     * with this distribution. To specify a web ACL created using the latest version of
     * WAF, use the ACL ARN, for example
     * arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
     * To specify a web ACL created using WAF Classic, use the ACL ID, for example
     * 473e64fd-f30b-4765-81a0-62ad96dd167a.
     * WAF is a web application firewall that lets you monitor the HTTP and HTTPS
     * requests that are forwarded to CloudFront, and lets you control access to your content. Based on
     * conditions that you specify, such as the IP addresses that requests originate from or the
     * values of query strings, CloudFront responds to requests either with the requested content or with
     * an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page
     * when a request is blocked. For more information about WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF
     * Developer Guide.
     */
    val webAclId: String? = builder.webAclId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DistributionConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionConfig(")
        append("aliases=$aliases,")
        append("cacheBehaviors=$cacheBehaviors,")
        append("callerReference=$callerReference,")
        append("comment=*** Sensitive Data Redacted ***,")
        append("customErrorResponses=$customErrorResponses,")
        append("defaultCacheBehavior=$defaultCacheBehavior,")
        append("defaultRootObject=$defaultRootObject,")
        append("enabled=$enabled,")
        append("httpVersion=$httpVersion,")
        append("isIpv6Enabled=$isIpv6Enabled,")
        append("logging=$logging,")
        append("originGroups=$originGroups,")
        append("origins=$origins,")
        append("priceClass=$priceClass,")
        append("restrictions=$restrictions,")
        append("viewerCertificate=$viewerCertificate,")
        append("webAclId=$webAclId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases?.hashCode() ?: 0
        result = 31 * result + (cacheBehaviors?.hashCode() ?: 0)
        result = 31 * result + (callerReference?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (customErrorResponses?.hashCode() ?: 0)
        result = 31 * result + (defaultCacheBehavior?.hashCode() ?: 0)
        result = 31 * result + (defaultRootObject?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (httpVersion?.hashCode() ?: 0)
        result = 31 * result + (isIpv6Enabled?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (originGroups?.hashCode() ?: 0)
        result = 31 * result + (origins?.hashCode() ?: 0)
        result = 31 * result + (priceClass?.hashCode() ?: 0)
        result = 31 * result + (restrictions?.hashCode() ?: 0)
        result = 31 * result + (viewerCertificate?.hashCode() ?: 0)
        result = 31 * result + (webAclId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DistributionConfig

        if (aliases != other.aliases) return false
        if (cacheBehaviors != other.cacheBehaviors) return false
        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (customErrorResponses != other.customErrorResponses) return false
        if (defaultCacheBehavior != other.defaultCacheBehavior) return false
        if (defaultRootObject != other.defaultRootObject) return false
        if (enabled != other.enabled) return false
        if (httpVersion != other.httpVersion) return false
        if (isIpv6Enabled != other.isIpv6Enabled) return false
        if (logging != other.logging) return false
        if (originGroups != other.originGroups) return false
        if (origins != other.origins) return false
        if (priceClass != other.priceClass) return false
        if (restrictions != other.restrictions) return false
        if (viewerCertificate != other.viewerCertificate) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DistributionConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DistributionConfig
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any,
         * for this distribution.
         */
        fun aliases(aliases: Aliases): FluentBuilder
        /**
         * A complex type that contains zero or more CacheBehavior elements.
         */
        fun cacheBehaviors(cacheBehaviors: CacheBehaviors): FluentBuilder
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be
         * replayed.
         * If the value of CallerReference is new (regardless of the content of the
         * DistributionConfig object), CloudFront creates a new distribution.
         * If CallerReference is a value that you already sent in a previous request to
         * create a distribution, CloudFront returns a DistributionAlreadyExists error.
         */
        fun callerReference(callerReference: String): FluentBuilder
        /**
         * An optional comment to describe the distribution. The comment cannot be longer than 128
         * characters.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * A complex type that controls the following:
         * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
         * messages before returning the response to the viewer.
         * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         * For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses in the
         * Amazon CloudFront Developer Guide.
         */
        fun customErrorResponses(customErrorResponses: CustomErrorResponses): FluentBuilder
        /**
         * A complex type that describes the default cache behavior if you don't specify a
         * CacheBehavior element or if files don't match any of the values of
         * PathPattern in CacheBehavior elements. You must create exactly one
         * default cache behavior.
         */
        fun defaultCacheBehavior(defaultCacheBehavior: DefaultCacheBehavior): FluentBuilder
        /**
         * The object that you want CloudFront to request from your origin (for example,
         * index.html) when a viewer requests the root URL for your distribution
         * (http://www.example.com) instead of an object in your distribution
         * (http://www.example.com/product-description.html). Specifying a default root
         * object avoids exposing the contents of your distribution.
         * Specify only the object name, for example, index.html. Don't add a
         * / before the object name.
         * If you don't want to specify a default root object when you create a distribution,
         * include an empty DefaultRootObject element.
         * To delete the default root object from an existing distribution, update the
         * distribution configuration and include an empty DefaultRootObject
         * element.
         * To replace the default root object, update the distribution configuration and specify
         * the new object.
         * For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object in the
         * Amazon CloudFront Developer Guide.
         */
        fun defaultRootObject(defaultRootObject: String): FluentBuilder
        /**
         * From this field, you can enable or disable the selected distribution.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * (Optional) Specify the maximum HTTP version that you want viewers to use to communicate
         * with CloudFront. The default value for new web distributions is http2. Viewers that don't support
         * HTTP/2 automatically use an earlier HTTP version.
         * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must
         * support Server Name Identification (SNI).
         * In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency.
         * You can improve performance by optimizing for HTTP/2. For more information, do an Internet
         * search for "http/2 optimization."
         */
        fun httpVersion(httpVersion: HttpVersion): FluentBuilder
        /**
         * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your
         * distribution, specify true. If you specify false, CloudFront responds to
         * IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
         * This allows viewers to submit a second request, for an IPv4 address for your distribution.
         * In general, you should enable IPv6 if you have users on IPv6 networks who want to
         * access your content. However, if you're using signed URLs or signed cookies to restrict access
         * to your content, and if you're using a custom policy that includes the IpAddress
         * parameter to restrict the IP addresses that can access your content, don't enable IPv6. If
         * you want to restrict access to some content by IP address and not restrict access to other
         * content (or restrict access but not by IP address), you can create two distributions. For more
         * information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy in the Amazon CloudFront Developer Guide.
         * If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront
         * distribution, you need to create a second alias resource record set when both of the following
         * are true:
         * You enable IPv6 for the distribution
         * You're using alternate domain names in the URLs for your objects
         * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic
         * to an Amazon CloudFront Web Distribution by Using Your Domain Name in the Route 53 Amazon Web Services Integration
         * Developer Guide.
         * If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS
         * service, you don't need to make any changes. A CNAME record will route traffic to your
         * distribution regardless of the IP address format of the viewer request.
         */
        fun isIpv6Enabled(isIpv6Enabled: Boolean): FluentBuilder
        /**
         * A complex type that controls whether access logs are written for the
         * distribution.
         * For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
         * Logs in the Amazon CloudFront Developer Guide.
         */
        fun logging(logging: LoggingConfig): FluentBuilder
        /**
         * A complex type that contains information about origin groups for this
         * distribution.
         */
        fun originGroups(originGroups: OriginGroups): FluentBuilder
        /**
         * A complex type that contains information about origins for this distribution.
         */
        fun origins(origins: Origins): FluentBuilder
        /**
         * The price class that corresponds with the maximum price that you want to pay for CloudFront
         * service. If you specify PriceClass_All, CloudFront responds to requests for your
         * objects from all CloudFront edge locations.
         * If you specify a price class other than PriceClass_All, CloudFront serves your
         * objects from the CloudFront edge location that has the lowest latency among the edge locations in
         * your price class. Viewers who are in or near regions that are excluded from your specified
         * price class may encounter slower performance.
         * For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
         * for a CloudFront Distribution in the Amazon CloudFront Developer Guide. For
         * information about CloudFront pricing, including how price classes (such as Price Class 100)
         * map to CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
         * Pricing.
         */
        fun priceClass(priceClass: PriceClass): FluentBuilder
        /**
         * A complex type that identifies ways in which you want to restrict distribution of your
         * content.
         */
        fun restrictions(restrictions: Restrictions): FluentBuilder
        /**
         * A complex type that determines the distribution’s SSL/TLS configuration for
         * communicating with viewers.
         */
        fun viewerCertificate(viewerCertificate: ViewerCertificate): FluentBuilder
        /**
         * A unique identifier that specifies the WAF web ACL, if any, to associate
         * with this distribution. To specify a web ACL created using the latest version of
         * WAF, use the ACL ARN, for example
         * arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
         * To specify a web ACL created using WAF Classic, use the ACL ID, for example
         * 473e64fd-f30b-4765-81a0-62ad96dd167a.
         * WAF is a web application firewall that lets you monitor the HTTP and HTTPS
         * requests that are forwarded to CloudFront, and lets you control access to your content. Based on
         * conditions that you specify, such as the IP addresses that requests originate from or the
         * values of query strings, CloudFront responds to requests either with the requested content or with
         * an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page
         * when a request is blocked. For more information about WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF
         * Developer Guide.
         */
        fun webAclId(webAclId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any,
         * for this distribution.
         */
        var aliases: Aliases?
        /**
         * A complex type that contains zero or more CacheBehavior elements.
         */
        var cacheBehaviors: CacheBehaviors?
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be
         * replayed.
         * If the value of CallerReference is new (regardless of the content of the
         * DistributionConfig object), CloudFront creates a new distribution.
         * If CallerReference is a value that you already sent in a previous request to
         * create a distribution, CloudFront returns a DistributionAlreadyExists error.
         */
        var callerReference: String?
        /**
         * An optional comment to describe the distribution. The comment cannot be longer than 128
         * characters.
         */
        var comment: String?
        /**
         * A complex type that controls the following:
         * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
         * messages before returning the response to the viewer.
         * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         * For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses in the
         * Amazon CloudFront Developer Guide.
         */
        var customErrorResponses: CustomErrorResponses?
        /**
         * A complex type that describes the default cache behavior if you don't specify a
         * CacheBehavior element or if files don't match any of the values of
         * PathPattern in CacheBehavior elements. You must create exactly one
         * default cache behavior.
         */
        var defaultCacheBehavior: DefaultCacheBehavior?
        /**
         * The object that you want CloudFront to request from your origin (for example,
         * index.html) when a viewer requests the root URL for your distribution
         * (http://www.example.com) instead of an object in your distribution
         * (http://www.example.com/product-description.html). Specifying a default root
         * object avoids exposing the contents of your distribution.
         * Specify only the object name, for example, index.html. Don't add a
         * / before the object name.
         * If you don't want to specify a default root object when you create a distribution,
         * include an empty DefaultRootObject element.
         * To delete the default root object from an existing distribution, update the
         * distribution configuration and include an empty DefaultRootObject
         * element.
         * To replace the default root object, update the distribution configuration and specify
         * the new object.
         * For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object in the
         * Amazon CloudFront Developer Guide.
         */
        var defaultRootObject: String?
        /**
         * From this field, you can enable or disable the selected distribution.
         */
        var enabled: Boolean?
        /**
         * (Optional) Specify the maximum HTTP version that you want viewers to use to communicate
         * with CloudFront. The default value for new web distributions is http2. Viewers that don't support
         * HTTP/2 automatically use an earlier HTTP version.
         * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must
         * support Server Name Identification (SNI).
         * In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency.
         * You can improve performance by optimizing for HTTP/2. For more information, do an Internet
         * search for "http/2 optimization."
         */
        var httpVersion: HttpVersion?
        /**
         * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your
         * distribution, specify true. If you specify false, CloudFront responds to
         * IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
         * This allows viewers to submit a second request, for an IPv4 address for your distribution.
         * In general, you should enable IPv6 if you have users on IPv6 networks who want to
         * access your content. However, if you're using signed URLs or signed cookies to restrict access
         * to your content, and if you're using a custom policy that includes the IpAddress
         * parameter to restrict the IP addresses that can access your content, don't enable IPv6. If
         * you want to restrict access to some content by IP address and not restrict access to other
         * content (or restrict access but not by IP address), you can create two distributions. For more
         * information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy in the Amazon CloudFront Developer Guide.
         * If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront
         * distribution, you need to create a second alias resource record set when both of the following
         * are true:
         * You enable IPv6 for the distribution
         * You're using alternate domain names in the URLs for your objects
         * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic
         * to an Amazon CloudFront Web Distribution by Using Your Domain Name in the Route 53 Amazon Web Services Integration
         * Developer Guide.
         * If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS
         * service, you don't need to make any changes. A CNAME record will route traffic to your
         * distribution regardless of the IP address format of the viewer request.
         */
        var isIpv6Enabled: Boolean?
        /**
         * A complex type that controls whether access logs are written for the
         * distribution.
         * For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
         * Logs in the Amazon CloudFront Developer Guide.
         */
        var logging: LoggingConfig?
        /**
         * A complex type that contains information about origin groups for this
         * distribution.
         */
        var originGroups: OriginGroups?
        /**
         * A complex type that contains information about origins for this distribution.
         */
        var origins: Origins?
        /**
         * The price class that corresponds with the maximum price that you want to pay for CloudFront
         * service. If you specify PriceClass_All, CloudFront responds to requests for your
         * objects from all CloudFront edge locations.
         * If you specify a price class other than PriceClass_All, CloudFront serves your
         * objects from the CloudFront edge location that has the lowest latency among the edge locations in
         * your price class. Viewers who are in or near regions that are excluded from your specified
         * price class may encounter slower performance.
         * For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
         * for a CloudFront Distribution in the Amazon CloudFront Developer Guide. For
         * information about CloudFront pricing, including how price classes (such as Price Class 100)
         * map to CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
         * Pricing.
         */
        var priceClass: PriceClass?
        /**
         * A complex type that identifies ways in which you want to restrict distribution of your
         * content.
         */
        var restrictions: Restrictions?
        /**
         * A complex type that determines the distribution’s SSL/TLS configuration for
         * communicating with viewers.
         */
        var viewerCertificate: ViewerCertificate?
        /**
         * A unique identifier that specifies the WAF web ACL, if any, to associate
         * with this distribution. To specify a web ACL created using the latest version of
         * WAF, use the ACL ARN, for example
         * arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
         * To specify a web ACL created using WAF Classic, use the ACL ID, for example
         * 473e64fd-f30b-4765-81a0-62ad96dd167a.
         * WAF is a web application firewall that lets you monitor the HTTP and HTTPS
         * requests that are forwarded to CloudFront, and lets you control access to your content. Based on
         * conditions that you specify, such as the IP addresses that requests originate from or the
         * values of query strings, CloudFront responds to requests either with the requested content or with
         * an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page
         * when a request is blocked. For more information about WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF
         * Developer Guide.
         */
        var webAclId: String?

        fun build(): DistributionConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Aliases] inside the given [block]
         */
        fun aliases(block: Aliases.DslBuilder.() -> kotlin.Unit) {
            this.aliases = Aliases.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors] inside the given [block]
         */
        fun cacheBehaviors(block: CacheBehaviors.DslBuilder.() -> kotlin.Unit) {
            this.cacheBehaviors = CacheBehaviors.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses] inside the given [block]
         */
        fun customErrorResponses(block: CustomErrorResponses.DslBuilder.() -> kotlin.Unit) {
            this.customErrorResponses = CustomErrorResponses.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior] inside the given [block]
         */
        fun defaultCacheBehavior(block: DefaultCacheBehavior.DslBuilder.() -> kotlin.Unit) {
            this.defaultCacheBehavior = DefaultCacheBehavior.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.LoggingConfig] inside the given [block]
         */
        fun logging(block: LoggingConfig.DslBuilder.() -> kotlin.Unit) {
            this.logging = LoggingConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginGroups] inside the given [block]
         */
        fun originGroups(block: OriginGroups.DslBuilder.() -> kotlin.Unit) {
            this.originGroups = OriginGroups.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Origins] inside the given [block]
         */
        fun origins(block: Origins.DslBuilder.() -> kotlin.Unit) {
            this.origins = Origins.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Restrictions] inside the given [block]
         */
        fun restrictions(block: Restrictions.DslBuilder.() -> kotlin.Unit) {
            this.restrictions = Restrictions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate] inside the given [block]
         */
        fun viewerCertificate(block: ViewerCertificate.DslBuilder.() -> kotlin.Unit) {
            this.viewerCertificate = ViewerCertificate.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var aliases: Aliases? = null
        override var cacheBehaviors: CacheBehaviors? = null
        override var callerReference: String? = null
        override var comment: String? = null
        override var customErrorResponses: CustomErrorResponses? = null
        override var defaultCacheBehavior: DefaultCacheBehavior? = null
        override var defaultRootObject: String? = null
        override var enabled: Boolean? = null
        override var httpVersion: HttpVersion? = null
        override var isIpv6Enabled: Boolean? = null
        override var logging: LoggingConfig? = null
        override var originGroups: OriginGroups? = null
        override var origins: Origins? = null
        override var priceClass: PriceClass? = null
        override var restrictions: Restrictions? = null
        override var viewerCertificate: ViewerCertificate? = null
        override var webAclId: String? = null

        constructor(x: DistributionConfig) : this() {
            this.aliases = x.aliases
            this.cacheBehaviors = x.cacheBehaviors
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.customErrorResponses = x.customErrorResponses
            this.defaultCacheBehavior = x.defaultCacheBehavior
            this.defaultRootObject = x.defaultRootObject
            this.enabled = x.enabled
            this.httpVersion = x.httpVersion
            this.isIpv6Enabled = x.isIpv6Enabled
            this.logging = x.logging
            this.originGroups = x.originGroups
            this.origins = x.origins
            this.priceClass = x.priceClass
            this.restrictions = x.restrictions
            this.viewerCertificate = x.viewerCertificate
            this.webAclId = x.webAclId
        }

        override fun build(): DistributionConfig = DistributionConfig(this)
        override fun aliases(aliases: Aliases): FluentBuilder = apply { this.aliases = aliases }
        override fun cacheBehaviors(cacheBehaviors: CacheBehaviors): FluentBuilder = apply { this.cacheBehaviors = cacheBehaviors }
        override fun callerReference(callerReference: String): FluentBuilder = apply { this.callerReference = callerReference }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun customErrorResponses(customErrorResponses: CustomErrorResponses): FluentBuilder = apply { this.customErrorResponses = customErrorResponses }
        override fun defaultCacheBehavior(defaultCacheBehavior: DefaultCacheBehavior): FluentBuilder = apply { this.defaultCacheBehavior = defaultCacheBehavior }
        override fun defaultRootObject(defaultRootObject: String): FluentBuilder = apply { this.defaultRootObject = defaultRootObject }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun httpVersion(httpVersion: HttpVersion): FluentBuilder = apply { this.httpVersion = httpVersion }
        override fun isIpv6Enabled(isIpv6Enabled: Boolean): FluentBuilder = apply { this.isIpv6Enabled = isIpv6Enabled }
        override fun logging(logging: LoggingConfig): FluentBuilder = apply { this.logging = logging }
        override fun originGroups(originGroups: OriginGroups): FluentBuilder = apply { this.originGroups = originGroups }
        override fun origins(origins: Origins): FluentBuilder = apply { this.origins = origins }
        override fun priceClass(priceClass: PriceClass): FluentBuilder = apply { this.priceClass = priceClass }
        override fun restrictions(restrictions: Restrictions): FluentBuilder = apply { this.restrictions = restrictions }
        override fun viewerCertificate(viewerCertificate: ViewerCertificate): FluentBuilder = apply { this.viewerCertificate = viewerCertificate }
        override fun webAclId(webAclId: String): FluentBuilder = apply { this.webAclId = webAclId }
    }
}
