// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A distribution tells CloudFront where you want content to be delivered from, and the details about how to
 * track and manage content delivery.
 */
class Distribution private constructor(builder: BuilderImpl) {
    /**
     * CloudFront automatically adds this field to the response if you’ve configured a cache
     * behavior in this distribution to serve private content using key groups. This field
     * contains a list of key groups and the public keys in each key group that CloudFront can use to
     * verify the signatures of signed URLs or signed cookies.
     */
    val activeTrustedKeyGroups: ActiveTrustedKeyGroups? = builder.activeTrustedKeyGroups
    /**
     * We recommend using TrustedKeyGroups instead of
     * TrustedSigners.
     * CloudFront automatically adds this field to the response if you’ve configured a cache behavior in
     * this distribution to serve private content using trusted signers. This field contains a
     * list of account IDs and the active CloudFront key pairs in each account that CloudFront can use
     * to verify the signatures of signed URLs or signed cookies.
     */
    val activeTrustedSigners: ActiveTrustedSigners? = builder.activeTrustedSigners
    /**
     * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
     * publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
     * recordal status for CNAMEs associated with distributions.
     * For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
     * Signup, Accounts, and Credentials in Getting Started with Amazon Web Services services in China.
     */
    val aliasIcpRecordals: List<AliasIcpRecordal>? = builder.aliasIcpRecordals
    /**
     * The ARN (Amazon Resource Name) for the distribution. For example:
     * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
     * 123456789012 is your account ID.
     */
    val arn: String? = builder.arn
    /**
     * The current configuration information for the distribution. Send a GET
     * request to the /CloudFront API version/distribution ID/config
     * resource.
     */
    val distributionConfig: DistributionConfig? = builder.distributionConfig
    /**
     * The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
     */
    val domainName: String? = builder.domainName
    /**
     * The identifier for the distribution. For example: EDFDVBD632BHDS5.
     */
    val id: String? = builder.id
    /**
     * The number of invalidation batches currently in progress.
     */
    val inProgressInvalidationBatches: Int? = builder.inProgressInvalidationBatches
    /**
     * The date and time the distribution was last modified.
     */
    val lastModifiedTime: Instant? = builder.lastModifiedTime
    /**
     * This response element indicates the current status of the distribution. When the status
     * is Deployed, the distribution's information is fully propagated to all CloudFront edge
     * locations.
     */
    val status: String? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Distribution = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Distribution(")
        append("activeTrustedKeyGroups=$activeTrustedKeyGroups,")
        append("activeTrustedSigners=$activeTrustedSigners,")
        append("aliasIcpRecordals=$aliasIcpRecordals,")
        append("arn=$arn,")
        append("distributionConfig=$distributionConfig,")
        append("domainName=$domainName,")
        append("id=$id,")
        append("inProgressInvalidationBatches=$inProgressInvalidationBatches,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeTrustedKeyGroups?.hashCode() ?: 0
        result = 31 * result + (activeTrustedSigners?.hashCode() ?: 0)
        result = 31 * result + (aliasIcpRecordals?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (distributionConfig?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (inProgressInvalidationBatches ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Distribution

        if (activeTrustedKeyGroups != other.activeTrustedKeyGroups) return false
        if (activeTrustedSigners != other.activeTrustedSigners) return false
        if (aliasIcpRecordals != other.aliasIcpRecordals) return false
        if (arn != other.arn) return false
        if (distributionConfig != other.distributionConfig) return false
        if (domainName != other.domainName) return false
        if (id != other.id) return false
        if (inProgressInvalidationBatches != other.inProgressInvalidationBatches) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Distribution = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Distribution
        /**
         * CloudFront automatically adds this field to the response if you’ve configured a cache
         * behavior in this distribution to serve private content using key groups. This field
         * contains a list of key groups and the public keys in each key group that CloudFront can use to
         * verify the signatures of signed URLs or signed cookies.
         */
        fun activeTrustedKeyGroups(activeTrustedKeyGroups: ActiveTrustedKeyGroups): FluentBuilder
        /**
         * We recommend using TrustedKeyGroups instead of
         * TrustedSigners.
         * CloudFront automatically adds this field to the response if you’ve configured a cache behavior in
         * this distribution to serve private content using trusted signers. This field contains a
         * list of account IDs and the active CloudFront key pairs in each account that CloudFront can use
         * to verify the signatures of signed URLs or signed cookies.
         */
        fun activeTrustedSigners(activeTrustedSigners: ActiveTrustedSigners): FluentBuilder
        /**
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
         * publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
         * recordal status for CNAMEs associated with distributions.
         * For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
         * Signup, Accounts, and Credentials in Getting Started with Amazon Web Services services in China.
         */
        fun aliasIcpRecordals(aliasIcpRecordals: List<AliasIcpRecordal>): FluentBuilder
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
         * 123456789012 is your account ID.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The current configuration information for the distribution. Send a GET
         * request to the /CloudFront API version/distribution ID/config
         * resource.
         */
        fun distributionConfig(distributionConfig: DistributionConfig): FluentBuilder
        /**
         * The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The identifier for the distribution. For example: EDFDVBD632BHDS5.
         */
        fun id(id: String): FluentBuilder
        /**
         * The number of invalidation batches currently in progress.
         */
        fun inProgressInvalidationBatches(inProgressInvalidationBatches: Int): FluentBuilder
        /**
         * The date and time the distribution was last modified.
         */
        fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder
        /**
         * This response element indicates the current status of the distribution. When the status
         * is Deployed, the distribution's information is fully propagated to all CloudFront edge
         * locations.
         */
        fun status(status: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * CloudFront automatically adds this field to the response if you’ve configured a cache
         * behavior in this distribution to serve private content using key groups. This field
         * contains a list of key groups and the public keys in each key group that CloudFront can use to
         * verify the signatures of signed URLs or signed cookies.
         */
        var activeTrustedKeyGroups: ActiveTrustedKeyGroups?
        /**
         * We recommend using TrustedKeyGroups instead of
         * TrustedSigners.
         * CloudFront automatically adds this field to the response if you’ve configured a cache behavior in
         * this distribution to serve private content using trusted signers. This field contains a
         * list of account IDs and the active CloudFront key pairs in each account that CloudFront can use
         * to verify the signatures of signed URLs or signed cookies.
         */
        var activeTrustedSigners: ActiveTrustedSigners?
        /**
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
         * publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
         * recordal status for CNAMEs associated with distributions.
         * For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
         * Signup, Accounts, and Credentials in Getting Started with Amazon Web Services services in China.
         */
        var aliasIcpRecordals: List<AliasIcpRecordal>?
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5, where
         * 123456789012 is your account ID.
         */
        var arn: String?
        /**
         * The current configuration information for the distribution. Send a GET
         * request to the /CloudFront API version/distribution ID/config
         * resource.
         */
        var distributionConfig: DistributionConfig?
        /**
         * The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
         */
        var domainName: String?
        /**
         * The identifier for the distribution. For example: EDFDVBD632BHDS5.
         */
        var id: String?
        /**
         * The number of invalidation batches currently in progress.
         */
        var inProgressInvalidationBatches: Int?
        /**
         * The date and time the distribution was last modified.
         */
        var lastModifiedTime: Instant?
        /**
         * This response element indicates the current status of the distribution. When the status
         * is Deployed, the distribution's information is fully propagated to all CloudFront edge
         * locations.
         */
        var status: String?

        fun build(): Distribution
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups] inside the given [block]
         */
        fun activeTrustedKeyGroups(block: ActiveTrustedKeyGroups.DslBuilder.() -> kotlin.Unit) {
            this.activeTrustedKeyGroups = ActiveTrustedKeyGroups.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners] inside the given [block]
         */
        fun activeTrustedSigners(block: ActiveTrustedSigners.DslBuilder.() -> kotlin.Unit) {
            this.activeTrustedSigners = ActiveTrustedSigners.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.DistributionConfig] inside the given [block]
         */
        fun distributionConfig(block: DistributionConfig.DslBuilder.() -> kotlin.Unit) {
            this.distributionConfig = DistributionConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activeTrustedKeyGroups: ActiveTrustedKeyGroups? = null
        override var activeTrustedSigners: ActiveTrustedSigners? = null
        override var aliasIcpRecordals: List<AliasIcpRecordal>? = null
        override var arn: String? = null
        override var distributionConfig: DistributionConfig? = null
        override var domainName: String? = null
        override var id: String? = null
        override var inProgressInvalidationBatches: Int? = null
        override var lastModifiedTime: Instant? = null
        override var status: String? = null

        constructor(x: Distribution) : this() {
            this.activeTrustedKeyGroups = x.activeTrustedKeyGroups
            this.activeTrustedSigners = x.activeTrustedSigners
            this.aliasIcpRecordals = x.aliasIcpRecordals
            this.arn = x.arn
            this.distributionConfig = x.distributionConfig
            this.domainName = x.domainName
            this.id = x.id
            this.inProgressInvalidationBatches = x.inProgressInvalidationBatches
            this.lastModifiedTime = x.lastModifiedTime
            this.status = x.status
        }

        override fun build(): Distribution = Distribution(this)
        override fun activeTrustedKeyGroups(activeTrustedKeyGroups: ActiveTrustedKeyGroups): FluentBuilder = apply { this.activeTrustedKeyGroups = activeTrustedKeyGroups }
        override fun activeTrustedSigners(activeTrustedSigners: ActiveTrustedSigners): FluentBuilder = apply { this.activeTrustedSigners = activeTrustedSigners }
        override fun aliasIcpRecordals(aliasIcpRecordals: List<AliasIcpRecordal>): FluentBuilder = apply { this.aliasIcpRecordals = aliasIcpRecordals }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun distributionConfig(distributionConfig: DistributionConfig): FluentBuilder = apply { this.distributionConfig = distributionConfig }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun inProgressInvalidationBatches(inProgressInvalidationBatches: Int): FluentBuilder = apply { this.inProgressInvalidationBatches = inProgressInvalidationBatches }
        override fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder = apply { this.lastModifiedTime = lastModifiedTime }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
    }
}
