// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * This action deletes a web distribution. To delete a web distribution using the CloudFront
 * API, perform the following steps.
 * To delete a web distribution using the CloudFront API:
 * <ol>
 * Disable the web distribution
 * Submit a GET Distribution Config request to get the current
 * configuration and the Etag header for the distribution.
 * Update the XML document that was returned in the response to your GET
 * Distribution Config request to change the value of Enabled to
 * false.
 * Submit a PUT Distribution Config request to update the configuration
 * for your distribution. In the request body, include the XML document that you updated in
 * Step 3. Set the value of the HTTP If-Match header to the value of the
 * ETag header that CloudFront returned when you submitted the GET
 * Distribution Config request in Step 2.
 * Review the response to the PUT Distribution Config request to confirm
 * that the distribution was successfully disabled.
 * Submit a GET Distribution request to confirm that your changes have
 * propagated. When propagation is complete, the value of Status is
 * Deployed.
 * Submit a DELETE Distribution request. Set the value of the HTTP
 * If-Match header to the value of the ETag header that CloudFront
 * returned when you submitted the GET Distribution Config request in Step
 * 6.
 * Review the response to your DELETE Distribution request to confirm
 * that the distribution was successfully deleted.
 * </ol>
 * For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution in the
 * Amazon CloudFront Developer Guide.
 */
class DeleteDistributionRequest private constructor(builder: BuilderImpl) {
    /**
     * The distribution ID.
     */
    val id: String? = builder.id
    /**
     * The value of the ETag header that you received when you disabled the
     * distribution. For example: E2QWRUHAPOMQZL.
     */
    val ifMatch: String? = builder.ifMatch

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteDistributionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDistributionRequest(")
        append("id=$id,")
        append("ifMatch=$ifMatch)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteDistributionRequest

        if (id != other.id) return false
        if (ifMatch != other.ifMatch) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteDistributionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteDistributionRequest
        /**
         * The distribution ID.
         */
        fun id(id: String): FluentBuilder
        /**
         * The value of the ETag header that you received when you disabled the
         * distribution. For example: E2QWRUHAPOMQZL.
         */
        fun ifMatch(ifMatch: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The distribution ID.
         */
        var id: String?
        /**
         * The value of the ETag header that you received when you disabled the
         * distribution. For example: E2QWRUHAPOMQZL.
         */
        var ifMatch: String?

        fun build(): DeleteDistributionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var id: String? = null
        override var ifMatch: String? = null

        constructor(x: DeleteDistributionRequest) : this() {
            this.id = x.id
            this.ifMatch = x.ifMatch
        }

        override fun build(): DeleteDistributionRequest = DeleteDistributionRequest(this)
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun ifMatch(ifMatch: String): FluentBuilder = apply { this.ifMatch = ifMatch }
    }
}
