// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that describes the default cache behavior if you don’t specify a
 * CacheBehavior element or if request URLs don’t match any of the values of
 * PathPattern in CacheBehavior elements. You must create exactly
 * one default cache behavior.
 */
class DefaultCacheBehavior private constructor(builder: BuilderImpl) {
    /**
     * A complex type that controls which HTTP methods CloudFront processes and forwards to your
     * Amazon S3 bucket or your custom origin. There are three choices:
     * CloudFront forwards only GET and HEAD requests.
     * CloudFront forwards only GET, HEAD, and OPTIONS
     * requests.
     * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and
     * DELETE requests.
     * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
     * to your custom origin so users can't perform operations that you don't want them to. For
     * example, you might not want users to have permissions to delete objects from your
     * origin.
     */
    val allowedMethods: AllowedMethods? = builder.allowedMethods
    /**
     * The unique identifier of the cache policy that is attached to the default cache behavior.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
     * Amazon CloudFront Developer Guide.
     * A DefaultCacheBehavior must include either a
     * CachePolicyId or ForwardedValues. We recommend that you
     * use a CachePolicyId.
     */
    val cachePolicyId: String? = builder.cachePolicyId
    /**
     * Whether you want CloudFront to automatically compress certain files for this cache behavior.
     * If so, specify true; if not, specify false. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files in
     * the Amazon CloudFront Developer Guide.
     */
    val compress: Boolean? = builder.compress
    /**
     * This field is deprecated. We recommend that you use the DefaultTTL field in a
     * cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
     * Amazon CloudFront Developer Guide.
     * The default amount of time that you want objects to stay in CloudFront caches before CloudFront
     * forwards another request to your origin to determine whether the object has been updated. The
     * value that you specify applies only when your origin does not add HTTP headers such as
     * Cache-Control max-age, Cache-Control s-maxage, and
     * Expires to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
     * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val defaultTtl: Long? = builder.defaultTtl
    /**
     * The value of ID for the field-level encryption configuration that you want CloudFront
     * to use for encrypting specific fields of data for the default cache behavior.
     */
    val fieldLevelEncryptionId: String? = builder.fieldLevelEncryptionId
    /**
     * This field is deprecated. We recommend that you use a cache policy or an origin request
     * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies in the
     * Amazon CloudFront Developer Guide.
     * If you want to include values in the cache key, use a cache policy. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
     * Amazon CloudFront Developer Guide.
     * If you want to send values to the origin but not include them in the cache key, use an
     * origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies in the
     * Amazon CloudFront Developer Guide.
     * A DefaultCacheBehavior must include either a
     * CachePolicyId or ForwardedValues. We recommend that you
     * use a CachePolicyId.
     * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val forwardedValues: ForwardedValues? = builder.forwardedValues
    /**
     * A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
     * be published to the LIVE stage to associate them with a cache
     * behavior.
     */
    val functionAssociations: FunctionAssociations? = builder.functionAssociations
    /**
     * A complex type that contains zero or more Lambda@Edge function associations for a cache
     * behavior.
     */
    val lambdaFunctionAssociations: LambdaFunctionAssociations? = builder.lambdaFunctionAssociations
    /**
     * This field is deprecated. We recommend that you use the MaxTTL field in a cache
     * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
     * Amazon CloudFront Developer Guide.
     * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
     * forwards another request to your origin to determine whether the object has been updated. The
     * value that you specify applies only when your origin adds HTTP headers such as
     * Cache-Control max-age, Cache-Control s-maxage, and
     * Expires to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
     * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val maxTtl: Long? = builder.maxTtl
    /**
     * This field is deprecated. We recommend that you use the MinTTL field in a cache
     * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
     * Amazon CloudFront Developer Guide.
     * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
     * forwards another request to your origin to determine whether the object has been updated. For
     * more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
     * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
     * You must specify 0 for MinTTL if you configure CloudFront to
     * forward all headers to your origin (under Headers, if you specify 1
     * for Quantity and * for Name).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val minTtl: Long? = builder.minTtl
    /**
     * The unique identifier of the origin request policy that is attached to the default cache
     * behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies in the
     * Amazon CloudFront Developer Guide.
     */
    val originRequestPolicyId: String? = builder.originRequestPolicyId
    /**
     * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
     * cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs in the Amazon CloudFront Developer Guide.
     */
    val realtimeLogConfigArn: String? = builder.realtimeLogConfigArn
    /**
     * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
     * format using the origin that is associated with this cache behavior. If so, specify
     * true; if not, specify false. If you specify true for
     * SmoothStreaming, you can still distribute other content using this cache
     * behavior if the content matches the value of PathPattern.
     */
    val smoothStreaming: Boolean? = builder.smoothStreaming
    /**
     * The value of ID for the origin that you want CloudFront to route requests to when
     * they use the default cache behavior.
     */
    val targetOriginId: String? = builder.targetOriginId
    /**
     * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
     * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
     * cookies for all requests that match the cache behavior. The URLs or cookies must be
     * signed with a private key whose corresponding public key is in the key group. The signed
     * URL or cookie contains information about which public key CloudFront should use to verify the
     * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
     */
    val trustedKeyGroups: TrustedKeyGroups? = builder.trustedKeyGroups
    /**
     * We recommend using TrustedKeyGroups instead of
     * TrustedSigners.
     * A list of account IDs whose public keys CloudFront can use to validate signed URLs or signed
     * cookies.
     * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
     * for all requests that match the cache behavior. The URLs or cookies must be signed with
     * the private key of a CloudFront key pair in a trusted signer’s account. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the
     * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
     */
    val trustedSigners: TrustedSigners? = builder.trustedSigners
    /**
     * The protocol that viewers can use to access the files in the origin specified by
     * TargetOriginId when a request matches the path pattern in
     * PathPattern. You can specify the following options:
     * allow-all: Viewers can use HTTP or HTTPS.
     * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
     * an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
     * viewer then resubmits the request using the new URL.
     * https-only: If a viewer sends an HTTP request, CloudFront returns an HTTP
     * status code of 403 (Forbidden).
     * For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront in the Amazon CloudFront Developer Guide.
     * The only way to guarantee that viewers retrieve an object that was fetched from
     * the origin using HTTPS is never to use any other protocol to fetch the object. If
     * you have recently changed from HTTP to HTTPS, we recommend that you clear your
     * objects’ cache because cached objects are protocol agnostic. That means that an edge
     * location will return an object from the cache regardless of whether the current
     * request protocol matches the protocol used previously. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
     * Expiration in the
     * Amazon CloudFront Developer Guide.
     */
    val viewerProtocolPolicy: ViewerProtocolPolicy? = builder.viewerProtocolPolicy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DefaultCacheBehavior = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultCacheBehavior(")
        append("allowedMethods=$allowedMethods,")
        append("cachePolicyId=$cachePolicyId,")
        append("compress=$compress,")
        append("defaultTtl=$defaultTtl,")
        append("fieldLevelEncryptionId=$fieldLevelEncryptionId,")
        append("forwardedValues=$forwardedValues,")
        append("functionAssociations=$functionAssociations,")
        append("lambdaFunctionAssociations=$lambdaFunctionAssociations,")
        append("maxTtl=$maxTtl,")
        append("minTtl=$minTtl,")
        append("originRequestPolicyId=$originRequestPolicyId,")
        append("realtimeLogConfigArn=$realtimeLogConfigArn,")
        append("smoothStreaming=$smoothStreaming,")
        append("targetOriginId=$targetOriginId,")
        append("trustedKeyGroups=$trustedKeyGroups,")
        append("trustedSigners=$trustedSigners,")
        append("viewerProtocolPolicy=$viewerProtocolPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedMethods?.hashCode() ?: 0
        result = 31 * result + (cachePolicyId?.hashCode() ?: 0)
        result = 31 * result + (compress?.hashCode() ?: 0)
        result = 31 * result + (defaultTtl?.hashCode() ?: 0)
        result = 31 * result + (fieldLevelEncryptionId?.hashCode() ?: 0)
        result = 31 * result + (forwardedValues?.hashCode() ?: 0)
        result = 31 * result + (functionAssociations?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionAssociations?.hashCode() ?: 0)
        result = 31 * result + (maxTtl?.hashCode() ?: 0)
        result = 31 * result + (minTtl?.hashCode() ?: 0)
        result = 31 * result + (originRequestPolicyId?.hashCode() ?: 0)
        result = 31 * result + (realtimeLogConfigArn?.hashCode() ?: 0)
        result = 31 * result + (smoothStreaming?.hashCode() ?: 0)
        result = 31 * result + (targetOriginId?.hashCode() ?: 0)
        result = 31 * result + (trustedKeyGroups?.hashCode() ?: 0)
        result = 31 * result + (trustedSigners?.hashCode() ?: 0)
        result = 31 * result + (viewerProtocolPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DefaultCacheBehavior

        if (allowedMethods != other.allowedMethods) return false
        if (cachePolicyId != other.cachePolicyId) return false
        if (compress != other.compress) return false
        if (defaultTtl != other.defaultTtl) return false
        if (fieldLevelEncryptionId != other.fieldLevelEncryptionId) return false
        if (forwardedValues != other.forwardedValues) return false
        if (functionAssociations != other.functionAssociations) return false
        if (lambdaFunctionAssociations != other.lambdaFunctionAssociations) return false
        if (maxTtl != other.maxTtl) return false
        if (minTtl != other.minTtl) return false
        if (originRequestPolicyId != other.originRequestPolicyId) return false
        if (realtimeLogConfigArn != other.realtimeLogConfigArn) return false
        if (smoothStreaming != other.smoothStreaming) return false
        if (targetOriginId != other.targetOriginId) return false
        if (trustedKeyGroups != other.trustedKeyGroups) return false
        if (trustedSigners != other.trustedSigners) return false
        if (viewerProtocolPolicy != other.viewerProtocolPolicy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DefaultCacheBehavior = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DefaultCacheBehavior
        /**
         * A complex type that controls which HTTP methods CloudFront processes and forwards to your
         * Amazon S3 bucket or your custom origin. There are three choices:
         * CloudFront forwards only GET and HEAD requests.
         * CloudFront forwards only GET, HEAD, and OPTIONS
         * requests.
         * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and
         * DELETE requests.
         * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
         * to your custom origin so users can't perform operations that you don't want them to. For
         * example, you might not want users to have permissions to delete objects from your
         * origin.
         */
        fun allowedMethods(allowedMethods: AllowedMethods): FluentBuilder
        /**
         * The unique identifier of the cache policy that is attached to the default cache behavior.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * A DefaultCacheBehavior must include either a
         * CachePolicyId or ForwardedValues. We recommend that you
         * use a CachePolicyId.
         */
        fun cachePolicyId(cachePolicyId: String): FluentBuilder
        /**
         * Whether you want CloudFront to automatically compress certain files for this cache behavior.
         * If so, specify true; if not, specify false. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files in
         * the Amazon CloudFront Developer Guide.
         */
        fun compress(compress: Boolean): FluentBuilder
        /**
         * This field is deprecated. We recommend that you use the DefaultTTL field in a
         * cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * The default amount of time that you want objects to stay in CloudFront caches before CloudFront
         * forwards another request to your origin to determine whether the object has been updated. The
         * value that you specify applies only when your origin does not add HTTP headers such as
         * Cache-Control max-age, Cache-Control s-maxage, and
         * Expires to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
         * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun defaultTtl(defaultTtl: Long): FluentBuilder
        /**
         * The value of ID for the field-level encryption configuration that you want CloudFront
         * to use for encrypting specific fields of data for the default cache behavior.
         */
        fun fieldLevelEncryptionId(fieldLevelEncryptionId: String): FluentBuilder
        /**
         * This field is deprecated. We recommend that you use a cache policy or an origin request
         * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies in the
         * Amazon CloudFront Developer Guide.
         * If you want to include values in the cache key, use a cache policy. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * If you want to send values to the origin but not include them in the cache key, use an
         * origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies in the
         * Amazon CloudFront Developer Guide.
         * A DefaultCacheBehavior must include either a
         * CachePolicyId or ForwardedValues. We recommend that you
         * use a CachePolicyId.
         * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun forwardedValues(forwardedValues: ForwardedValues): FluentBuilder
        /**
         * A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
         * be published to the LIVE stage to associate them with a cache
         * behavior.
         */
        fun functionAssociations(functionAssociations: FunctionAssociations): FluentBuilder
        /**
         * A complex type that contains zero or more Lambda@Edge function associations for a cache
         * behavior.
         */
        fun lambdaFunctionAssociations(lambdaFunctionAssociations: LambdaFunctionAssociations): FluentBuilder
        /**
         * This field is deprecated. We recommend that you use the MaxTTL field in a cache
         * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
         * forwards another request to your origin to determine whether the object has been updated. The
         * value that you specify applies only when your origin adds HTTP headers such as
         * Cache-Control max-age, Cache-Control s-maxage, and
         * Expires to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
         * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun maxTtl(maxTtl: Long): FluentBuilder
        /**
         * This field is deprecated. We recommend that you use the MinTTL field in a cache
         * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
         * forwards another request to your origin to determine whether the object has been updated. For
         * more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
         * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
         * You must specify 0 for MinTTL if you configure CloudFront to
         * forward all headers to your origin (under Headers, if you specify 1
         * for Quantity and * for Name).
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun minTtl(minTtl: Long): FluentBuilder
        /**
         * The unique identifier of the origin request policy that is attached to the default cache
         * behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies in the
         * Amazon CloudFront Developer Guide.
         */
        fun originRequestPolicyId(originRequestPolicyId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
         * cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs in the Amazon CloudFront Developer Guide.
         */
        fun realtimeLogConfigArn(realtimeLogConfigArn: String): FluentBuilder
        /**
         * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
         * format using the origin that is associated with this cache behavior. If so, specify
         * true; if not, specify false. If you specify true for
         * SmoothStreaming, you can still distribute other content using this cache
         * behavior if the content matches the value of PathPattern.
         */
        fun smoothStreaming(smoothStreaming: Boolean): FluentBuilder
        /**
         * The value of ID for the origin that you want CloudFront to route requests to when
         * they use the default cache behavior.
         */
        fun targetOriginId(targetOriginId: String): FluentBuilder
        /**
         * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
         * cookies for all requests that match the cache behavior. The URLs or cookies must be
         * signed with a private key whose corresponding public key is in the key group. The signed
         * URL or cookie contains information about which public key CloudFront should use to verify the
         * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
         */
        fun trustedKeyGroups(trustedKeyGroups: TrustedKeyGroups): FluentBuilder
        /**
         * We recommend using TrustedKeyGroups instead of
         * TrustedSigners.
         * A list of account IDs whose public keys CloudFront can use to validate signed URLs or signed
         * cookies.
         * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
         * for all requests that match the cache behavior. The URLs or cookies must be signed with
         * the private key of a CloudFront key pair in a trusted signer’s account. The signed URL or
         * cookie contains information about which public key CloudFront should use to verify the
         * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
         */
        fun trustedSigners(trustedSigners: TrustedSigners): FluentBuilder
        /**
         * The protocol that viewers can use to access the files in the origin specified by
         * TargetOriginId when a request matches the path pattern in
         * PathPattern. You can specify the following options:
         * allow-all: Viewers can use HTTP or HTTPS.
         * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
         * an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
         * viewer then resubmits the request using the new URL.
         * https-only: If a viewer sends an HTTP request, CloudFront returns an HTTP
         * status code of 403 (Forbidden).
         * For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront in the Amazon CloudFront Developer Guide.
         * The only way to guarantee that viewers retrieve an object that was fetched from
         * the origin using HTTPS is never to use any other protocol to fetch the object. If
         * you have recently changed from HTTP to HTTPS, we recommend that you clear your
         * objects’ cache because cached objects are protocol agnostic. That means that an edge
         * location will return an object from the cache regardless of whether the current
         * request protocol matches the protocol used previously. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
         * Expiration in the
         * Amazon CloudFront Developer Guide.
         */
        fun viewerProtocolPolicy(viewerProtocolPolicy: ViewerProtocolPolicy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that controls which HTTP methods CloudFront processes and forwards to your
         * Amazon S3 bucket or your custom origin. There are three choices:
         * CloudFront forwards only GET and HEAD requests.
         * CloudFront forwards only GET, HEAD, and OPTIONS
         * requests.
         * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and
         * DELETE requests.
         * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
         * to your custom origin so users can't perform operations that you don't want them to. For
         * example, you might not want users to have permissions to delete objects from your
         * origin.
         */
        var allowedMethods: AllowedMethods?
        /**
         * The unique identifier of the cache policy that is attached to the default cache behavior.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * A DefaultCacheBehavior must include either a
         * CachePolicyId or ForwardedValues. We recommend that you
         * use a CachePolicyId.
         */
        var cachePolicyId: String?
        /**
         * Whether you want CloudFront to automatically compress certain files for this cache behavior.
         * If so, specify true; if not, specify false. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files in
         * the Amazon CloudFront Developer Guide.
         */
        var compress: Boolean?
        /**
         * This field is deprecated. We recommend that you use the DefaultTTL field in a
         * cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * The default amount of time that you want objects to stay in CloudFront caches before CloudFront
         * forwards another request to your origin to determine whether the object has been updated. The
         * value that you specify applies only when your origin does not add HTTP headers such as
         * Cache-Control max-age, Cache-Control s-maxage, and
         * Expires to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
         * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var defaultTtl: Long?
        /**
         * The value of ID for the field-level encryption configuration that you want CloudFront
         * to use for encrypting specific fields of data for the default cache behavior.
         */
        var fieldLevelEncryptionId: String?
        /**
         * This field is deprecated. We recommend that you use a cache policy or an origin request
         * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies in the
         * Amazon CloudFront Developer Guide.
         * If you want to include values in the cache key, use a cache policy. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * If you want to send values to the origin but not include them in the cache key, use an
         * origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies in the
         * Amazon CloudFront Developer Guide.
         * A DefaultCacheBehavior must include either a
         * CachePolicyId or ForwardedValues. We recommend that you
         * use a CachePolicyId.
         * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var forwardedValues: ForwardedValues?
        /**
         * A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
         * be published to the LIVE stage to associate them with a cache
         * behavior.
         */
        var functionAssociations: FunctionAssociations?
        /**
         * A complex type that contains zero or more Lambda@Edge function associations for a cache
         * behavior.
         */
        var lambdaFunctionAssociations: LambdaFunctionAssociations?
        /**
         * This field is deprecated. We recommend that you use the MaxTTL field in a cache
         * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
         * forwards another request to your origin to determine whether the object has been updated. The
         * value that you specify applies only when your origin adds HTTP headers such as
         * Cache-Control max-age, Cache-Control s-maxage, and
         * Expires to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
         * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var maxTtl: Long?
        /**
         * This field is deprecated. We recommend that you use the MinTTL field in a cache
         * policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies in the
         * Amazon CloudFront Developer Guide.
         * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
         * forwards another request to your origin to determine whether the object has been updated. For
         * more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
         * in an Edge Cache (Expiration) in the Amazon CloudFront Developer Guide.
         * You must specify 0 for MinTTL if you configure CloudFront to
         * forward all headers to your origin (under Headers, if you specify 1
         * for Quantity and * for Name).
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var minTtl: Long?
        /**
         * The unique identifier of the origin request policy that is attached to the default cache
         * behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies in the
         * Amazon CloudFront Developer Guide.
         */
        var originRequestPolicyId: String?
        /**
         * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
         * cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs in the Amazon CloudFront Developer Guide.
         */
        var realtimeLogConfigArn: String?
        /**
         * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
         * format using the origin that is associated with this cache behavior. If so, specify
         * true; if not, specify false. If you specify true for
         * SmoothStreaming, you can still distribute other content using this cache
         * behavior if the content matches the value of PathPattern.
         */
        var smoothStreaming: Boolean?
        /**
         * The value of ID for the origin that you want CloudFront to route requests to when
         * they use the default cache behavior.
         */
        var targetOriginId: String?
        /**
         * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
         * cookies for all requests that match the cache behavior. The URLs or cookies must be
         * signed with a private key whose corresponding public key is in the key group. The signed
         * URL or cookie contains information about which public key CloudFront should use to verify the
         * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
         */
        var trustedKeyGroups: TrustedKeyGroups?
        /**
         * We recommend using TrustedKeyGroups instead of
         * TrustedSigners.
         * A list of account IDs whose public keys CloudFront can use to validate signed URLs or signed
         * cookies.
         * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
         * for all requests that match the cache behavior. The URLs or cookies must be signed with
         * the private key of a CloudFront key pair in a trusted signer’s account. The signed URL or
         * cookie contains information about which public key CloudFront should use to verify the
         * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
         */
        var trustedSigners: TrustedSigners?
        /**
         * The protocol that viewers can use to access the files in the origin specified by
         * TargetOriginId when a request matches the path pattern in
         * PathPattern. You can specify the following options:
         * allow-all: Viewers can use HTTP or HTTPS.
         * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
         * an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
         * viewer then resubmits the request using the new URL.
         * https-only: If a viewer sends an HTTP request, CloudFront returns an HTTP
         * status code of 403 (Forbidden).
         * For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront in the Amazon CloudFront Developer Guide.
         * The only way to guarantee that viewers retrieve an object that was fetched from
         * the origin using HTTPS is never to use any other protocol to fetch the object. If
         * you have recently changed from HTTP to HTTPS, we recommend that you clear your
         * objects’ cache because cached objects are protocol agnostic. That means that an edge
         * location will return an object from the cache regardless of whether the current
         * request protocol matches the protocol used previously. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
         * Expiration in the
         * Amazon CloudFront Developer Guide.
         */
        var viewerProtocolPolicy: ViewerProtocolPolicy?

        fun build(): DefaultCacheBehavior
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.AllowedMethods] inside the given [block]
         */
        fun allowedMethods(block: AllowedMethods.DslBuilder.() -> kotlin.Unit) {
            this.allowedMethods = AllowedMethods.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ForwardedValues] inside the given [block]
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun forwardedValues(block: ForwardedValues.DslBuilder.() -> kotlin.Unit) {
            this.forwardedValues = ForwardedValues.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionAssociations] inside the given [block]
         */
        fun functionAssociations(block: FunctionAssociations.DslBuilder.() -> kotlin.Unit) {
            this.functionAssociations = FunctionAssociations.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations] inside the given [block]
         */
        fun lambdaFunctionAssociations(block: LambdaFunctionAssociations.DslBuilder.() -> kotlin.Unit) {
            this.lambdaFunctionAssociations = LambdaFunctionAssociations.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrustedKeyGroups] inside the given [block]
         */
        fun trustedKeyGroups(block: TrustedKeyGroups.DslBuilder.() -> kotlin.Unit) {
            this.trustedKeyGroups = TrustedKeyGroups.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrustedSigners] inside the given [block]
         */
        fun trustedSigners(block: TrustedSigners.DslBuilder.() -> kotlin.Unit) {
            this.trustedSigners = TrustedSigners.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowedMethods: AllowedMethods? = null
        override var cachePolicyId: String? = null
        override var compress: Boolean? = null
        override var defaultTtl: Long? = null
        override var fieldLevelEncryptionId: String? = null
        override var forwardedValues: ForwardedValues? = null
        override var functionAssociations: FunctionAssociations? = null
        override var lambdaFunctionAssociations: LambdaFunctionAssociations? = null
        override var maxTtl: Long? = null
        override var minTtl: Long? = null
        override var originRequestPolicyId: String? = null
        override var realtimeLogConfigArn: String? = null
        override var smoothStreaming: Boolean? = null
        override var targetOriginId: String? = null
        override var trustedKeyGroups: TrustedKeyGroups? = null
        override var trustedSigners: TrustedSigners? = null
        override var viewerProtocolPolicy: ViewerProtocolPolicy? = null

        constructor(x: DefaultCacheBehavior) : this() {
            this.allowedMethods = x.allowedMethods
            this.cachePolicyId = x.cachePolicyId
            this.compress = x.compress
            this.defaultTtl = x.defaultTtl
            this.fieldLevelEncryptionId = x.fieldLevelEncryptionId
            this.forwardedValues = x.forwardedValues
            this.functionAssociations = x.functionAssociations
            this.lambdaFunctionAssociations = x.lambdaFunctionAssociations
            this.maxTtl = x.maxTtl
            this.minTtl = x.minTtl
            this.originRequestPolicyId = x.originRequestPolicyId
            this.realtimeLogConfigArn = x.realtimeLogConfigArn
            this.smoothStreaming = x.smoothStreaming
            this.targetOriginId = x.targetOriginId
            this.trustedKeyGroups = x.trustedKeyGroups
            this.trustedSigners = x.trustedSigners
            this.viewerProtocolPolicy = x.viewerProtocolPolicy
        }

        override fun build(): DefaultCacheBehavior = DefaultCacheBehavior(this)
        override fun allowedMethods(allowedMethods: AllowedMethods): FluentBuilder = apply { this.allowedMethods = allowedMethods }
        override fun cachePolicyId(cachePolicyId: String): FluentBuilder = apply { this.cachePolicyId = cachePolicyId }
        override fun compress(compress: Boolean): FluentBuilder = apply { this.compress = compress }
        override fun defaultTtl(defaultTtl: Long): FluentBuilder = apply { this.defaultTtl = defaultTtl }
        override fun fieldLevelEncryptionId(fieldLevelEncryptionId: String): FluentBuilder = apply { this.fieldLevelEncryptionId = fieldLevelEncryptionId }
        override fun forwardedValues(forwardedValues: ForwardedValues): FluentBuilder = apply { this.forwardedValues = forwardedValues }
        override fun functionAssociations(functionAssociations: FunctionAssociations): FluentBuilder = apply { this.functionAssociations = functionAssociations }
        override fun lambdaFunctionAssociations(lambdaFunctionAssociations: LambdaFunctionAssociations): FluentBuilder = apply { this.lambdaFunctionAssociations = lambdaFunctionAssociations }
        override fun maxTtl(maxTtl: Long): FluentBuilder = apply { this.maxTtl = maxTtl }
        override fun minTtl(minTtl: Long): FluentBuilder = apply { this.minTtl = minTtl }
        override fun originRequestPolicyId(originRequestPolicyId: String): FluentBuilder = apply { this.originRequestPolicyId = originRequestPolicyId }
        override fun realtimeLogConfigArn(realtimeLogConfigArn: String): FluentBuilder = apply { this.realtimeLogConfigArn = realtimeLogConfigArn }
        override fun smoothStreaming(smoothStreaming: Boolean): FluentBuilder = apply { this.smoothStreaming = smoothStreaming }
        override fun targetOriginId(targetOriginId: String): FluentBuilder = apply { this.targetOriginId = targetOriginId }
        override fun trustedKeyGroups(trustedKeyGroups: TrustedKeyGroups): FluentBuilder = apply { this.trustedKeyGroups = trustedKeyGroups }
        override fun trustedSigners(trustedSigners: TrustedSigners): FluentBuilder = apply { this.trustedSigners = trustedSigners }
        override fun viewerProtocolPolicy(viewerProtocolPolicy: ViewerProtocolPolicy): FluentBuilder = apply { this.viewerProtocolPolicy = viewerProtocolPolicy }
    }
}
