// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A custom origin. A custom origin is any origin that is not an Amazon S3
 * bucket, with one exception. An Amazon S3 bucket that is <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">configured with
 * static website hosting
 * is a custom origin.
 */
class CustomOriginConfig private constructor(builder: BuilderImpl) {
    /**
     * The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin
     * listens on.
     */
    val httpPort: Int? = builder.httpPort
    /**
     * The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the
     * origin listens on.
     */
    val httpsPort: Int? = builder.httpsPort
    /**
     * Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum
     * timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
     * otherwise) is 5 seconds.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout in the
     * Amazon CloudFront Developer Guide.
     */
    val originKeepaliveTimeout: Int? = builder.originKeepaliveTimeout
    /**
     * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values
     * are:
     * http-only – CloudFront always uses HTTP to connect to the
     * origin.
     * match-viewer – CloudFront connects to the origin using the same
     * protocol that the viewer used to connect to CloudFront.
     * https-only – CloudFront always uses HTTPS to connect to the
     * origin.
     */
    val originProtocolPolicy: OriginProtocolPolicy? = builder.originProtocolPolicy
    /**
     * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also
     * known as the origin response timeout. The minimum timeout is 1
     * second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is
     * 30 seconds.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout in the
     * Amazon CloudFront Developer Guide.
     */
    val originReadTimeout: Int? = builder.originReadTimeout
    /**
     * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over
     * HTTPS. Valid values include SSLv3, TLSv1,
     * TLSv1.1, and TLSv1.2.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol in the
     * Amazon CloudFront Developer Guide.
     */
    val originSslProtocols: OriginSslProtocols? = builder.originSslProtocols

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomOriginConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomOriginConfig(")
        append("httpPort=$httpPort,")
        append("httpsPort=$httpsPort,")
        append("originKeepaliveTimeout=$originKeepaliveTimeout,")
        append("originProtocolPolicy=$originProtocolPolicy,")
        append("originReadTimeout=$originReadTimeout,")
        append("originSslProtocols=$originSslProtocols)")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpPort ?: 0
        result = 31 * result + (httpsPort ?: 0)
        result = 31 * result + (originKeepaliveTimeout ?: 0)
        result = 31 * result + (originProtocolPolicy?.hashCode() ?: 0)
        result = 31 * result + (originReadTimeout ?: 0)
        result = 31 * result + (originSslProtocols?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomOriginConfig

        if (httpPort != other.httpPort) return false
        if (httpsPort != other.httpsPort) return false
        if (originKeepaliveTimeout != other.originKeepaliveTimeout) return false
        if (originProtocolPolicy != other.originProtocolPolicy) return false
        if (originReadTimeout != other.originReadTimeout) return false
        if (originSslProtocols != other.originSslProtocols) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomOriginConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomOriginConfig
        /**
         * The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin
         * listens on.
         */
        fun httpPort(httpPort: Int): FluentBuilder
        /**
         * The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the
         * origin listens on.
         */
        fun httpsPort(httpsPort: Int): FluentBuilder
        /**
         * Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum
         * timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
         * otherwise) is 5 seconds.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout in the
         * Amazon CloudFront Developer Guide.
         */
        fun originKeepaliveTimeout(originKeepaliveTimeout: Int): FluentBuilder
        /**
         * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values
         * are:
         * http-only – CloudFront always uses HTTP to connect to the
         * origin.
         * match-viewer – CloudFront connects to the origin using the same
         * protocol that the viewer used to connect to CloudFront.
         * https-only – CloudFront always uses HTTPS to connect to the
         * origin.
         */
        fun originProtocolPolicy(originProtocolPolicy: OriginProtocolPolicy): FluentBuilder
        /**
         * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also
         * known as the origin response timeout. The minimum timeout is 1
         * second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is
         * 30 seconds.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout in the
         * Amazon CloudFront Developer Guide.
         */
        fun originReadTimeout(originReadTimeout: Int): FluentBuilder
        /**
         * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over
         * HTTPS. Valid values include SSLv3, TLSv1,
         * TLSv1.1, and TLSv1.2.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol in the
         * Amazon CloudFront Developer Guide.
         */
        fun originSslProtocols(originSslProtocols: OriginSslProtocols): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin
         * listens on.
         */
        var httpPort: Int?
        /**
         * The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the
         * origin listens on.
         */
        var httpsPort: Int?
        /**
         * Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum
         * timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
         * otherwise) is 5 seconds.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout in the
         * Amazon CloudFront Developer Guide.
         */
        var originKeepaliveTimeout: Int?
        /**
         * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values
         * are:
         * http-only – CloudFront always uses HTTP to connect to the
         * origin.
         * match-viewer – CloudFront connects to the origin using the same
         * protocol that the viewer used to connect to CloudFront.
         * https-only – CloudFront always uses HTTPS to connect to the
         * origin.
         */
        var originProtocolPolicy: OriginProtocolPolicy?
        /**
         * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also
         * known as the origin response timeout. The minimum timeout is 1
         * second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is
         * 30 seconds.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout in the
         * Amazon CloudFront Developer Guide.
         */
        var originReadTimeout: Int?
        /**
         * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over
         * HTTPS. Valid values include SSLv3, TLSv1,
         * TLSv1.1, and TLSv1.2.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol in the
         * Amazon CloudFront Developer Guide.
         */
        var originSslProtocols: OriginSslProtocols?

        fun build(): CustomOriginConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginSslProtocols] inside the given [block]
         */
        fun originSslProtocols(block: OriginSslProtocols.DslBuilder.() -> kotlin.Unit) {
            this.originSslProtocols = OriginSslProtocols.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var httpPort: Int? = null
        override var httpsPort: Int? = null
        override var originKeepaliveTimeout: Int? = null
        override var originProtocolPolicy: OriginProtocolPolicy? = null
        override var originReadTimeout: Int? = null
        override var originSslProtocols: OriginSslProtocols? = null

        constructor(x: CustomOriginConfig) : this() {
            this.httpPort = x.httpPort
            this.httpsPort = x.httpsPort
            this.originKeepaliveTimeout = x.originKeepaliveTimeout
            this.originProtocolPolicy = x.originProtocolPolicy
            this.originReadTimeout = x.originReadTimeout
            this.originSslProtocols = x.originSslProtocols
        }

        override fun build(): CustomOriginConfig = CustomOriginConfig(this)
        override fun httpPort(httpPort: Int): FluentBuilder = apply { this.httpPort = httpPort }
        override fun httpsPort(httpsPort: Int): FluentBuilder = apply { this.httpsPort = httpsPort }
        override fun originKeepaliveTimeout(originKeepaliveTimeout: Int): FluentBuilder = apply { this.originKeepaliveTimeout = originKeepaliveTimeout }
        override fun originProtocolPolicy(originProtocolPolicy: OriginProtocolPolicy): FluentBuilder = apply { this.originProtocolPolicy = originProtocolPolicy }
        override fun originReadTimeout(originReadTimeout: Int): FluentBuilder = apply { this.originReadTimeout = originReadTimeout }
        override fun originSslProtocols(originSslProtocols: OriginSslProtocols): FluentBuilder = apply { this.originSslProtocols = originSslProtocols }
    }
}
