// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls:
 * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
 * messages before returning the response to the viewer.
 * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
 * For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses in the
 * Amazon CloudFront Developer Guide.
 */
class CustomErrorResponses private constructor(builder: BuilderImpl) {
    /**
     * A complex type that contains a CustomErrorResponse element for each HTTP
     * status code for which you want to specify a custom error page and/or a caching duration.
     */
    val items: List<CustomErrorResponse>? = builder.items
    /**
     * The number of HTTP status codes for which you want to specify a custom error page
     * and/or a caching duration. If Quantity is 0, you can omit
     * Items.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomErrorResponses = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomErrorResponses(")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomErrorResponses

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomErrorResponses = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomErrorResponses
        /**
         * A complex type that contains a CustomErrorResponse element for each HTTP
         * status code for which you want to specify a custom error page and/or a caching duration.
         */
        fun items(items: List<CustomErrorResponse>): FluentBuilder
        /**
         * The number of HTTP status codes for which you want to specify a custom error page
         * and/or a caching duration. If Quantity is 0, you can omit
         * Items.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that contains a CustomErrorResponse element for each HTTP
         * status code for which you want to specify a custom error page and/or a caching duration.
         */
        var items: List<CustomErrorResponse>?
        /**
         * The number of HTTP status codes for which you want to specify a custom error page
         * and/or a caching duration. If Quantity is 0, you can omit
         * Items.
         */
        var quantity: Int?

        fun build(): CustomErrorResponses
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<CustomErrorResponse>? = null
        override var quantity: Int? = null

        constructor(x: CustomErrorResponses) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        override fun build(): CustomErrorResponses = CustomErrorResponses(this)
        override fun items(items: List<CustomErrorResponse>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
