// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



class CreateFunctionRequest private constructor(builder: BuilderImpl) {
    /**
     * The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
     * code for CloudFront Functions in the Amazon CloudFront Developer Guide.
     */
    val functionCode: ByteArray? = builder.functionCode
    /**
     * Configuration information about the function, including an optional comment and the
     * function’s runtime.
     */
    val functionConfig: FunctionConfig? = builder.functionConfig
    /**
     * A name to identify the function.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateFunctionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFunctionRequest(")
        append("functionCode=*** Sensitive Data Redacted ***,")
        append("functionConfig=$functionConfig,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionCode?.contentHashCode() ?: 0
        result = 31 * result + (functionConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateFunctionRequest

        if (functionCode != null) {
            if (other.functionCode == null) return false
            if (!functionCode.contentEquals(other.functionCode)) return false
        } else if (other.functionCode != null) return false
        if (functionConfig != other.functionConfig) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateFunctionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateFunctionRequest
        /**
         * The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
         * code for CloudFront Functions in the Amazon CloudFront Developer Guide.
         */
        fun functionCode(functionCode: ByteArray): FluentBuilder
        /**
         * Configuration information about the function, including an optional comment and the
         * function’s runtime.
         */
        fun functionConfig(functionConfig: FunctionConfig): FluentBuilder
        /**
         * A name to identify the function.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
         * code for CloudFront Functions in the Amazon CloudFront Developer Guide.
         */
        var functionCode: ByteArray?
        /**
         * Configuration information about the function, including an optional comment and the
         * function’s runtime.
         */
        var functionConfig: FunctionConfig?
        /**
         * A name to identify the function.
         */
        var name: String?

        fun build(): CreateFunctionRequest
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionConfig] inside the given [block]
         */
        fun functionConfig(block: FunctionConfig.DslBuilder.() -> kotlin.Unit) {
            this.functionConfig = FunctionConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var functionCode: ByteArray? = null
        override var functionConfig: FunctionConfig? = null
        override var name: String? = null

        constructor(x: CreateFunctionRequest) : this() {
            this.functionCode = x.functionCode
            this.functionConfig = x.functionConfig
            this.name = x.name
        }

        override fun build(): CreateFunctionRequest = CreateFunctionRequest(this)
        override fun functionCode(functionCode: ByteArray): FluentBuilder = apply { this.functionCode = functionCode }
        override fun functionConfig(functionConfig: FunctionConfig): FluentBuilder = apply { this.functionConfig = functionConfig }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
