// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of aliases (also called CNAMEs) and the CloudFront distributions and Amazon Web Services accounts that
 * they are associated with. In the list, the distribution and account IDs are partially
 * hidden, which allows you to identify the distributions and accounts that you own, but
 * helps to protect the information of ones that you don’t own.
 */
class ConflictingAliasesList private constructor(builder: BuilderImpl) {
    /**
     * Contains the conflicting aliases in the list.
     */
    val items: List<ConflictingAlias>? = builder.items
    /**
     * The maximum number of conflicting aliases requested.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * If there are more items in the list than are in this response, this element is present. It
     * contains the value that you should use in the Marker field of a subsequent
     * request to continue listing conflicting aliases where you left off.
     */
    val nextMarker: String? = builder.nextMarker
    /**
     * The number of conflicting aliases returned in the response.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ConflictingAliasesList = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ConflictingAliasesList(")
        append("items=$items,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ConflictingAliasesList

        if (items != other.items) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ConflictingAliasesList = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ConflictingAliasesList
        /**
         * Contains the conflicting aliases in the list.
         */
        fun items(items: List<ConflictingAlias>): FluentBuilder
        /**
         * The maximum number of conflicting aliases requested.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * If there are more items in the list than are in this response, this element is present. It
         * contains the value that you should use in the Marker field of a subsequent
         * request to continue listing conflicting aliases where you left off.
         */
        fun nextMarker(nextMarker: String): FluentBuilder
        /**
         * The number of conflicting aliases returned in the response.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains the conflicting aliases in the list.
         */
        var items: List<ConflictingAlias>?
        /**
         * The maximum number of conflicting aliases requested.
         */
        var maxItems: Int?
        /**
         * If there are more items in the list than are in this response, this element is present. It
         * contains the value that you should use in the Marker field of a subsequent
         * request to continue listing conflicting aliases where you left off.
         */
        var nextMarker: String?
        /**
         * The number of conflicting aliases returned in the response.
         */
        var quantity: Int?

        fun build(): ConflictingAliasesList
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<ConflictingAlias>? = null
        override var maxItems: Int? = null
        override var nextMarker: String? = null
        override var quantity: Int? = null

        constructor(x: ConflictingAliasesList) : this() {
            this.items = x.items
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        override fun build(): ConflictingAliasesList = ConflictingAliasesList(this)
        override fun items(items: List<ConflictingAlias>): FluentBuilder = apply { this.items = items }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun nextMarker(nextMarker: String): FluentBuilder = apply { this.nextMarker = nextMarker }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
