// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An alias (also called a CNAME) and the CloudFront distribution and Amazon Web Services account ID that it’s
 * associated with. The distribution and account IDs are partially hidden, which allows you
 * to identify the distributions and accounts that you own, but helps to protect the
 * information of ones that you don’t own.
 */
class ConflictingAlias private constructor(builder: BuilderImpl) {
    /**
     * The (partially hidden) ID of the Amazon Web Services account that owns the distribution that’s
     * associated with the alias.
     */
    val accountId: String? = builder.accountId
    /**
     * An alias (also called a CNAME).
     */
    val alias: String? = builder.alias
    /**
     * The (partially hidden) ID of the CloudFront distribution associated with the alias.
     */
    val distributionId: String? = builder.distributionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ConflictingAlias = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ConflictingAlias(")
        append("accountId=$accountId,")
        append("alias=$alias,")
        append("distributionId=$distributionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (alias?.hashCode() ?: 0)
        result = 31 * result + (distributionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ConflictingAlias

        if (accountId != other.accountId) return false
        if (alias != other.alias) return false
        if (distributionId != other.distributionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ConflictingAlias = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ConflictingAlias
        /**
         * The (partially hidden) ID of the Amazon Web Services account that owns the distribution that’s
         * associated with the alias.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * An alias (also called a CNAME).
         */
        fun alias(alias: String): FluentBuilder
        /**
         * The (partially hidden) ID of the CloudFront distribution associated with the alias.
         */
        fun distributionId(distributionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The (partially hidden) ID of the Amazon Web Services account that owns the distribution that’s
         * associated with the alias.
         */
        var accountId: String?
        /**
         * An alias (also called a CNAME).
         */
        var alias: String?
        /**
         * The (partially hidden) ID of the CloudFront distribution associated with the alias.
         */
        var distributionId: String?

        fun build(): ConflictingAlias
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var alias: String? = null
        override var distributionId: String? = null

        constructor(x: ConflictingAlias) : this() {
            this.accountId = x.accountId
            this.alias = x.alias
            this.distributionId = x.distributionId
        }

        override fun build(): ConflictingAlias = ConflictingAlias(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun alias(alias: String): FluentBuilder = apply { this.alias = alias }
        override fun distributionId(distributionId: String): FluentBuilder = apply { this.distributionId = distributionId }
    }
}
