// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Summary of the information about a CloudFront origin access identity.
 */
class CloudFrontOriginAccessIdentitySummary private constructor(builder: BuilderImpl) {
    /**
     * The comment for this origin access identity, as originally specified when
     * created.
     */
    val comment: String? = builder.comment
    /**
     * The ID for the origin access identity. For example:
     * E74FTE3AJFJ256A.
     */
    val id: String? = builder.id
    /**
     * The Amazon S3 canonical user ID for the origin access identity, which you use when giving
     * the origin access identity read permission to an object in Amazon S3.
     */
    val s3CanonicalUserId: String? = builder.s3CanonicalUserId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CloudFrontOriginAccessIdentitySummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFrontOriginAccessIdentitySummary(")
        append("comment=$comment,")
        append("id=$id,")
        append("s3CanonicalUserId=$s3CanonicalUserId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (s3CanonicalUserId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CloudFrontOriginAccessIdentitySummary

        if (comment != other.comment) return false
        if (id != other.id) return false
        if (s3CanonicalUserId != other.s3CanonicalUserId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CloudFrontOriginAccessIdentitySummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CloudFrontOriginAccessIdentitySummary
        /**
         * The comment for this origin access identity, as originally specified when
         * created.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The ID for the origin access identity. For example:
         * E74FTE3AJFJ256A.
         */
        fun id(id: String): FluentBuilder
        /**
         * The Amazon S3 canonical user ID for the origin access identity, which you use when giving
         * the origin access identity read permission to an object in Amazon S3.
         */
        fun s3CanonicalUserId(s3CanonicalUserId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The comment for this origin access identity, as originally specified when
         * created.
         */
        var comment: String?
        /**
         * The ID for the origin access identity. For example:
         * E74FTE3AJFJ256A.
         */
        var id: String?
        /**
         * The Amazon S3 canonical user ID for the origin access identity, which you use when giving
         * the origin access identity read permission to an object in Amazon S3.
         */
        var s3CanonicalUserId: String?

        fun build(): CloudFrontOriginAccessIdentitySummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var comment: String? = null
        override var id: String? = null
        override var s3CanonicalUserId: String? = null

        constructor(x: CloudFrontOriginAccessIdentitySummary) : this() {
            this.comment = x.comment
            this.id = x.id
            this.s3CanonicalUserId = x.s3CanonicalUserId
        }

        override fun build(): CloudFrontOriginAccessIdentitySummary = CloudFrontOriginAccessIdentitySummary(this)
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun s3CanonicalUserId(s3CanonicalUserId: String): FluentBuilder = apply { this.s3CanonicalUserId = s3CanonicalUserId }
    }
}
