// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Lists the origin access identities for CloudFront.Send a GET request to the
 * /CloudFront API version/origin-access-identity/cloudfront
 * resource. The response includes a CloudFrontOriginAccessIdentityList element with
 * zero or more CloudFrontOriginAccessIdentitySummary child elements. By default,
 * your entire list of origin access identities is returned in one single page. If the list is
 * long, you can paginate it using the MaxItems and Marker
 * parameters.
 */
class CloudFrontOriginAccessIdentityList private constructor(builder: BuilderImpl) {
    /**
     * A flag that indicates whether more origin access identities remain to be listed. If
     * your results were truncated, you can make a follow-up pagination request using the
     * Marker request parameter to retrieve more items in the list.
     */
    val isTruncated: Boolean? = builder.isTruncated
    /**
     * A complex type that contains one CloudFrontOriginAccessIdentitySummary
     * element for each origin access identity that was created by the current account.
     */
    val items: List<CloudFrontOriginAccessIdentitySummary>? = builder.items
    /**
     * Use this when paginating results to indicate where to begin in your list of origin
     * access identities. The results include identities in the list that occur after the marker. To
     * get the next page of results, set the Marker to the value of the
     * NextMarker from the current page's response (which is also the ID of the last
     * identity on that page).
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of origin access identities you want in the response body.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * If IsTruncated is true, this element is present and contains
     * the value you can use for the Marker request parameter to continue listing your
     * origin access identities where they left off.
     */
    val nextMarker: String? = builder.nextMarker
    /**
     * The number of CloudFront origin access identities that were created by the current account.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CloudFrontOriginAccessIdentityList = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFrontOriginAccessIdentityList(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CloudFrontOriginAccessIdentityList

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CloudFrontOriginAccessIdentityList = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CloudFrontOriginAccessIdentityList
        /**
         * A flag that indicates whether more origin access identities remain to be listed. If
         * your results were truncated, you can make a follow-up pagination request using the
         * Marker request parameter to retrieve more items in the list.
         */
        fun isTruncated(isTruncated: Boolean): FluentBuilder
        /**
         * A complex type that contains one CloudFrontOriginAccessIdentitySummary
         * element for each origin access identity that was created by the current account.
         */
        fun items(items: List<CloudFrontOriginAccessIdentitySummary>): FluentBuilder
        /**
         * Use this when paginating results to indicate where to begin in your list of origin
         * access identities. The results include identities in the list that occur after the marker. To
         * get the next page of results, set the Marker to the value of the
         * NextMarker from the current page's response (which is also the ID of the last
         * identity on that page).
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of origin access identities you want in the response body.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * If IsTruncated is true, this element is present and contains
         * the value you can use for the Marker request parameter to continue listing your
         * origin access identities where they left off.
         */
        fun nextMarker(nextMarker: String): FluentBuilder
        /**
         * The number of CloudFront origin access identities that were created by the current account.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A flag that indicates whether more origin access identities remain to be listed. If
         * your results were truncated, you can make a follow-up pagination request using the
         * Marker request parameter to retrieve more items in the list.
         */
        var isTruncated: Boolean?
        /**
         * A complex type that contains one CloudFrontOriginAccessIdentitySummary
         * element for each origin access identity that was created by the current account.
         */
        var items: List<CloudFrontOriginAccessIdentitySummary>?
        /**
         * Use this when paginating results to indicate where to begin in your list of origin
         * access identities. The results include identities in the list that occur after the marker. To
         * get the next page of results, set the Marker to the value of the
         * NextMarker from the current page's response (which is also the ID of the last
         * identity on that page).
         */
        var marker: String?
        /**
         * The maximum number of origin access identities you want in the response body.
         */
        var maxItems: Int?
        /**
         * If IsTruncated is true, this element is present and contains
         * the value you can use for the Marker request parameter to continue listing your
         * origin access identities where they left off.
         */
        var nextMarker: String?
        /**
         * The number of CloudFront origin access identities that were created by the current account.
         */
        var quantity: Int?

        fun build(): CloudFrontOriginAccessIdentityList
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var isTruncated: Boolean? = null
        override var items: List<CloudFrontOriginAccessIdentitySummary>? = null
        override var marker: String? = null
        override var maxItems: Int? = null
        override var nextMarker: String? = null
        override var quantity: Int? = null

        constructor(x: CloudFrontOriginAccessIdentityList) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        override fun build(): CloudFrontOriginAccessIdentityList = CloudFrontOriginAccessIdentityList(this)
        override fun isTruncated(isTruncated: Boolean): FluentBuilder = apply { this.isTruncated = isTruncated }
        override fun items(items: List<CloudFrontOriginAccessIdentitySummary>): FluentBuilder = apply { this.items = items }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun nextMarker(nextMarker: String): FluentBuilder = apply { this.nextMarker = nextMarker }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
