// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Origin access identity configuration. Send a GET request to the
 * /CloudFront API version/CloudFront/identity ID/config resource.
 */
class CloudFrontOriginAccessIdentityConfig private constructor(builder: BuilderImpl) {
    /**
     * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
     * If the value of CallerReference is new (regardless of the content of the
     * CloudFrontOriginAccessIdentityConfig object), a new origin access identity is
     * created.
     * If the CallerReference is a value already sent in a previous identity
     * request, and the content of the CloudFrontOriginAccessIdentityConfig is identical
     * to the original request (ignoring white space), the response includes the same information
     * returned to the original request.
     * If the CallerReference is a value you already sent in a previous request
     * to create an identity, but the content of the
     * CloudFrontOriginAccessIdentityConfig is different from the original request,
     * CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists error.
     */
    val callerReference: String? = builder.callerReference
    /**
     * A comment to describe the origin access identity. The comment cannot be longer
     * than 128 characters.
     */
    val comment: String? = builder.comment

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CloudFrontOriginAccessIdentityConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFrontOriginAccessIdentityConfig(")
        append("callerReference=$callerReference,")
        append("comment=$comment)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CloudFrontOriginAccessIdentityConfig

        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CloudFrontOriginAccessIdentityConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CloudFrontOriginAccessIdentityConfig
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         * If the value of CallerReference is new (regardless of the content of the
         * CloudFrontOriginAccessIdentityConfig object), a new origin access identity is
         * created.
         * If the CallerReference is a value already sent in a previous identity
         * request, and the content of the CloudFrontOriginAccessIdentityConfig is identical
         * to the original request (ignoring white space), the response includes the same information
         * returned to the original request.
         * If the CallerReference is a value you already sent in a previous request
         * to create an identity, but the content of the
         * CloudFrontOriginAccessIdentityConfig is different from the original request,
         * CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists error.
         */
        fun callerReference(callerReference: String): FluentBuilder
        /**
         * A comment to describe the origin access identity. The comment cannot be longer
         * than 128 characters.
         */
        fun comment(comment: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         * If the value of CallerReference is new (regardless of the content of the
         * CloudFrontOriginAccessIdentityConfig object), a new origin access identity is
         * created.
         * If the CallerReference is a value already sent in a previous identity
         * request, and the content of the CloudFrontOriginAccessIdentityConfig is identical
         * to the original request (ignoring white space), the response includes the same information
         * returned to the original request.
         * If the CallerReference is a value you already sent in a previous request
         * to create an identity, but the content of the
         * CloudFrontOriginAccessIdentityConfig is different from the original request,
         * CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists error.
         */
        var callerReference: String?
        /**
         * A comment to describe the origin access identity. The comment cannot be longer
         * than 128 characters.
         */
        var comment: String?

        fun build(): CloudFrontOriginAccessIdentityConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var callerReference: String? = null
        override var comment: String? = null

        constructor(x: CloudFrontOriginAccessIdentityConfig) : this() {
            this.callerReference = x.callerReference
            this.comment = x.comment
        }

        override fun build(): CloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig(this)
        override fun callerReference(callerReference: String): FluentBuilder = apply { this.callerReference = callerReference }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
    }
}
