// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * CloudFront origin access identity.
 */
class CloudFrontOriginAccessIdentity private constructor(builder: BuilderImpl) {
    /**
     * The current configuration information for the identity.
     */
    val cloudFrontOriginAccessIdentityConfig: CloudFrontOriginAccessIdentityConfig? = builder.cloudFrontOriginAccessIdentityConfig
    /**
     * The ID for the origin access identity, for example, E74FTE3AJFJ256A.
     */
    val id: String? = builder.id
    /**
     * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin
     * access identity read permission to an object in Amazon S3.
     */
    val s3CanonicalUserId: String? = builder.s3CanonicalUserId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CloudFrontOriginAccessIdentity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFrontOriginAccessIdentity(")
        append("cloudFrontOriginAccessIdentityConfig=$cloudFrontOriginAccessIdentityConfig,")
        append("id=$id,")
        append("s3CanonicalUserId=$s3CanonicalUserId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudFrontOriginAccessIdentityConfig?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (s3CanonicalUserId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CloudFrontOriginAccessIdentity

        if (cloudFrontOriginAccessIdentityConfig != other.cloudFrontOriginAccessIdentityConfig) return false
        if (id != other.id) return false
        if (s3CanonicalUserId != other.s3CanonicalUserId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CloudFrontOriginAccessIdentity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CloudFrontOriginAccessIdentity
        /**
         * The current configuration information for the identity.
         */
        fun cloudFrontOriginAccessIdentityConfig(cloudFrontOriginAccessIdentityConfig: CloudFrontOriginAccessIdentityConfig): FluentBuilder
        /**
         * The ID for the origin access identity, for example, E74FTE3AJFJ256A.
         */
        fun id(id: String): FluentBuilder
        /**
         * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin
         * access identity read permission to an object in Amazon S3.
         */
        fun s3CanonicalUserId(s3CanonicalUserId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The current configuration information for the identity.
         */
        var cloudFrontOriginAccessIdentityConfig: CloudFrontOriginAccessIdentityConfig?
        /**
         * The ID for the origin access identity, for example, E74FTE3AJFJ256A.
         */
        var id: String?
        /**
         * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin
         * access identity read permission to an object in Amazon S3.
         */
        var s3CanonicalUserId: String?

        fun build(): CloudFrontOriginAccessIdentity
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig] inside the given [block]
         */
        fun cloudFrontOriginAccessIdentityConfig(block: CloudFrontOriginAccessIdentityConfig.DslBuilder.() -> kotlin.Unit) {
            this.cloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cloudFrontOriginAccessIdentityConfig: CloudFrontOriginAccessIdentityConfig? = null
        override var id: String? = null
        override var s3CanonicalUserId: String? = null

        constructor(x: CloudFrontOriginAccessIdentity) : this() {
            this.cloudFrontOriginAccessIdentityConfig = x.cloudFrontOriginAccessIdentityConfig
            this.id = x.id
            this.s3CanonicalUserId = x.s3CanonicalUserId
        }

        override fun build(): CloudFrontOriginAccessIdentity = CloudFrontOriginAccessIdentity(this)
        override fun cloudFrontOriginAccessIdentityConfig(cloudFrontOriginAccessIdentityConfig: CloudFrontOriginAccessIdentityConfig): FluentBuilder = apply { this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun s3CanonicalUserId(s3CanonicalUserId: String): FluentBuilder = apply { this.s3CanonicalUserId = s3CanonicalUserId }
    }
}
