// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls whether CloudFront caches the response to requests using the
 * specified HTTP methods. There are two choices:
 * CloudFront caches responses to GET and HEAD requests.
 * CloudFront caches responses to GET, HEAD, and
 * OPTIONS requests.
 * If you pick the second choice for your Amazon S3 Origin, you may need to forward
 * Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
 * responses to be cached correctly.
 */
class CachedMethods private constructor(builder: BuilderImpl) {
    /**
     * A complex type that contains the HTTP methods that you want CloudFront to cache responses
     * to.
     */
    val items: List<Method>? = builder.items
    /**
     * The number of HTTP methods for which you want CloudFront to cache responses. Valid values are
     * 2 (for caching responses to GET and HEAD requests)
     * and 3 (for caching responses to GET, HEAD, and
     * OPTIONS requests).
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CachedMethods = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CachedMethods(")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CachedMethods

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CachedMethods = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CachedMethods
        /**
         * A complex type that contains the HTTP methods that you want CloudFront to cache responses
         * to.
         */
        fun items(items: List<Method>): FluentBuilder
        /**
         * The number of HTTP methods for which you want CloudFront to cache responses. Valid values are
         * 2 (for caching responses to GET and HEAD requests)
         * and 3 (for caching responses to GET, HEAD, and
         * OPTIONS requests).
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that contains the HTTP methods that you want CloudFront to cache responses
         * to.
         */
        var items: List<Method>?
        /**
         * The number of HTTP methods for which you want CloudFront to cache responses. Valid values are
         * 2 (for caching responses to GET and HEAD requests)
         * and 3 (for caching responses to GET, HEAD, and
         * OPTIONS requests).
         */
        var quantity: Int?

        fun build(): CachedMethods
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<Method>? = null
        override var quantity: Int? = null

        constructor(x: CachedMethods) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        override fun build(): CachedMethods = CachedMethods(this)
        override fun items(items: List<Method>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
