// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any URL query strings in viewer requests (and if so, which
 * query strings) are included in the cache key and automatically included in requests that
 * CloudFront sends to the origin.
 */
class CachePolicyQueryStringsConfig private constructor(builder: BuilderImpl) {
    /**
     * Determines whether any URL query strings in viewer requests are included in the cache key
     * and automatically included in requests that CloudFront sends to the origin. Valid values
     * are:
     * none – Query strings in viewer requests are not included in the cache key and
     * are not automatically included in requests that CloudFront sends to the origin. Even
     * when this field is set to none, any query strings that are listed
     * in an OriginRequestPolicy
     * are included in
     * origin requests.
     * whitelist – The query strings in viewer requests that are listed in the
     * QueryStringNames type are included in the cache key and
     * automatically included in requests that CloudFront sends to the origin.
     * allExcept – All query strings in viewer requests that are
     * not
     * listed in the
     * QueryStringNames type are included in the cache key and
     * automatically included in requests that CloudFront sends to the origin.
     * all – All query strings in viewer requests are included in the cache key and
     * are automatically included in requests that CloudFront sends to the origin.
     */
    val queryStringBehavior: CachePolicyQueryStringBehavior? = builder.queryStringBehavior
    /**
     * Contains the specific query strings in viewer requests that either
     * are
     * or
     * are
     * not
     * included in the cache key and automatically included in
     * requests that CloudFront sends to the origin. The behavior depends on whether the
     * QueryStringBehavior field in the CachePolicyQueryStringsConfig
     * type is set to whitelist (the listed query strings
     * are
     * included) or allExcept (the listed
     * query strings
     * are not
     * included,
     * but all other query strings are).
     */
    val queryStrings: QueryStringNames? = builder.queryStrings

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CachePolicyQueryStringsConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyQueryStringsConfig(")
        append("queryStringBehavior=$queryStringBehavior,")
        append("queryStrings=$queryStrings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = queryStringBehavior?.hashCode() ?: 0
        result = 31 * result + (queryStrings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CachePolicyQueryStringsConfig

        if (queryStringBehavior != other.queryStringBehavior) return false
        if (queryStrings != other.queryStrings) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CachePolicyQueryStringsConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CachePolicyQueryStringsConfig
        /**
         * Determines whether any URL query strings in viewer requests are included in the cache key
         * and automatically included in requests that CloudFront sends to the origin. Valid values
         * are:
         * none – Query strings in viewer requests are not included in the cache key and
         * are not automatically included in requests that CloudFront sends to the origin. Even
         * when this field is set to none, any query strings that are listed
         * in an OriginRequestPolicy
         * are included in
         * origin requests.
         * whitelist – The query strings in viewer requests that are listed in the
         * QueryStringNames type are included in the cache key and
         * automatically included in requests that CloudFront sends to the origin.
         * allExcept – All query strings in viewer requests that are
         * not
         * listed in the
         * QueryStringNames type are included in the cache key and
         * automatically included in requests that CloudFront sends to the origin.
         * all – All query strings in viewer requests are included in the cache key and
         * are automatically included in requests that CloudFront sends to the origin.
         */
        fun queryStringBehavior(queryStringBehavior: CachePolicyQueryStringBehavior): FluentBuilder
        /**
         * Contains the specific query strings in viewer requests that either
         * are
         * or
         * are
         * not
         * included in the cache key and automatically included in
         * requests that CloudFront sends to the origin. The behavior depends on whether the
         * QueryStringBehavior field in the CachePolicyQueryStringsConfig
         * type is set to whitelist (the listed query strings
         * are
         * included) or allExcept (the listed
         * query strings
         * are not
         * included,
         * but all other query strings are).
         */
        fun queryStrings(queryStrings: QueryStringNames): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Determines whether any URL query strings in viewer requests are included in the cache key
         * and automatically included in requests that CloudFront sends to the origin. Valid values
         * are:
         * none – Query strings in viewer requests are not included in the cache key and
         * are not automatically included in requests that CloudFront sends to the origin. Even
         * when this field is set to none, any query strings that are listed
         * in an OriginRequestPolicy
         * are included in
         * origin requests.
         * whitelist – The query strings in viewer requests that are listed in the
         * QueryStringNames type are included in the cache key and
         * automatically included in requests that CloudFront sends to the origin.
         * allExcept – All query strings in viewer requests that are
         * not
         * listed in the
         * QueryStringNames type are included in the cache key and
         * automatically included in requests that CloudFront sends to the origin.
         * all – All query strings in viewer requests are included in the cache key and
         * are automatically included in requests that CloudFront sends to the origin.
         */
        var queryStringBehavior: CachePolicyQueryStringBehavior?
        /**
         * Contains the specific query strings in viewer requests that either
         * are
         * or
         * are
         * not
         * included in the cache key and automatically included in
         * requests that CloudFront sends to the origin. The behavior depends on whether the
         * QueryStringBehavior field in the CachePolicyQueryStringsConfig
         * type is set to whitelist (the listed query strings
         * are
         * included) or allExcept (the listed
         * query strings
         * are not
         * included,
         * but all other query strings are).
         */
        var queryStrings: QueryStringNames?

        fun build(): CachePolicyQueryStringsConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.QueryStringNames] inside the given [block]
         */
        fun queryStrings(block: QueryStringNames.DslBuilder.() -> kotlin.Unit) {
            this.queryStrings = QueryStringNames.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var queryStringBehavior: CachePolicyQueryStringBehavior? = null
        override var queryStrings: QueryStringNames? = null

        constructor(x: CachePolicyQueryStringsConfig) : this() {
            this.queryStringBehavior = x.queryStringBehavior
            this.queryStrings = x.queryStrings
        }

        override fun build(): CachePolicyQueryStringsConfig = CachePolicyQueryStringsConfig(this)
        override fun queryStringBehavior(queryStringBehavior: CachePolicyQueryStringBehavior): FluentBuilder = apply { this.queryStringBehavior = queryStringBehavior }
        override fun queryStrings(queryStrings: QueryStringNames): FluentBuilder = apply { this.queryStrings = queryStrings }
    }
}
