// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of cache policies.
 */
class CachePolicyList private constructor(builder: BuilderImpl) {
    /**
     * Contains the cache policies in the list.
     */
    val items: List<CachePolicySummary>? = builder.items
    /**
     * The maximum number of cache policies requested.
     */
    val maxItems: Int? = builder.maxItems
    /**
     * If there are more items in the list than are in this response, this element is
     * present. It contains the value that you should use in the Marker field of a
     * subsequent request to continue listing cache policies where you left off.
     */
    val nextMarker: String? = builder.nextMarker
    /**
     * The total number of cache policies returned in the response.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CachePolicyList = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyList(")
        append("items=$items,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CachePolicyList

        if (items != other.items) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CachePolicyList = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CachePolicyList
        /**
         * Contains the cache policies in the list.
         */
        fun items(items: List<CachePolicySummary>): FluentBuilder
        /**
         * The maximum number of cache policies requested.
         */
        fun maxItems(maxItems: Int): FluentBuilder
        /**
         * If there are more items in the list than are in this response, this element is
         * present. It contains the value that you should use in the Marker field of a
         * subsequent request to continue listing cache policies where you left off.
         */
        fun nextMarker(nextMarker: String): FluentBuilder
        /**
         * The total number of cache policies returned in the response.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains the cache policies in the list.
         */
        var items: List<CachePolicySummary>?
        /**
         * The maximum number of cache policies requested.
         */
        var maxItems: Int?
        /**
         * If there are more items in the list than are in this response, this element is
         * present. It contains the value that you should use in the Marker field of a
         * subsequent request to continue listing cache policies where you left off.
         */
        var nextMarker: String?
        /**
         * The total number of cache policies returned in the response.
         */
        var quantity: Int?

        fun build(): CachePolicyList
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<CachePolicySummary>? = null
        override var maxItems: Int? = null
        override var nextMarker: String? = null
        override var quantity: Int? = null

        constructor(x: CachePolicyList) : this() {
            this.items = x.items
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        override fun build(): CachePolicyList = CachePolicyList(this)
        override fun items(items: List<CachePolicySummary>): FluentBuilder = apply { this.items = items }
        override fun maxItems(maxItems: Int): FluentBuilder = apply { this.maxItems = maxItems }
        override fun nextMarker(nextMarker: String): FluentBuilder = apply { this.nextMarker = nextMarker }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
