// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any HTTP headers (and if so, which headers) are included
 * in the cache key and automatically included in requests that CloudFront sends to the
 * origin.
 */
class CachePolicyHeadersConfig private constructor(builder: BuilderImpl) {
    /**
     * Determines whether any HTTP headers are included in the cache key and automatically
     * included in requests that CloudFront sends to the origin. Valid values are:
     * none – HTTP headers are not included in the cache key and are not
     * automatically included in requests that CloudFront sends to the origin. Even when this
     * field is set to none, any headers that are listed in an
     * OriginRequestPolicy
     * are included in origin
     * requests.
     * whitelist – The HTTP headers that are listed in the Headers type
     * are included in the cache key and are automatically included in requests that
     * CloudFront sends to the origin.
     */
    val headerBehavior: CachePolicyHeaderBehavior? = builder.headerBehavior
    /**
     * Contains a list of HTTP header names.
     */
    val headers: Headers? = builder.headers

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CachePolicyHeadersConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyHeadersConfig(")
        append("headerBehavior=$headerBehavior,")
        append("headers=$headers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = headerBehavior?.hashCode() ?: 0
        result = 31 * result + (headers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CachePolicyHeadersConfig

        if (headerBehavior != other.headerBehavior) return false
        if (headers != other.headers) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CachePolicyHeadersConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CachePolicyHeadersConfig
        /**
         * Determines whether any HTTP headers are included in the cache key and automatically
         * included in requests that CloudFront sends to the origin. Valid values are:
         * none – HTTP headers are not included in the cache key and are not
         * automatically included in requests that CloudFront sends to the origin. Even when this
         * field is set to none, any headers that are listed in an
         * OriginRequestPolicy
         * are included in origin
         * requests.
         * whitelist – The HTTP headers that are listed in the Headers type
         * are included in the cache key and are automatically included in requests that
         * CloudFront sends to the origin.
         */
        fun headerBehavior(headerBehavior: CachePolicyHeaderBehavior): FluentBuilder
        /**
         * Contains a list of HTTP header names.
         */
        fun headers(headers: Headers): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Determines whether any HTTP headers are included in the cache key and automatically
         * included in requests that CloudFront sends to the origin. Valid values are:
         * none – HTTP headers are not included in the cache key and are not
         * automatically included in requests that CloudFront sends to the origin. Even when this
         * field is set to none, any headers that are listed in an
         * OriginRequestPolicy
         * are included in origin
         * requests.
         * whitelist – The HTTP headers that are listed in the Headers type
         * are included in the cache key and are automatically included in requests that
         * CloudFront sends to the origin.
         */
        var headerBehavior: CachePolicyHeaderBehavior?
        /**
         * Contains a list of HTTP header names.
         */
        var headers: Headers?

        fun build(): CachePolicyHeadersConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Headers] inside the given [block]
         */
        fun headers(block: Headers.DslBuilder.() -> kotlin.Unit) {
            this.headers = Headers.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var headerBehavior: CachePolicyHeaderBehavior? = null
        override var headers: Headers? = null

        constructor(x: CachePolicyHeadersConfig) : this() {
            this.headerBehavior = x.headerBehavior
            this.headers = x.headers
        }

        override fun build(): CachePolicyHeadersConfig = CachePolicyHeadersConfig(this)
        override fun headerBehavior(headerBehavior: CachePolicyHeaderBehavior): FluentBuilder = apply { this.headerBehavior = headerBehavior }
        override fun headers(headers: Headers): FluentBuilder = apply { this.headers = headers }
    }
}
