// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A cache policy configuration.
 * This configuration determines the following:
 * The values that CloudFront includes in the cache key. These values can include HTTP headers,
 * cookies, and URL query strings. CloudFront uses the cache key to find an object in its
 * cache that it can return to the viewer.
 * The default, minimum, and maximum time to live (TTL) values that you want objects to stay
 * in the CloudFront cache.
 * The headers, cookies, and query strings that are included in the cache key are automatically
 * included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
 * find a valid object in its cache that matches the request’s cache key. If you want to
 * send values to the origin but not include them in the cache key,
 * use OriginRequestPolicy.
 */
class CachePolicyConfig private constructor(builder: BuilderImpl) {
    /**
     * A comment to describe the cache policy. The comment cannot be longer than 128
     * characters.
     */
    val comment: String? = builder.comment
    /**
     * The default amount of time, in seconds, that you want objects to stay in the CloudFront
     * cache before CloudFront sends another request to the origin to see if the object has been
     * updated. CloudFront uses this value as the object’s time to live (TTL) only when the origin
     * does not send Cache-Control or Expires
     * headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
     * Amazon CloudFront Developer Guide.
     * The default value for this field is 86400 seconds (one day). If the value of
     * MinTTL is more than 86400 seconds, then the default value for this field is
     * the same as the value of MinTTL.
     */
    val defaultTtl: Long? = builder.defaultTtl
    /**
     * The maximum amount of time, in seconds, that objects stay in the CloudFront cache
     * before CloudFront sends another request to the origin to see if the object has been updated.
     * CloudFront uses this value only when the origin sends Cache-Control or
     * Expires headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
     * Amazon CloudFront Developer Guide.
     * The default value for this field is 31536000 seconds (one year). If the value of
     * MinTTL or DefaultTTL is more than 31536000 seconds, then the
     * default value for this field is the same as the value of DefaultTTL.
     */
    val maxTtl: Long? = builder.maxTtl
    /**
     * The minimum amount of time, in seconds, that you want objects to stay in the CloudFront
     * cache before CloudFront sends another request to the origin to see if the object has been
     * updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
     * Amazon CloudFront Developer Guide.
     */
    val minTtl: Long? = builder.minTtl
    /**
     * A unique name to identify the cache policy.
     */
    val name: String? = builder.name
    /**
     * The HTTP headers, cookies, and URL query strings to include in the cache key. The
     * values included in the cache key are automatically included in requests that CloudFront sends
     * to the origin.
     */
    val parametersInCacheKeyAndForwardedToOrigin: ParametersInCacheKeyAndForwardedToOrigin? = builder.parametersInCacheKeyAndForwardedToOrigin

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CachePolicyConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyConfig(")
        append("comment=$comment,")
        append("defaultTtl=$defaultTtl,")
        append("maxTtl=$maxTtl,")
        append("minTtl=$minTtl,")
        append("name=$name,")
        append("parametersInCacheKeyAndForwardedToOrigin=$parametersInCacheKeyAndForwardedToOrigin)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (defaultTtl?.hashCode() ?: 0)
        result = 31 * result + (maxTtl?.hashCode() ?: 0)
        result = 31 * result + (minTtl?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parametersInCacheKeyAndForwardedToOrigin?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CachePolicyConfig

        if (comment != other.comment) return false
        if (defaultTtl != other.defaultTtl) return false
        if (maxTtl != other.maxTtl) return false
        if (minTtl != other.minTtl) return false
        if (name != other.name) return false
        if (parametersInCacheKeyAndForwardedToOrigin != other.parametersInCacheKeyAndForwardedToOrigin) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CachePolicyConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CachePolicyConfig
        /**
         * A comment to describe the cache policy. The comment cannot be longer than 128
         * characters.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The default amount of time, in seconds, that you want objects to stay in the CloudFront
         * cache before CloudFront sends another request to the origin to see if the object has been
         * updated. CloudFront uses this value as the object’s time to live (TTL) only when the origin
         * does not send Cache-Control or Expires
         * headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
         * Amazon CloudFront Developer Guide.
         * The default value for this field is 86400 seconds (one day). If the value of
         * MinTTL is more than 86400 seconds, then the default value for this field is
         * the same as the value of MinTTL.
         */
        fun defaultTtl(defaultTtl: Long): FluentBuilder
        /**
         * The maximum amount of time, in seconds, that objects stay in the CloudFront cache
         * before CloudFront sends another request to the origin to see if the object has been updated.
         * CloudFront uses this value only when the origin sends Cache-Control or
         * Expires headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
         * Amazon CloudFront Developer Guide.
         * The default value for this field is 31536000 seconds (one year). If the value of
         * MinTTL or DefaultTTL is more than 31536000 seconds, then the
         * default value for this field is the same as the value of DefaultTTL.
         */
        fun maxTtl(maxTtl: Long): FluentBuilder
        /**
         * The minimum amount of time, in seconds, that you want objects to stay in the CloudFront
         * cache before CloudFront sends another request to the origin to see if the object has been
         * updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
         * Amazon CloudFront Developer Guide.
         */
        fun minTtl(minTtl: Long): FluentBuilder
        /**
         * A unique name to identify the cache policy.
         */
        fun name(name: String): FluentBuilder
        /**
         * The HTTP headers, cookies, and URL query strings to include in the cache key. The
         * values included in the cache key are automatically included in requests that CloudFront sends
         * to the origin.
         */
        fun parametersInCacheKeyAndForwardedToOrigin(parametersInCacheKeyAndForwardedToOrigin: ParametersInCacheKeyAndForwardedToOrigin): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A comment to describe the cache policy. The comment cannot be longer than 128
         * characters.
         */
        var comment: String?
        /**
         * The default amount of time, in seconds, that you want objects to stay in the CloudFront
         * cache before CloudFront sends another request to the origin to see if the object has been
         * updated. CloudFront uses this value as the object’s time to live (TTL) only when the origin
         * does not send Cache-Control or Expires
         * headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
         * Amazon CloudFront Developer Guide.
         * The default value for this field is 86400 seconds (one day). If the value of
         * MinTTL is more than 86400 seconds, then the default value for this field is
         * the same as the value of MinTTL.
         */
        var defaultTtl: Long?
        /**
         * The maximum amount of time, in seconds, that objects stay in the CloudFront cache
         * before CloudFront sends another request to the origin to see if the object has been updated.
         * CloudFront uses this value only when the origin sends Cache-Control or
         * Expires headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
         * Amazon CloudFront Developer Guide.
         * The default value for this field is 31536000 seconds (one year). If the value of
         * MinTTL or DefaultTTL is more than 31536000 seconds, then the
         * default value for this field is the same as the value of DefaultTTL.
         */
        var maxTtl: Long?
        /**
         * The minimum amount of time, in seconds, that you want objects to stay in the CloudFront
         * cache before CloudFront sends another request to the origin to see if the object has been
         * updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration) in the
         * Amazon CloudFront Developer Guide.
         */
        var minTtl: Long?
        /**
         * A unique name to identify the cache policy.
         */
        var name: String?
        /**
         * The HTTP headers, cookies, and URL query strings to include in the cache key. The
         * values included in the cache key are automatically included in requests that CloudFront sends
         * to the origin.
         */
        var parametersInCacheKeyAndForwardedToOrigin: ParametersInCacheKeyAndForwardedToOrigin?

        fun build(): CachePolicyConfig
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin] inside the given [block]
         */
        fun parametersInCacheKeyAndForwardedToOrigin(block: ParametersInCacheKeyAndForwardedToOrigin.DslBuilder.() -> kotlin.Unit) {
            this.parametersInCacheKeyAndForwardedToOrigin = ParametersInCacheKeyAndForwardedToOrigin.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var comment: String? = null
        override var defaultTtl: Long? = null
        override var maxTtl: Long? = null
        override var minTtl: Long? = null
        override var name: String? = null
        override var parametersInCacheKeyAndForwardedToOrigin: ParametersInCacheKeyAndForwardedToOrigin? = null

        constructor(x: CachePolicyConfig) : this() {
            this.comment = x.comment
            this.defaultTtl = x.defaultTtl
            this.maxTtl = x.maxTtl
            this.minTtl = x.minTtl
            this.name = x.name
            this.parametersInCacheKeyAndForwardedToOrigin = x.parametersInCacheKeyAndForwardedToOrigin
        }

        override fun build(): CachePolicyConfig = CachePolicyConfig(this)
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun defaultTtl(defaultTtl: Long): FluentBuilder = apply { this.defaultTtl = defaultTtl }
        override fun maxTtl(maxTtl: Long): FluentBuilder = apply { this.maxTtl = maxTtl }
        override fun minTtl(minTtl: Long): FluentBuilder = apply { this.minTtl = minTtl }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun parametersInCacheKeyAndForwardedToOrigin(parametersInCacheKeyAndForwardedToOrigin: ParametersInCacheKeyAndForwardedToOrigin): FluentBuilder = apply { this.parametersInCacheKeyAndForwardedToOrigin = parametersInCacheKeyAndForwardedToOrigin }
    }
}
