// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A cache policy.
 * When it’s attached to a cache behavior, the cache policy determines the
 * following:
 * The values that CloudFront includes in the cache key. These values can include HTTP headers,
 * cookies, and URL query strings. CloudFront uses the cache key to find an object in its
 * cache that it can return to the viewer.
 * The default, minimum, and maximum time to live (TTL) values that you want objects to stay
 * in the CloudFront cache.
 * The headers, cookies, and query strings that are included in the cache key are automatically
 * included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
 * find a valid object in its cache that matches the request’s cache key. If you want to
 * send values to the origin but not include them in the cache key,
 * use OriginRequestPolicy.
 */
class CachePolicy private constructor(builder: BuilderImpl) {
    /**
     * The cache policy configuration.
     */
    val cachePolicyConfig: CachePolicyConfig? = builder.cachePolicyConfig
    /**
     * The unique identifier for the cache policy.
     */
    val id: String? = builder.id
    /**
     * The date and time when the cache policy was last modified.
     */
    val lastModifiedTime: Instant? = builder.lastModifiedTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CachePolicy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicy(")
        append("cachePolicyConfig=$cachePolicyConfig,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cachePolicyConfig?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CachePolicy

        if (cachePolicyConfig != other.cachePolicyConfig) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CachePolicy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CachePolicy
        /**
         * The cache policy configuration.
         */
        fun cachePolicyConfig(cachePolicyConfig: CachePolicyConfig): FluentBuilder
        /**
         * The unique identifier for the cache policy.
         */
        fun id(id: String): FluentBuilder
        /**
         * The date and time when the cache policy was last modified.
         */
        fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cache policy configuration.
         */
        var cachePolicyConfig: CachePolicyConfig?
        /**
         * The unique identifier for the cache policy.
         */
        var id: String?
        /**
         * The date and time when the cache policy was last modified.
         */
        var lastModifiedTime: Instant?

        fun build(): CachePolicy
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig] inside the given [block]
         */
        fun cachePolicyConfig(block: CachePolicyConfig.DslBuilder.() -> kotlin.Unit) {
            this.cachePolicyConfig = CachePolicyConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cachePolicyConfig: CachePolicyConfig? = null
        override var id: String? = null
        override var lastModifiedTime: Instant? = null

        constructor(x: CachePolicy) : this() {
            this.cachePolicyConfig = x.cachePolicyConfig
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
        }

        override fun build(): CachePolicy = CachePolicy(this)
        override fun cachePolicyConfig(cachePolicyConfig: CachePolicyConfig): FluentBuilder = apply { this.cachePolicyConfig = cachePolicyConfig }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastModifiedTime(lastModifiedTime: Instant): FluentBuilder = apply { this.lastModifiedTime = lastModifiedTime }
    }
}
