// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls which HTTP methods CloudFront processes and forwards to your
 * Amazon S3 bucket or your custom origin. There are three choices:
 * CloudFront forwards only GET and HEAD requests.
 * CloudFront forwards only GET, HEAD, and OPTIONS
 * requests.
 * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and
 * DELETE requests.
 * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
 * to your custom origin so users can't perform operations that you don't want them to. For
 * example, you might not want users to have permissions to delete objects from your
 * origin.
 */
class AllowedMethods private constructor(builder: BuilderImpl) {
    /**
     * A complex type that controls whether CloudFront caches the response to requests using the
     * specified HTTP methods. There are two choices:
     * CloudFront caches responses to GET and HEAD requests.
     * CloudFront caches responses to GET, HEAD, and
     * OPTIONS requests.
     * If you pick the second choice for your Amazon S3 Origin, you may need to forward
     * Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
     * responses to be cached correctly.
     */
    val cachedMethods: CachedMethods? = builder.cachedMethods
    /**
     * A complex type that contains the HTTP methods that you want CloudFront to process and forward
     * to your origin.
     */
    val items: List<Method>? = builder.items
    /**
     * The number of HTTP methods that you want CloudFront to forward to your origin. Valid values
     * are 2 (for GET and HEAD requests), 3 (for GET,
     * HEAD, and OPTIONS requests) and 7 (for GET, HEAD, OPTIONS,
     * PUT, PATCH, POST, and DELETE requests).
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AllowedMethods = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AllowedMethods(")
        append("cachedMethods=$cachedMethods,")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cachedMethods?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AllowedMethods

        if (cachedMethods != other.cachedMethods) return false
        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AllowedMethods = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AllowedMethods
        /**
         * A complex type that controls whether CloudFront caches the response to requests using the
         * specified HTTP methods. There are two choices:
         * CloudFront caches responses to GET and HEAD requests.
         * CloudFront caches responses to GET, HEAD, and
         * OPTIONS requests.
         * If you pick the second choice for your Amazon S3 Origin, you may need to forward
         * Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
         * responses to be cached correctly.
         */
        fun cachedMethods(cachedMethods: CachedMethods): FluentBuilder
        /**
         * A complex type that contains the HTTP methods that you want CloudFront to process and forward
         * to your origin.
         */
        fun items(items: List<Method>): FluentBuilder
        /**
         * The number of HTTP methods that you want CloudFront to forward to your origin. Valid values
         * are 2 (for GET and HEAD requests), 3 (for GET,
         * HEAD, and OPTIONS requests) and 7 (for GET, HEAD, OPTIONS,
         * PUT, PATCH, POST, and DELETE requests).
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A complex type that controls whether CloudFront caches the response to requests using the
         * specified HTTP methods. There are two choices:
         * CloudFront caches responses to GET and HEAD requests.
         * CloudFront caches responses to GET, HEAD, and
         * OPTIONS requests.
         * If you pick the second choice for your Amazon S3 Origin, you may need to forward
         * Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
         * responses to be cached correctly.
         */
        var cachedMethods: CachedMethods?
        /**
         * A complex type that contains the HTTP methods that you want CloudFront to process and forward
         * to your origin.
         */
        var items: List<Method>?
        /**
         * The number of HTTP methods that you want CloudFront to forward to your origin. Valid values
         * are 2 (for GET and HEAD requests), 3 (for GET,
         * HEAD, and OPTIONS requests) and 7 (for GET, HEAD, OPTIONS,
         * PUT, PATCH, POST, and DELETE requests).
         */
        var quantity: Int?

        fun build(): AllowedMethods
        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachedMethods] inside the given [block]
         */
        fun cachedMethods(block: CachedMethods.DslBuilder.() -> kotlin.Unit) {
            this.cachedMethods = CachedMethods.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cachedMethods: CachedMethods? = null
        override var items: List<Method>? = null
        override var quantity: Int? = null

        constructor(x: AllowedMethods) : this() {
            this.cachedMethods = x.cachedMethods
            this.items = x.items
            this.quantity = x.quantity
        }

        override fun build(): AllowedMethods = AllowedMethods(this)
        override fun cachedMethods(cachedMethods: CachedMethods): FluentBuilder = apply { this.cachedMethods = cachedMethods }
        override fun items(items: List<Method>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
