// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
 * publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
 * recordal status for CNAMEs associated with distributions. The status is returned in the CloudFront response; you can't configure
 * it yourself.
 * For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
 * Signup, Accounts, and Credentials in Getting Started with Amazon Web Services services in China.
 */
class AliasIcpRecordal private constructor(builder: BuilderImpl) {
    /**
     * A domain name associated with a distribution.
     */
    val cname: String? = builder.cname
    /**
     * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
     * APPROVED for all CNAMEs (aliases) in regions outside of China.
     * The status values returned are the following:
     * APPROVED indicates that the associated CNAME has a valid ICP recordal number.
     * Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
     * APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.
     * SUSPENDED indicates that the associated CNAME does not have a valid ICP recordal
     * number.
     * PENDING indicates that CloudFront can't determine the ICP recordal status of the
     * CNAME associated with the distribution because there was an error in trying to determine the status. You can try again
     * to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
     */
    val icpRecordalStatus: IcpRecordalStatus? = builder.icpRecordalStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AliasIcpRecordal = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AliasIcpRecordal(")
        append("cname=$cname,")
        append("icpRecordalStatus=$icpRecordalStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cname?.hashCode() ?: 0
        result = 31 * result + (icpRecordalStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AliasIcpRecordal

        if (cname != other.cname) return false
        if (icpRecordalStatus != other.icpRecordalStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AliasIcpRecordal = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AliasIcpRecordal
        /**
         * A domain name associated with a distribution.
         */
        fun cname(cname: String): FluentBuilder
        /**
         * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
         * APPROVED for all CNAMEs (aliases) in regions outside of China.
         * The status values returned are the following:
         * APPROVED indicates that the associated CNAME has a valid ICP recordal number.
         * Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
         * APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.
         * SUSPENDED indicates that the associated CNAME does not have a valid ICP recordal
         * number.
         * PENDING indicates that CloudFront can't determine the ICP recordal status of the
         * CNAME associated with the distribution because there was an error in trying to determine the status. You can try again
         * to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
         */
        fun icpRecordalStatus(icpRecordalStatus: IcpRecordalStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A domain name associated with a distribution.
         */
        var cname: String?
        /**
         * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
         * APPROVED for all CNAMEs (aliases) in regions outside of China.
         * The status values returned are the following:
         * APPROVED indicates that the associated CNAME has a valid ICP recordal number.
         * Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
         * APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.
         * SUSPENDED indicates that the associated CNAME does not have a valid ICP recordal
         * number.
         * PENDING indicates that CloudFront can't determine the ICP recordal status of the
         * CNAME associated with the distribution because there was an error in trying to determine the status. You can try again
         * to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
         */
        var icpRecordalStatus: IcpRecordalStatus?

        fun build(): AliasIcpRecordal
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cname: String? = null
        override var icpRecordalStatus: IcpRecordalStatus? = null

        constructor(x: AliasIcpRecordal) : this() {
            this.cname = x.cname
            this.icpRecordalStatus = x.icpRecordalStatus
        }

        override fun build(): AliasIcpRecordal = AliasIcpRecordal(this)
        override fun cname(cname: String): FluentBuilder = apply { this.cname = cname }
        override fun icpRecordalStatus(icpRecordalStatus: IcpRecordalStatus): FluentBuilder = apply { this.icpRecordalStatus = icpRecordalStatus }
    }
}
