// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of key groups, and the public keys in each key group,
 * that CloudFront can use to verify the signatures of signed URLs and signed cookies.
 */
class ActiveTrustedKeyGroups private constructor(builder: BuilderImpl) {
    /**
     * This field is true if any of the key groups have public keys that CloudFront can use
     * to verify the signatures of signed URLs and signed cookies. If not, this field is
     * false.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * A list of key groups, including the identifiers of the public keys in each key group that
     * CloudFront can use to verify the signatures of signed URLs and signed cookies.
     */
    val items: List<KgKeyPairIds>? = builder.items
    /**
     * The number of key groups in the list.
     */
    val quantity: Int? = builder.quantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ActiveTrustedKeyGroups = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveTrustedKeyGroups(")
        append("enabled=$enabled,")
        append("items=$items,")
        append("quantity=$quantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ActiveTrustedKeyGroups

        if (enabled != other.enabled) return false
        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ActiveTrustedKeyGroups = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ActiveTrustedKeyGroups
        /**
         * This field is true if any of the key groups have public keys that CloudFront can use
         * to verify the signatures of signed URLs and signed cookies. If not, this field is
         * false.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * A list of key groups, including the identifiers of the public keys in each key group that
         * CloudFront can use to verify the signatures of signed URLs and signed cookies.
         */
        fun items(items: List<KgKeyPairIds>): FluentBuilder
        /**
         * The number of key groups in the list.
         */
        fun quantity(quantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * This field is true if any of the key groups have public keys that CloudFront can use
         * to verify the signatures of signed URLs and signed cookies. If not, this field is
         * false.
         */
        var enabled: Boolean?
        /**
         * A list of key groups, including the identifiers of the public keys in each key group that
         * CloudFront can use to verify the signatures of signed URLs and signed cookies.
         */
        var items: List<KgKeyPairIds>?
        /**
         * The number of key groups in the list.
         */
        var quantity: Int?

        fun build(): ActiveTrustedKeyGroups
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enabled: Boolean? = null
        override var items: List<KgKeyPairIds>? = null
        override var quantity: Int? = null

        constructor(x: ActiveTrustedKeyGroups) : this() {
            this.enabled = x.enabled
            this.items = x.items
            this.quantity = x.quantity
        }

        override fun build(): ActiveTrustedKeyGroups = ActiveTrustedKeyGroups(this)
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun items(items: List<KgKeyPairIds>): FluentBuilder = apply { this.items = items }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
    }
}
