// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.cloudfront.model.*
import aws.sdk.kotlin.services.cloudfront.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "CloudFront"
const val ServiceApiVersion: String = "2020-05-31"
const val SdkVersion: String = "0.9.1-alpha"

internal class DefaultCloudFrontClient(override val config: CloudFrontClient.Config) : CloudFrontClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront
     * distribution.
     * With this operation you can move an alias that’s already in use on a CloudFront distribution
     * to a different distribution in one step. This prevents the downtime that could occur if
     * you first remove the alias from one distribution and then separately add the alias to
     * another distribution.
     * To use this operation to associate an alias with a distribution, you provide the alias
     * and the ID of the target distribution for the alias. For more information, including how
     * to set up the target distribution, prerequisites that you must complete, and other
     * restrictions, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution
     * in the Amazon CloudFront Developer Guide.
     */
    override suspend fun associateAlias(input: AssociateAliasRequest): AssociateAliasResponse {
        val op = SdkHttpOperation.build<AssociateAliasRequest, AssociateAliasResponse> {
            serializer = AssociateAliasOperationSerializer()
            deserializer = AssociateAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateAlias"
            }
        }
        registerAssociateAliasMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a cache policy.
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it’s
     * attached to a cache behavior, the cache policy determines the following:
     * The values that CloudFront includes in the cache key. These values can
     * include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to
     * find an object in its cache that it can return to the viewer.
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay
     * in the CloudFront cache.
     * The headers, cookies, and query strings that are included in the cache key are automatically
     * included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
     * find an object in its cache that matches the request’s cache key. If you want to send
     * values to the origin but not include them in the cache key, use
     * OriginRequestPolicy.
     * For more information about cache policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">Controlling the cache key in the
     * Amazon CloudFront Developer Guide.
     */
    override suspend fun createCachePolicy(input: CreateCachePolicyRequest): CreateCachePolicyResponse {
        val op = SdkHttpOperation.build<CreateCachePolicyRequest, CreateCachePolicyResponse> {
            serializer = CreateCachePolicyOperationSerializer()
            deserializer = CreateCachePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateCachePolicy"
            }
        }
        registerCreateCachePolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can
     * use an origin access identity to require users to access your content using a CloudFront URL instead
     * of the Amazon S3 URL. For more information about how to use origin access identities, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront in the
     * Amazon CloudFront Developer Guide.
     */
    override suspend fun createCloudFrontOriginAccessIdentity(input: CreateCloudFrontOriginAccessIdentityRequest): CreateCloudFrontOriginAccessIdentityResponse {
        val op = SdkHttpOperation.build<CreateCloudFrontOriginAccessIdentityRequest, CreateCloudFrontOriginAccessIdentityResponse> {
            serializer = CreateCloudFrontOriginAccessIdentityOperationSerializer()
            deserializer = CreateCloudFrontOriginAccessIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateCloudFrontOriginAccessIdentity"
            }
        }
        registerCreateCloudFrontOriginAccessIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you
     * want content to be delivered from, and the details about how to track and manage content delivery. Send a POST request to the
     * /CloudFront API version/distribution/distribution ID resource.
     * When you update a distribution, there are more required fields than when you create a distribution.
     * When you update your distribution by using
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution,
     * follow the steps included
     * in the documentation to get the current configuration
     * and then make your updates. This helps to make sure that you include all of the required fields. To view a summary,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required
     * Fields for Create Distribution and Update Distribution in the Amazon CloudFront Developer Guide.
     */
    override suspend fun createDistribution(input: CreateDistributionRequest): CreateDistributionResponse {
        val op = SdkHttpOperation.build<CreateDistributionRequest, CreateDistributionResponse> {
            serializer = CreateDistributionOperationSerializer()
            deserializer = CreateDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDistribution"
            }
        }
        registerCreateDistributionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Create a new distribution with tags.
     */
    override suspend fun createDistributionWithTags(input: CreateDistributionWithTagsRequest): CreateDistributionWithTagsResponse {
        val op = SdkHttpOperation.build<CreateDistributionWithTagsRequest, CreateDistributionWithTagsResponse> {
            serializer = CreateDistributionWithTagsOperationSerializer()
            deserializer = CreateDistributionWithTagsOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDistributionWithTags"
            }
        }
        registerCreateDistributionWithTagsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Create a new field-level encryption configuration.
     */
    override suspend fun createFieldLevelEncryptionConfig(input: CreateFieldLevelEncryptionConfigRequest): CreateFieldLevelEncryptionConfigResponse {
        val op = SdkHttpOperation.build<CreateFieldLevelEncryptionConfigRequest, CreateFieldLevelEncryptionConfigResponse> {
            serializer = CreateFieldLevelEncryptionConfigOperationSerializer()
            deserializer = CreateFieldLevelEncryptionConfigOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateFieldLevelEncryptionConfig"
            }
        }
        registerCreateFieldLevelEncryptionConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Create a field-level encryption profile.
     */
    override suspend fun createFieldLevelEncryptionProfile(input: CreateFieldLevelEncryptionProfileRequest): CreateFieldLevelEncryptionProfileResponse {
        val op = SdkHttpOperation.build<CreateFieldLevelEncryptionProfileRequest, CreateFieldLevelEncryptionProfileResponse> {
            serializer = CreateFieldLevelEncryptionProfileOperationSerializer()
            deserializer = CreateFieldLevelEncryptionProfileOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateFieldLevelEncryptionProfile"
            }
        }
        registerCreateFieldLevelEncryptionProfileMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a CloudFront function.
     * To create a function, you provide the function code and some configuration information
     * about the function. The response contains an Amazon Resource Name (ARN) that uniquely
     * identifies the function.
     * When you create a function, it’s in the DEVELOPMENT stage. In this stage, you
     * can test the function with TestFunction, and update it with
     * UpdateFunction.
     * When you’re ready to use your function with a CloudFront distribution, use
     * PublishFunction to copy the function from the DEVELOPMENT
     * stage to LIVE. When it’s live, you can attach the function to a
     * distribution’s cache behavior, using the function’s ARN.
     */
    override suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse {
        val op = SdkHttpOperation.build<CreateFunctionRequest, CreateFunctionResponse> {
            serializer = CreateFunctionOperationSerializer()
            deserializer = CreateFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateFunction"
            }
        }
        registerCreateFunctionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Create a new invalidation.
     */
    override suspend fun createInvalidation(input: CreateInvalidationRequest): CreateInvalidationResponse {
        val op = SdkHttpOperation.build<CreateInvalidationRequest, CreateInvalidationResponse> {
            serializer = CreateInvalidationOperationSerializer()
            deserializer = CreateInvalidationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateInvalidation"
            }
        }
        registerCreateInvalidationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a key group that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies.
     * To create a key group, you must specify at least one public key for the key group. After you
     * create a key group, you can reference it from one or more cache behaviors. When you
     * reference a key group in a cache behavior, CloudFront requires signed URLs or signed cookies
     * for all requests that match the cache behavior. The URLs or cookies must be signed with
     * a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the
     * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
     */
    override suspend fun createKeyGroup(input: CreateKeyGroupRequest): CreateKeyGroupResponse {
        val op = SdkHttpOperation.build<CreateKeyGroupRequest, CreateKeyGroupResponse> {
            serializer = CreateKeyGroupOperationSerializer()
            deserializer = CreateKeyGroupOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateKeyGroup"
            }
        }
        registerCreateKeyGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The
     * additional metrics incur an additional cost.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional">Viewing additional CloudFront distribution metrics in the
     * Amazon CloudFront Developer Guide.
     */
    override suspend fun createMonitoringSubscription(input: CreateMonitoringSubscriptionRequest): CreateMonitoringSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateMonitoringSubscriptionRequest, CreateMonitoringSubscriptionResponse> {
            serializer = CreateMonitoringSubscriptionOperationSerializer()
            deserializer = CreateMonitoringSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMonitoringSubscription"
            }
        }
        registerCreateMonitoringSubscriptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an origin request policy.
     * After you create an origin request policy, you can attach it to one or more cache behaviors.
     * When it’s attached to a cache behavior, the origin request policy determines the values
     * that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends
     * to the origin includes the following:
     * The request body and the URL path (without the domain name) from the viewer
     * request.
     * The headers that CloudFront automatically includes in every origin request, including
     * Host, User-Agent, and X-Amz-Cf-Id.
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or
     * the origin request policy. These can include items from the viewer request and,
     * in the case of headers, additional ones that are added by CloudFront.
     * CloudFront sends a request when it can’t find a valid object in its cache that matches the
     * request. If you want to send values to the origin and also include them in the cache
     * key, use CachePolicy.
     * For more information about origin request policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html">Controlling origin requests in the
     * Amazon CloudFront Developer Guide.
     */
    override suspend fun createOriginRequestPolicy(input: CreateOriginRequestPolicyRequest): CreateOriginRequestPolicyResponse {
        val op = SdkHttpOperation.build<CreateOriginRequestPolicyRequest, CreateOriginRequestPolicyResponse> {
            serializer = CreateOriginRequestPolicyOperationSerializer()
            deserializer = CreateOriginRequestPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateOriginRequestPolicy"
            }
        }
        registerCreateOriginRequestPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Uploads a public key to CloudFront that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
     */
    override suspend fun createPublicKey(input: CreatePublicKeyRequest): CreatePublicKeyResponse {
        val op = SdkHttpOperation.build<CreatePublicKeyRequest, CreatePublicKeyResponse> {
            serializer = CreatePublicKeyOperationSerializer()
            deserializer = CreatePublicKeyOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreatePublicKey"
            }
        }
        registerCreatePublicKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a real-time log configuration.
     * After you create a real-time log configuration, you can attach it to one or more cache
     * behaviors to send real-time log data to the specified Amazon Kinesis data stream.
     * For more information about real-time log configurations, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs in the Amazon CloudFront Developer Guide.
     */
    override suspend fun createRealtimeLogConfig(input: CreateRealtimeLogConfigRequest): CreateRealtimeLogConfigResponse {
        val op = SdkHttpOperation.build<CreateRealtimeLogConfigRequest, CreateRealtimeLogConfigResponse> {
            serializer = CreateRealtimeLogConfigOperationSerializer()
            deserializer = CreateRealtimeLogConfigOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateRealtimeLogConfig"
            }
        }
        registerCreateRealtimeLogConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * This API is deprecated.
     * Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020.
     * For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement on the Amazon CloudFront discussion forum.
     */
    override suspend fun createStreamingDistribution(input: CreateStreamingDistributionRequest): CreateStreamingDistributionResponse {
        val op = SdkHttpOperation.build<CreateStreamingDistributionRequest, CreateStreamingDistributionResponse> {
            serializer = CreateStreamingDistributionOperationSerializer()
            deserializer = CreateStreamingDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateStreamingDistribution"
            }
        }
        registerCreateStreamingDistributionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * This API is deprecated.
     * Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020.
     * For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement on the Amazon CloudFront discussion forum.
     */
    override suspend fun createStreamingDistributionWithTags(input: CreateStreamingDistributionWithTagsRequest): CreateStreamingDistributionWithTagsResponse {
        val op = SdkHttpOperation.build<CreateStreamingDistributionWithTagsRequest, CreateStreamingDistributionWithTagsResponse> {
            serializer = CreateStreamingDistributionWithTagsOperationSerializer()
            deserializer = CreateStreamingDistributionWithTagsOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateStreamingDistributionWithTags"
            }
        }
        registerCreateStreamingDistributionWithTagsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a cache policy.
     * You cannot delete a cache policy if it’s attached to a cache behavior. First update your
     * distributions to remove the cache policy from all cache behaviors, then delete the cache
     * policy.
     * To delete a cache policy, you must provide the policy’s identifier and version. To get these
     * values, you can use ListCachePolicies or
     * GetCachePolicy.
     */
    override suspend fun deleteCachePolicy(input: DeleteCachePolicyRequest): DeleteCachePolicyResponse {
        val op = SdkHttpOperation.build<DeleteCachePolicyRequest, DeleteCachePolicyResponse> {
            serializer = DeleteCachePolicyOperationSerializer()
            deserializer = DeleteCachePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteCachePolicy"
            }
        }
        registerDeleteCachePolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Delete an origin access identity.
     */
    override suspend fun deleteCloudFrontOriginAccessIdentity(input: DeleteCloudFrontOriginAccessIdentityRequest): DeleteCloudFrontOriginAccessIdentityResponse {
        val op = SdkHttpOperation.build<DeleteCloudFrontOriginAccessIdentityRequest, DeleteCloudFrontOriginAccessIdentityResponse> {
            serializer = DeleteCloudFrontOriginAccessIdentityOperationSerializer()
            deserializer = DeleteCloudFrontOriginAccessIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteCloudFrontOriginAccessIdentity"
            }
        }
        registerDeleteCloudFrontOriginAccessIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Delete a distribution.
     */
    override suspend fun deleteDistribution(input: DeleteDistributionRequest): DeleteDistributionResponse {
        val op = SdkHttpOperation.build<DeleteDistributionRequest, DeleteDistributionResponse> {
            serializer = DeleteDistributionOperationSerializer()
            deserializer = DeleteDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDistribution"
            }
        }
        registerDeleteDistributionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Remove a field-level encryption configuration.
     */
    override suspend fun deleteFieldLevelEncryptionConfig(input: DeleteFieldLevelEncryptionConfigRequest): DeleteFieldLevelEncryptionConfigResponse {
        val op = SdkHttpOperation.build<DeleteFieldLevelEncryptionConfigRequest, DeleteFieldLevelEncryptionConfigResponse> {
            serializer = DeleteFieldLevelEncryptionConfigOperationSerializer()
            deserializer = DeleteFieldLevelEncryptionConfigOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteFieldLevelEncryptionConfig"
            }
        }
        registerDeleteFieldLevelEncryptionConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Remove a field-level encryption profile.
     */
    override suspend fun deleteFieldLevelEncryptionProfile(input: DeleteFieldLevelEncryptionProfileRequest): DeleteFieldLevelEncryptionProfileResponse {
        val op = SdkHttpOperation.build<DeleteFieldLevelEncryptionProfileRequest, DeleteFieldLevelEncryptionProfileResponse> {
            serializer = DeleteFieldLevelEncryptionProfileOperationSerializer()
            deserializer = DeleteFieldLevelEncryptionProfileOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteFieldLevelEncryptionProfile"
            }
        }
        registerDeleteFieldLevelEncryptionProfileMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a CloudFront function.
     * You cannot delete a function if it’s associated with a cache behavior. First, update your
     * distributions to remove the function association from all cache behaviors, then delete
     * the function.
     * To delete a function, you must provide the function’s name and version
     * (ETag value). To get these values, you can use ListFunctions
     * and DescribeFunction.
     */
    override suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse {
        val op = SdkHttpOperation.build<DeleteFunctionRequest, DeleteFunctionResponse> {
            serializer = DeleteFunctionOperationSerializer()
            deserializer = DeleteFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteFunction"
            }
        }
        registerDeleteFunctionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a key group.
     * You cannot delete a key group that is referenced in a cache behavior. First update
     * your distributions to remove the key group from all cache behaviors, then delete the key
     * group.
     * To delete a key group, you must provide the key group’s identifier and version. To get
     * these values, use ListKeyGroups followed by GetKeyGroup or
     * GetKeyGroupConfig.
     */
    override suspend fun deleteKeyGroup(input: DeleteKeyGroupRequest): DeleteKeyGroupResponse {
        val op = SdkHttpOperation.build<DeleteKeyGroupRequest, DeleteKeyGroupResponse> {
            serializer = DeleteKeyGroupOperationSerializer()
            deserializer = DeleteKeyGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteKeyGroup"
            }
        }
        registerDeleteKeyGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     */
    override suspend fun deleteMonitoringSubscription(input: DeleteMonitoringSubscriptionRequest): DeleteMonitoringSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteMonitoringSubscriptionRequest, DeleteMonitoringSubscriptionResponse> {
            serializer = DeleteMonitoringSubscriptionOperationSerializer()
            deserializer = DeleteMonitoringSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMonitoringSubscription"
            }
        }
        registerDeleteMonitoringSubscriptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an origin request policy.
     * You cannot delete an origin request policy if it’s attached to any cache behaviors. First
     * update your distributions to remove the origin request policy from all cache behaviors,
     * then delete the origin request policy.
     * To delete an origin request policy, you must provide the policy’s identifier and version. To
     * get the identifier, you can use ListOriginRequestPolicies or
     * GetOriginRequestPolicy.
     */
    override suspend fun deleteOriginRequestPolicy(input: DeleteOriginRequestPolicyRequest): DeleteOriginRequestPolicyResponse {
        val op = SdkHttpOperation.build<DeleteOriginRequestPolicyRequest, DeleteOriginRequestPolicyResponse> {
            serializer = DeleteOriginRequestPolicyOperationSerializer()
            deserializer = DeleteOriginRequestPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteOriginRequestPolicy"
            }
        }
        registerDeleteOriginRequestPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Remove a public key you previously added to CloudFront.
     */
    override suspend fun deletePublicKey(input: DeletePublicKeyRequest): DeletePublicKeyResponse {
        val op = SdkHttpOperation.build<DeletePublicKeyRequest, DeletePublicKeyResponse> {
            serializer = DeletePublicKeyOperationSerializer()
            deserializer = DeletePublicKeyOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeletePublicKey"
            }
        }
        registerDeletePublicKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a real-time log configuration.
     * You cannot delete a real-time log configuration if it’s attached to a cache behavior.
     * First update your distributions to remove the real-time log configuration from all cache
     * behaviors, then delete the real-time log configuration.
     * To delete a real-time log configuration, you can provide the configuration’s name or its
     * Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront
     * uses the name to identify the real-time log configuration to delete.
     */
    override suspend fun deleteRealtimeLogConfig(input: DeleteRealtimeLogConfigRequest): DeleteRealtimeLogConfigResponse {
        val op = SdkHttpOperation.build<DeleteRealtimeLogConfigRequest, DeleteRealtimeLogConfigResponse> {
            serializer = DeleteRealtimeLogConfigOperationSerializer()
            deserializer = DeleteRealtimeLogConfigOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteRealtimeLogConfig"
            }
        }
        registerDeleteRealtimeLogConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API,
     * perform the following steps.
     * To delete an RTMP distribution using the CloudFront
     * API:
     * <ol>
     * Disable the RTMP distribution.
     * Submit a GET Streaming Distribution Config request to get the current
     * configuration and the Etag header for the distribution.
     * Update the XML document that was returned in the response to your GET
     * Streaming Distribution Config request to change the value of Enabled
     * to false.
     * Submit a PUT Streaming Distribution Config request to update the
     * configuration for your distribution. In the request body, include the XML document that
     * you updated in Step 3. Then set the value of the HTTP If-Match header to the
     * value of the ETag header that CloudFront returned when you submitted the GET
     * Streaming Distribution Config request in Step 2.
     * Review the response to the PUT Streaming Distribution Config request
     * to confirm that the distribution was successfully disabled.
     * Submit a GET Streaming Distribution Config request to confirm that
     * your changes have propagated. When propagation is complete, the value of
     * Status is Deployed.
     * Submit a DELETE Streaming Distribution request. Set the value of the
     * HTTP If-Match header to the value of the ETag header that CloudFront
     * returned when you submitted the GET Streaming Distribution Config request in
     * Step 2.
     * Review the response to your DELETE Streaming Distribution request to
     * confirm that the distribution was successfully deleted.
     * </ol>
     * For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution in the
     * Amazon CloudFront Developer Guide.
     */
    override suspend fun deleteStreamingDistribution(input: DeleteStreamingDistributionRequest): DeleteStreamingDistributionResponse {
        val op = SdkHttpOperation.build<DeleteStreamingDistributionRequest, DeleteStreamingDistributionResponse> {
            serializer = DeleteStreamingDistributionOperationSerializer()
            deserializer = DeleteStreamingDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteStreamingDistribution"
            }
        }
        registerDeleteStreamingDistributionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets configuration information and metadata about a CloudFront function, but not the function’s
     * code. To get a function’s code, use GetFunction.
     * To get configuration information and metadata about a function, you must provide the
     * function’s name and stage. To get these values, you can use
     * ListFunctions.
     */
    override suspend fun describeFunction(input: DescribeFunctionRequest): DescribeFunctionResponse {
        val op = SdkHttpOperation.build<DescribeFunctionRequest, DescribeFunctionResponse> {
            serializer = DescribeFunctionOperationSerializer()
            deserializer = DescribeFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFunction"
            }
        }
        registerDescribeFunctionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a cache policy, including the following metadata:
     * The policy’s identifier.
     * The date and time when the policy was last modified.
     * To get a cache policy, you must provide the policy’s identifier. If the cache policy is
     * attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * ListDistributions or GetDistribution. If the cache policy is
     * not attached to a cache behavior, you can get the identifier using
     * ListCachePolicies.
     */
    override suspend fun getCachePolicy(input: GetCachePolicyRequest): GetCachePolicyResponse {
        val op = SdkHttpOperation.build<GetCachePolicyRequest, GetCachePolicyResponse> {
            serializer = GetCachePolicyOperationSerializer()
            deserializer = GetCachePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCachePolicy"
            }
        }
        registerGetCachePolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a cache policy configuration.
     * To get a cache policy configuration, you must provide the policy’s identifier. If the cache
     * policy is attached to a distribution’s cache behavior, you can get the policy’s
     * identifier using ListDistributions or GetDistribution. If the
     * cache policy is not attached to a cache behavior, you can get the identifier using
     * ListCachePolicies.
     */
    override suspend fun getCachePolicyConfig(input: GetCachePolicyConfigRequest): GetCachePolicyConfigResponse {
        val op = SdkHttpOperation.build<GetCachePolicyConfigRequest, GetCachePolicyConfigResponse> {
            serializer = GetCachePolicyConfigOperationSerializer()
            deserializer = GetCachePolicyConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCachePolicyConfig"
            }
        }
        registerGetCachePolicyConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the information about an origin access identity.
     */
    override suspend fun getCloudFrontOriginAccessIdentity(input: GetCloudFrontOriginAccessIdentityRequest): GetCloudFrontOriginAccessIdentityResponse {
        val op = SdkHttpOperation.build<GetCloudFrontOriginAccessIdentityRequest, GetCloudFrontOriginAccessIdentityResponse> {
            serializer = GetCloudFrontOriginAccessIdentityOperationSerializer()
            deserializer = GetCloudFrontOriginAccessIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCloudFrontOriginAccessIdentity"
            }
        }
        registerGetCloudFrontOriginAccessIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the configuration information about an origin access identity.
     */
    override suspend fun getCloudFrontOriginAccessIdentityConfig(input: GetCloudFrontOriginAccessIdentityConfigRequest): GetCloudFrontOriginAccessIdentityConfigResponse {
        val op = SdkHttpOperation.build<GetCloudFrontOriginAccessIdentityConfigRequest, GetCloudFrontOriginAccessIdentityConfigResponse> {
            serializer = GetCloudFrontOriginAccessIdentityConfigOperationSerializer()
            deserializer = GetCloudFrontOriginAccessIdentityConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCloudFrontOriginAccessIdentityConfig"
            }
        }
        registerGetCloudFrontOriginAccessIdentityConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the information about a distribution.
     */
    override suspend fun getDistribution(input: GetDistributionRequest): GetDistributionResponse {
        val op = SdkHttpOperation.build<GetDistributionRequest, GetDistributionResponse> {
            serializer = GetDistributionOperationSerializer()
            deserializer = GetDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDistribution"
            }
        }
        registerGetDistributionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the configuration information about a distribution.
     */
    override suspend fun getDistributionConfig(input: GetDistributionConfigRequest): GetDistributionConfigResponse {
        val op = SdkHttpOperation.build<GetDistributionConfigRequest, GetDistributionConfigResponse> {
            serializer = GetDistributionConfigOperationSerializer()
            deserializer = GetDistributionConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDistributionConfig"
            }
        }
        registerGetDistributionConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the field-level encryption configuration information.
     */
    override suspend fun getFieldLevelEncryption(input: GetFieldLevelEncryptionRequest): GetFieldLevelEncryptionResponse {
        val op = SdkHttpOperation.build<GetFieldLevelEncryptionRequest, GetFieldLevelEncryptionResponse> {
            serializer = GetFieldLevelEncryptionOperationSerializer()
            deserializer = GetFieldLevelEncryptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFieldLevelEncryption"
            }
        }
        registerGetFieldLevelEncryptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the field-level encryption configuration information.
     */
    override suspend fun getFieldLevelEncryptionConfig(input: GetFieldLevelEncryptionConfigRequest): GetFieldLevelEncryptionConfigResponse {
        val op = SdkHttpOperation.build<GetFieldLevelEncryptionConfigRequest, GetFieldLevelEncryptionConfigResponse> {
            serializer = GetFieldLevelEncryptionConfigOperationSerializer()
            deserializer = GetFieldLevelEncryptionConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFieldLevelEncryptionConfig"
            }
        }
        registerGetFieldLevelEncryptionConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the field-level encryption profile information.
     */
    override suspend fun getFieldLevelEncryptionProfile(input: GetFieldLevelEncryptionProfileRequest): GetFieldLevelEncryptionProfileResponse {
        val op = SdkHttpOperation.build<GetFieldLevelEncryptionProfileRequest, GetFieldLevelEncryptionProfileResponse> {
            serializer = GetFieldLevelEncryptionProfileOperationSerializer()
            deserializer = GetFieldLevelEncryptionProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFieldLevelEncryptionProfile"
            }
        }
        registerGetFieldLevelEncryptionProfileMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the field-level encryption profile configuration information.
     */
    override suspend fun getFieldLevelEncryptionProfileConfig(input: GetFieldLevelEncryptionProfileConfigRequest): GetFieldLevelEncryptionProfileConfigResponse {
        val op = SdkHttpOperation.build<GetFieldLevelEncryptionProfileConfigRequest, GetFieldLevelEncryptionProfileConfigResponse> {
            serializer = GetFieldLevelEncryptionProfileConfigOperationSerializer()
            deserializer = GetFieldLevelEncryptionProfileConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFieldLevelEncryptionProfileConfig"
            }
        }
        registerGetFieldLevelEncryptionProfileConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the code of a CloudFront function. To get configuration information and metadata about
     * a function, use DescribeFunction.
     * To get a function’s code, you must provide the function’s name and stage. To get these
     * values, you can use ListFunctions.
     */
    override suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse {
        val op = SdkHttpOperation.build<GetFunctionRequest, GetFunctionResponse> {
            serializer = GetFunctionOperationSerializer()
            deserializer = GetFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFunction"
            }
        }
        registerGetFunctionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the information about an invalidation.
     */
    override suspend fun getInvalidation(input: GetInvalidationRequest): GetInvalidationResponse {
        val op = SdkHttpOperation.build<GetInvalidationRequest, GetInvalidationResponse> {
            serializer = GetInvalidationOperationSerializer()
            deserializer = GetInvalidationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInvalidation"
            }
        }
        registerGetInvalidationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a key group, including the date and time when the key group was last modified.
     * To get a key group, you must provide the key group’s identifier. If the key group is
     * referenced in a distribution’s cache behavior, you can get the key group’s identifier
     * using ListDistributions or GetDistribution. If the key group
     * is not referenced in a cache behavior, you can get the identifier using
     * ListKeyGroups.
     */
    override suspend fun getKeyGroup(input: GetKeyGroupRequest): GetKeyGroupResponse {
        val op = SdkHttpOperation.build<GetKeyGroupRequest, GetKeyGroupResponse> {
            serializer = GetKeyGroupOperationSerializer()
            deserializer = GetKeyGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetKeyGroup"
            }
        }
        registerGetKeyGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a key group configuration.
     * To get a key group configuration, you must provide the key group’s identifier. If the
     * key group is referenced in a distribution’s cache behavior, you can get the key group’s
     * identifier using ListDistributions or GetDistribution. If the
     * key group is not referenced in a cache behavior, you can get the identifier using
     * ListKeyGroups.
     */
    override suspend fun getKeyGroupConfig(input: GetKeyGroupConfigRequest): GetKeyGroupConfigResponse {
        val op = SdkHttpOperation.build<GetKeyGroupConfigRequest, GetKeyGroupConfigResponse> {
            serializer = GetKeyGroupConfigOperationSerializer()
            deserializer = GetKeyGroupConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetKeyGroupConfig"
            }
        }
        registerGetKeyGroupConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about whether additional CloudWatch metrics are enabled for the specified
     * CloudFront distribution.
     */
    override suspend fun getMonitoringSubscription(input: GetMonitoringSubscriptionRequest): GetMonitoringSubscriptionResponse {
        val op = SdkHttpOperation.build<GetMonitoringSubscriptionRequest, GetMonitoringSubscriptionResponse> {
            serializer = GetMonitoringSubscriptionOperationSerializer()
            deserializer = GetMonitoringSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMonitoringSubscription"
            }
        }
        registerGetMonitoringSubscriptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an origin request policy, including the following metadata:
     * The policy’s identifier.
     * The date and time when the policy was last modified.
     * To get an origin request policy, you must provide the policy’s identifier. If the origin
     * request policy is attached to a distribution’s cache behavior, you can get the policy’s
     * identifier using ListDistributions or GetDistribution. If the
     * origin request policy is not attached to a cache behavior, you can get the identifier
     * using ListOriginRequestPolicies.
     */
    override suspend fun getOriginRequestPolicy(input: GetOriginRequestPolicyRequest): GetOriginRequestPolicyResponse {
        val op = SdkHttpOperation.build<GetOriginRequestPolicyRequest, GetOriginRequestPolicyResponse> {
            serializer = GetOriginRequestPolicyOperationSerializer()
            deserializer = GetOriginRequestPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOriginRequestPolicy"
            }
        }
        registerGetOriginRequestPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an origin request policy configuration.
     * To get an origin request policy configuration, you must provide the policy’s identifier. If
     * the origin request policy is attached to a distribution’s cache behavior, you can get
     * the policy’s identifier using ListDistributions or
     * GetDistribution. If the origin request policy is not attached to a cache
     * behavior, you can get the identifier using
     * ListOriginRequestPolicies.
     */
    override suspend fun getOriginRequestPolicyConfig(input: GetOriginRequestPolicyConfigRequest): GetOriginRequestPolicyConfigResponse {
        val op = SdkHttpOperation.build<GetOriginRequestPolicyConfigRequest, GetOriginRequestPolicyConfigResponse> {
            serializer = GetOriginRequestPolicyConfigOperationSerializer()
            deserializer = GetOriginRequestPolicyConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOriginRequestPolicyConfig"
            }
        }
        registerGetOriginRequestPolicyConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a public key.
     */
    override suspend fun getPublicKey(input: GetPublicKeyRequest): GetPublicKeyResponse {
        val op = SdkHttpOperation.build<GetPublicKeyRequest, GetPublicKeyResponse> {
            serializer = GetPublicKeyOperationSerializer()
            deserializer = GetPublicKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPublicKey"
            }
        }
        registerGetPublicKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a public key configuration.
     */
    override suspend fun getPublicKeyConfig(input: GetPublicKeyConfigRequest): GetPublicKeyConfigResponse {
        val op = SdkHttpOperation.build<GetPublicKeyConfigRequest, GetPublicKeyConfigResponse> {
            serializer = GetPublicKeyConfigOperationSerializer()
            deserializer = GetPublicKeyConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPublicKeyConfig"
            }
        }
        registerGetPublicKeyConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a real-time log configuration.
     * To get a real-time log configuration, you can provide the configuration’s name or its Amazon
     * Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the
     * name to identify the real-time log configuration to get.
     */
    override suspend fun getRealtimeLogConfig(input: GetRealtimeLogConfigRequest): GetRealtimeLogConfigResponse {
        val op = SdkHttpOperation.build<GetRealtimeLogConfigRequest, GetRealtimeLogConfigResponse> {
            serializer = GetRealtimeLogConfigOperationSerializer()
            deserializer = GetRealtimeLogConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRealtimeLogConfig"
            }
        }
        registerGetRealtimeLogConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     */
    override suspend fun getStreamingDistribution(input: GetStreamingDistributionRequest): GetStreamingDistributionResponse {
        val op = SdkHttpOperation.build<GetStreamingDistributionRequest, GetStreamingDistributionResponse> {
            serializer = GetStreamingDistributionOperationSerializer()
            deserializer = GetStreamingDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStreamingDistribution"
            }
        }
        registerGetStreamingDistributionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the configuration information about a streaming distribution.
     */
    override suspend fun getStreamingDistributionConfig(input: GetStreamingDistributionConfigRequest): GetStreamingDistributionConfigResponse {
        val op = SdkHttpOperation.build<GetStreamingDistributionConfigRequest, GetStreamingDistributionConfigResponse> {
            serializer = GetStreamingDistributionConfigOperationSerializer()
            deserializer = GetStreamingDistributionConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStreamingDistributionConfig"
            }
        }
        registerGetStreamingDistributionConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of cache policies.
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or
     * only the custom policies created in your account.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listCachePolicies(input: ListCachePoliciesRequest): ListCachePoliciesResponse {
        val op = SdkHttpOperation.build<ListCachePoliciesRequest, ListCachePoliciesResponse> {
            serializer = ListCachePoliciesOperationSerializer()
            deserializer = ListCachePoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCachePolicies"
            }
        }
        registerListCachePoliciesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists origin access identities.
     */
    override suspend fun listCloudFrontOriginAccessIdentities(input: ListCloudFrontOriginAccessIdentitiesRequest): ListCloudFrontOriginAccessIdentitiesResponse {
        val op = SdkHttpOperation.build<ListCloudFrontOriginAccessIdentitiesRequest, ListCloudFrontOriginAccessIdentitiesResponse> {
            serializer = ListCloudFrontOriginAccessIdentitiesOperationSerializer()
            deserializer = ListCloudFrontOriginAccessIdentitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCloudFrontOriginAccessIdentities"
            }
        }
        registerListCloudFrontOriginAccessIdentitiesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or
     * overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services
     * accounts for each conflicting alias. In the returned list, the distribution and account
     * IDs are partially hidden, which allows you to identify the distributions and accounts
     * that you own, but helps to protect the information of ones that you don’t own.
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap
     * with the provided alias. For example, if you provide www.example.com as
     * input, the returned list can include www.example.com and the overlapping
     * wildcard alternate domain name (*.example.com), if they exist. If you
     * provide *.example.com as input, the returned list can include
     * *.example.com and any alternate domain names covered by that wildcard (for
     * example, www.example.com, test.example.com,
     * dev.example.com, and so on), if they exist.
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in
     * your account that has an attached SSL/TLS certificate that includes the provided alias.
     * For more information, including how to set up the distribution and certificate, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution
     * in the Amazon CloudFront Developer Guide.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listConflictingAliases(input: ListConflictingAliasesRequest): ListConflictingAliasesResponse {
        val op = SdkHttpOperation.build<ListConflictingAliasesRequest, ListConflictingAliasesResponse> {
            serializer = ListConflictingAliasesOperationSerializer()
            deserializer = ListConflictingAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConflictingAliases"
            }
        }
        registerListConflictingAliasesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List CloudFront distributions.
     */
    override suspend fun listDistributions(input: ListDistributionsRequest): ListDistributionsResponse {
        val op = SdkHttpOperation.build<ListDistributionsRequest, ListDistributionsResponse> {
            serializer = ListDistributionsOperationSerializer()
            deserializer = ListDistributionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDistributions"
            }
        }
        registerListDistributionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s
     * associated with the specified cache policy.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listDistributionsByCachePolicyId(input: ListDistributionsByCachePolicyIdRequest): ListDistributionsByCachePolicyIdResponse {
        val op = SdkHttpOperation.build<ListDistributionsByCachePolicyIdRequest, ListDistributionsByCachePolicyIdResponse> {
            serializer = ListDistributionsByCachePolicyIdOperationSerializer()
            deserializer = ListDistributionsByCachePolicyIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDistributionsByCachePolicyId"
            }
        }
        registerListDistributionsByCachePolicyIdMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that references
     * the specified key group.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listDistributionsByKeyGroup(input: ListDistributionsByKeyGroupRequest): ListDistributionsByKeyGroupResponse {
        val op = SdkHttpOperation.build<ListDistributionsByKeyGroupRequest, ListDistributionsByKeyGroupResponse> {
            serializer = ListDistributionsByKeyGroupOperationSerializer()
            deserializer = ListDistributionsByKeyGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDistributionsByKeyGroup"
            }
        }
        registerListDistributionsByKeyGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s
     * associated with the specified origin request policy.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listDistributionsByOriginRequestPolicyId(input: ListDistributionsByOriginRequestPolicyIdRequest): ListDistributionsByOriginRequestPolicyIdResponse {
        val op = SdkHttpOperation.build<ListDistributionsByOriginRequestPolicyIdRequest, ListDistributionsByOriginRequestPolicyIdResponse> {
            serializer = ListDistributionsByOriginRequestPolicyIdOperationSerializer()
            deserializer = ListDistributionsByOriginRequestPolicyIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDistributionsByOriginRequestPolicyId"
            }
        }
        registerListDistributionsByOriginRequestPolicyIdMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of distributions that have a cache behavior that’s associated with the specified
     * real-time log configuration.
     * You can specify the real-time log configuration by its name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to
     * identify the real-time log configuration to list distributions for.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listDistributionsByRealtimeLogConfig(input: ListDistributionsByRealtimeLogConfigRequest): ListDistributionsByRealtimeLogConfigResponse {
        val op = SdkHttpOperation.build<ListDistributionsByRealtimeLogConfigRequest, ListDistributionsByRealtimeLogConfigResponse> {
            serializer = ListDistributionsByRealtimeLogConfigOperationSerializer()
            deserializer = ListDistributionsByRealtimeLogConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDistributionsByRealtimeLogConfig"
            }
        }
        registerListDistributionsByRealtimeLogConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List the distributions that are associated with a specified WAF web ACL.
     */
    override suspend fun listDistributionsByWebAclId(input: ListDistributionsByWebAclIdRequest): ListDistributionsByWebAclIdResponse {
        val op = SdkHttpOperation.build<ListDistributionsByWebAclIdRequest, ListDistributionsByWebAclIdResponse> {
            serializer = ListDistributionsByWebACLIdOperationSerializer()
            deserializer = ListDistributionsByWebACLIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDistributionsByWebACLId"
            }
        }
        registerListDistributionsByWebAclIdMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     */
    override suspend fun listFieldLevelEncryptionConfigs(input: ListFieldLevelEncryptionConfigsRequest): ListFieldLevelEncryptionConfigsResponse {
        val op = SdkHttpOperation.build<ListFieldLevelEncryptionConfigsRequest, ListFieldLevelEncryptionConfigsResponse> {
            serializer = ListFieldLevelEncryptionConfigsOperationSerializer()
            deserializer = ListFieldLevelEncryptionConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFieldLevelEncryptionConfigs"
            }
        }
        registerListFieldLevelEncryptionConfigsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     */
    override suspend fun listFieldLevelEncryptionProfiles(input: ListFieldLevelEncryptionProfilesRequest): ListFieldLevelEncryptionProfilesResponse {
        val op = SdkHttpOperation.build<ListFieldLevelEncryptionProfilesRequest, ListFieldLevelEncryptionProfilesResponse> {
            serializer = ListFieldLevelEncryptionProfilesOperationSerializer()
            deserializer = ListFieldLevelEncryptionProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFieldLevelEncryptionProfiles"
            }
        }
        registerListFieldLevelEncryptionProfilesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of all CloudFront functions in your account.
     * You can optionally apply a filter to return only the functions that are in the
     * specified stage, either DEVELOPMENT or LIVE.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse {
        val op = SdkHttpOperation.build<ListFunctionsRequest, ListFunctionsResponse> {
            serializer = ListFunctionsOperationSerializer()
            deserializer = ListFunctionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFunctions"
            }
        }
        registerListFunctionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists invalidation batches.
     */
    override suspend fun listInvalidations(input: ListInvalidationsRequest): ListInvalidationsResponse {
        val op = SdkHttpOperation.build<ListInvalidationsRequest, ListInvalidationsResponse> {
            serializer = ListInvalidationsOperationSerializer()
            deserializer = ListInvalidationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInvalidations"
            }
        }
        registerListInvalidationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of key groups.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listKeyGroups(input: ListKeyGroupsRequest): ListKeyGroupsResponse {
        val op = SdkHttpOperation.build<ListKeyGroupsRequest, ListKeyGroupsResponse> {
            serializer = ListKeyGroupsOperationSerializer()
            deserializer = ListKeyGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListKeyGroups"
            }
        }
        registerListKeyGroupsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of origin request policies.
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or
     * only the custom policies created in your account.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listOriginRequestPolicies(input: ListOriginRequestPoliciesRequest): ListOriginRequestPoliciesResponse {
        val op = SdkHttpOperation.build<ListOriginRequestPoliciesRequest, ListOriginRequestPoliciesResponse> {
            serializer = ListOriginRequestPoliciesOperationSerializer()
            deserializer = ListOriginRequestPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOriginRequestPolicies"
            }
        }
        registerListOriginRequestPoliciesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List all public keys that have been added to CloudFront for this account.
     */
    override suspend fun listPublicKeys(input: ListPublicKeysRequest): ListPublicKeysResponse {
        val op = SdkHttpOperation.build<ListPublicKeysRequest, ListPublicKeysResponse> {
            serializer = ListPublicKeysOperationSerializer()
            deserializer = ListPublicKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPublicKeys"
            }
        }
        registerListPublicKeysMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of real-time log configurations.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    override suspend fun listRealtimeLogConfigs(input: ListRealtimeLogConfigsRequest): ListRealtimeLogConfigsResponse {
        val op = SdkHttpOperation.build<ListRealtimeLogConfigsRequest, ListRealtimeLogConfigsResponse> {
            serializer = ListRealtimeLogConfigsOperationSerializer()
            deserializer = ListRealtimeLogConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRealtimeLogConfigs"
            }
        }
        registerListRealtimeLogConfigsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List streaming distributions.
     */
    override suspend fun listStreamingDistributions(input: ListStreamingDistributionsRequest): ListStreamingDistributionsResponse {
        val op = SdkHttpOperation.build<ListStreamingDistributionsRequest, ListStreamingDistributionsResponse> {
            serializer = ListStreamingDistributionsOperationSerializer()
            deserializer = ListStreamingDistributionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStreamingDistributions"
            }
        }
        registerListStreamingDistributionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List tags for a CloudFront resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Publishes a CloudFront function by copying the function code from the DEVELOPMENT
     * stage to LIVE. This automatically updates all cache behaviors that are
     * using this function to use the newly published copy in the LIVE
     * stage.
     * When a function is published to the LIVE stage, you can attach the function to
     * a distribution’s cache behavior, using the function’s Amazon Resource Name (ARN).
     * To publish a function, you must provide the function’s name and version (ETag
     * value). To get these values, you can use ListFunctions and
     * DescribeFunction.
     */
    override suspend fun publishFunction(input: PublishFunctionRequest): PublishFunctionResponse {
        val op = SdkHttpOperation.build<PublishFunctionRequest, PublishFunctionResponse> {
            serializer = PublishFunctionOperationSerializer()
            deserializer = PublishFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PublishFunction"
            }
        }
        registerPublishFunctionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Add tags to a CloudFront resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Tests a CloudFront function.
     * To test a function, you provide an event object that represents an HTTP
     * request or response that your CloudFront distribution could receive in production. CloudFront runs
     * the function, passing it the event object that you provided, and returns the function’s
     * result (the modified event object) in the response. The response also contains function
     * logs and error messages, if any exist. For more information about testing functions, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions in the Amazon CloudFront Developer Guide.
     * To test a function, you provide the function’s name and version (ETag value)
     * along with the event object. To get the function’s name and version, you can use
     * ListFunctions and DescribeFunction.
     */
    override suspend fun testFunction(input: TestFunctionRequest): TestFunctionResponse {
        val op = SdkHttpOperation.build<TestFunctionRequest, TestFunctionResponse> {
            serializer = TestFunctionOperationSerializer()
            deserializer = TestFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestFunction"
            }
        }
        registerTestFunctionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Remove tags from a CloudFront resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a cache policy configuration.
     * When you update a cache policy configuration, all the fields are updated with the
     * values provided in the request. You cannot update some fields independent of others. To
     * update a cache policy configuration:
     * <ol>
     * Use GetCachePolicyConfig to get the current configuration.
     * Locally modify the fields in the cache policy configuration that you want to
     * update.
     * Call UpdateCachePolicy by providing the entire cache policy
     * configuration, including the fields that you modified and those that you
     * didn’t.
     * </ol>
     */
    override suspend fun updateCachePolicy(input: UpdateCachePolicyRequest): UpdateCachePolicyResponse {
        val op = SdkHttpOperation.build<UpdateCachePolicyRequest, UpdateCachePolicyResponse> {
            serializer = UpdateCachePolicyOperationSerializer()
            deserializer = UpdateCachePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCachePolicy"
            }
        }
        registerUpdateCachePolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Update an origin access identity.
     */
    override suspend fun updateCloudFrontOriginAccessIdentity(input: UpdateCloudFrontOriginAccessIdentityRequest): UpdateCloudFrontOriginAccessIdentityResponse {
        val op = SdkHttpOperation.build<UpdateCloudFrontOriginAccessIdentityRequest, UpdateCloudFrontOriginAccessIdentityResponse> {
            serializer = UpdateCloudFrontOriginAccessIdentityOperationSerializer()
            deserializer = UpdateCloudFrontOriginAccessIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCloudFrontOriginAccessIdentity"
            }
        }
        registerUpdateCloudFrontOriginAccessIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration for a web distribution.
     * When you update a distribution, there are more required fields than when you create a distribution.
     * When you update your distribution by using this API action, follow the steps here to get the current configuration
     * and then make your updates, to make sure that you include all of the required fields. To view a summary,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required
     * Fields for Create Distribution and Update Distribution in the Amazon CloudFront Developer Guide.
     * The update process includes getting the current distribution configuration, updating the XML document that is
     * returned to make your changes, and then submitting an UpdateDistribution request to make the updates.
     * For information about updating a distribution using the CloudFront console instead, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html">Creating a
     * Distribution in the Amazon CloudFront Developer Guide.
     * To update a web distribution using the CloudFront API
     * <ol>
     * Submit a
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">GetDistributionConfig
     * request to get the current configuration and an Etag header
     * for the distribution.
     * If you update the distribution again, you must get a new Etag header.
     * Update the XML document that was returned in the response to your GetDistributionConfig request to include
     * your changes.
     * When you edit the XML file, be aware of the following:
     * You must strip out the ETag parameter that is returned.
     * Additional fields are required when you update a distribution. There may be fields included in the
     * XML file for features that you haven't configured for your distribution. This is expected and required to
     * successfully update the distribution.
     * You can't change the value of CallerReference. If you try to change this value, CloudFront returns an
     * IllegalUpdate error.
     * The new configuration replaces the existing configuration; the values that you specify in an
     * UpdateDistribution request are not merged into your existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, CNAME), you must specify all of the
     * values that you want to appear in the updated distribution. In addition,
     * you must update the corresponding Quantity element.
     * Submit an UpdateDistribution request to update the configuration for your distribution:
     * In the request body, include the XML document that you updated in Step 2. The request body must include an
     * XML document with a DistributionConfig element.
     * Set the value of the HTTP If-Match header to the value of the ETag header that CloudFront returned
     * when you submitted the GetDistributionConfig request in Step 1.
     * Review the response to the UpdateDistribution request to confirm that the configuration was
     * successfully updated.
     * Optional: Submit a
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution
     * request to confirm that your changes have propagated.
     * When propagation is complete, the value of Status is Deployed.
     * </ol>
     */
    override suspend fun updateDistribution(input: UpdateDistributionRequest): UpdateDistributionResponse {
        val op = SdkHttpOperation.build<UpdateDistributionRequest, UpdateDistributionResponse> {
            serializer = UpdateDistributionOperationSerializer()
            deserializer = UpdateDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDistribution"
            }
        }
        registerUpdateDistributionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Update a field-level encryption configuration.
     */
    override suspend fun updateFieldLevelEncryptionConfig(input: UpdateFieldLevelEncryptionConfigRequest): UpdateFieldLevelEncryptionConfigResponse {
        val op = SdkHttpOperation.build<UpdateFieldLevelEncryptionConfigRequest, UpdateFieldLevelEncryptionConfigResponse> {
            serializer = UpdateFieldLevelEncryptionConfigOperationSerializer()
            deserializer = UpdateFieldLevelEncryptionConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFieldLevelEncryptionConfig"
            }
        }
        registerUpdateFieldLevelEncryptionConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Update a field-level encryption profile.
     */
    override suspend fun updateFieldLevelEncryptionProfile(input: UpdateFieldLevelEncryptionProfileRequest): UpdateFieldLevelEncryptionProfileResponse {
        val op = SdkHttpOperation.build<UpdateFieldLevelEncryptionProfileRequest, UpdateFieldLevelEncryptionProfileResponse> {
            serializer = UpdateFieldLevelEncryptionProfileOperationSerializer()
            deserializer = UpdateFieldLevelEncryptionProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFieldLevelEncryptionProfile"
            }
        }
        registerUpdateFieldLevelEncryptionProfileMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a CloudFront function.
     * You can update a function’s code or the comment that describes the function. You
     * cannot update a function’s name.
     * To update a function, you provide the function’s name and version (ETag value)
     * along with the updated function code. To get the name and version, you can use
     * ListFunctions and DescribeFunction.
     */
    override suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse {
        val op = SdkHttpOperation.build<UpdateFunctionRequest, UpdateFunctionResponse> {
            serializer = UpdateFunctionOperationSerializer()
            deserializer = UpdateFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFunction"
            }
        }
        registerUpdateFunctionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a key group.
     * When you update a key group, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update a key
     * group:
     * <ol>
     * Get the current key group with GetKeyGroup or
     * GetKeyGroupConfig.
     * Locally modify the fields in the key group that you want to update. For
     * example, add or remove public key IDs.
     * Call UpdateKeyGroup with the entire key group object, including
     * the fields that you modified and those that you didn’t.
     * </ol>
     */
    override suspend fun updateKeyGroup(input: UpdateKeyGroupRequest): UpdateKeyGroupResponse {
        val op = SdkHttpOperation.build<UpdateKeyGroupRequest, UpdateKeyGroupResponse> {
            serializer = UpdateKeyGroupOperationSerializer()
            deserializer = UpdateKeyGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateKeyGroup"
            }
        }
        registerUpdateKeyGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an origin request policy configuration.
     * When you update an origin request policy configuration, all the fields are updated
     * with the values provided in the request. You cannot update some fields independent of
     * others. To update an origin request policy configuration:
     * <ol>
     * Use GetOriginRequestPolicyConfig to get the current configuration.
     * Locally modify the fields in the origin request policy configuration that you
     * want to update.
     * Call UpdateOriginRequestPolicy by providing the entire origin
     * request policy configuration, including the fields that you modified and those
     * that you didn’t.
     * </ol>
     */
    override suspend fun updateOriginRequestPolicy(input: UpdateOriginRequestPolicyRequest): UpdateOriginRequestPolicyResponse {
        val op = SdkHttpOperation.build<UpdateOriginRequestPolicyRequest, UpdateOriginRequestPolicyResponse> {
            serializer = UpdateOriginRequestPolicyOperationSerializer()
            deserializer = UpdateOriginRequestPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateOriginRequestPolicy"
            }
        }
        registerUpdateOriginRequestPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Update public key information. Note that the only value you can change is the comment.
     */
    override suspend fun updatePublicKey(input: UpdatePublicKeyRequest): UpdatePublicKeyResponse {
        val op = SdkHttpOperation.build<UpdatePublicKeyRequest, UpdatePublicKeyResponse> {
            serializer = UpdatePublicKeyOperationSerializer()
            deserializer = UpdatePublicKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePublicKey"
            }
        }
        registerUpdatePublicKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a real-time log configuration.
     * When you update a real-time log configuration, all the parameters are updated with the
     * values provided in the request. You cannot update some parameters independent of others.
     * To update a real-time log configuration:
     * <ol>
     * Call GetRealtimeLogConfig to get the current real-time log
     * configuration.
     * Locally modify the parameters in the real-time log configuration that you want
     * to update.
     * Call this API (UpdateRealtimeLogConfig) by providing the entire
     * real-time log configuration, including the parameters that you modified and
     * those that you didn’t.
     * </ol>
     * You cannot update a real-time log configuration’s Name or
     * ARN.
     */
    override suspend fun updateRealtimeLogConfig(input: UpdateRealtimeLogConfigRequest): UpdateRealtimeLogConfigResponse {
        val op = SdkHttpOperation.build<UpdateRealtimeLogConfigRequest, UpdateRealtimeLogConfigResponse> {
            serializer = UpdateRealtimeLogConfigOperationSerializer()
            deserializer = UpdateRealtimeLogConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRealtimeLogConfig"
            }
        }
        registerUpdateRealtimeLogConfigMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Update a streaming distribution.
     */
    override suspend fun updateStreamingDistribution(input: UpdateStreamingDistributionRequest): UpdateStreamingDistributionResponse {
        val op = SdkHttpOperation.build<UpdateStreamingDistributionRequest, UpdateStreamingDistributionResponse> {
            serializer = UpdateStreamingDistributionOperationSerializer()
            deserializer = UpdateStreamingDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStreamingDistribution"
            }
        }
        registerUpdateStreamingDistributionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
