// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.cloudfront.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloudfront.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon CloudFront</fullname>
 * This is the Amazon CloudFront API Reference. This guide
 * is for developers who need detailed information about
 * CloudFront API actions, data types, and errors. For detailed information about CloudFront features, see the Amazon CloudFront Developer Guide.
 */
interface CloudFrontClient : SdkClient {

    override val serviceName: String
        get() = "CloudFront"
    /**
     * CloudFrontClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): CloudFrontClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultCloudFrontClient(config)
        }

        operator fun invoke(config: Config): CloudFrontClient = DefaultCloudFrontClient(config)

        /**
         * Construct a [CloudFrontClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): CloudFrontClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return CloudFrontClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront
     * distribution.
     * With this operation you can move an alias that’s already in use on a CloudFront distribution
     * to a different distribution in one step. This prevents the downtime that could occur if
     * you first remove the alias from one distribution and then separately add the alias to
     * another distribution.
     * To use this operation to associate an alias with a distribution, you provide the alias
     * and the ID of the target distribution for the alias. For more information, including how
     * to set up the target distribution, prerequisites that you must complete, and other
     * restrictions, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution
     * in the Amazon CloudFront Developer Guide.
     */
    suspend fun associateAlias(input: AssociateAliasRequest): AssociateAliasResponse

    /**
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront
     * distribution.
     * With this operation you can move an alias that’s already in use on a CloudFront distribution
     * to a different distribution in one step. This prevents the downtime that could occur if
     * you first remove the alias from one distribution and then separately add the alias to
     * another distribution.
     * To use this operation to associate an alias with a distribution, you provide the alias
     * and the ID of the target distribution for the alias. For more information, including how
     * to set up the target distribution, prerequisites that you must complete, and other
     * restrictions, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution
     * in the Amazon CloudFront Developer Guide.
     */
    suspend fun associateAlias(block: AssociateAliasRequest.DslBuilder.() -> Unit) = associateAlias(AssociateAliasRequest.builder().apply(block).build())

    /**
     * Creates a cache policy.
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it’s
     * attached to a cache behavior, the cache policy determines the following:
     * The values that CloudFront includes in the cache key. These values can
     * include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to
     * find an object in its cache that it can return to the viewer.
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay
     * in the CloudFront cache.
     * The headers, cookies, and query strings that are included in the cache key are automatically
     * included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
     * find an object in its cache that matches the request’s cache key. If you want to send
     * values to the origin but not include them in the cache key, use
     * OriginRequestPolicy.
     * For more information about cache policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">Controlling the cache key in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun createCachePolicy(input: CreateCachePolicyRequest): CreateCachePolicyResponse

    /**
     * Creates a cache policy.
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it’s
     * attached to a cache behavior, the cache policy determines the following:
     * The values that CloudFront includes in the cache key. These values can
     * include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to
     * find an object in its cache that it can return to the viewer.
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay
     * in the CloudFront cache.
     * The headers, cookies, and query strings that are included in the cache key are automatically
     * included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
     * find an object in its cache that matches the request’s cache key. If you want to send
     * values to the origin but not include them in the cache key, use
     * OriginRequestPolicy.
     * For more information about cache policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">Controlling the cache key in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun createCachePolicy(block: CreateCachePolicyRequest.DslBuilder.() -> Unit) = createCachePolicy(CreateCachePolicyRequest.builder().apply(block).build())

    /**
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can
     * use an origin access identity to require users to access your content using a CloudFront URL instead
     * of the Amazon S3 URL. For more information about how to use origin access identities, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun createCloudFrontOriginAccessIdentity(input: CreateCloudFrontOriginAccessIdentityRequest): CreateCloudFrontOriginAccessIdentityResponse

    /**
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can
     * use an origin access identity to require users to access your content using a CloudFront URL instead
     * of the Amazon S3 URL. For more information about how to use origin access identities, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun createCloudFrontOriginAccessIdentity(block: CreateCloudFrontOriginAccessIdentityRequest.DslBuilder.() -> Unit) = createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest.builder().apply(block).build())

    /**
     * Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you
     * want content to be delivered from, and the details about how to track and manage content delivery. Send a POST request to the
     * /CloudFront API version/distribution/distribution ID resource.
     * When you update a distribution, there are more required fields than when you create a distribution.
     * When you update your distribution by using
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution,
     * follow the steps included
     * in the documentation to get the current configuration
     * and then make your updates. This helps to make sure that you include all of the required fields. To view a summary,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required
     * Fields for Create Distribution and Update Distribution in the Amazon CloudFront Developer Guide.
     */
    suspend fun createDistribution(input: CreateDistributionRequest): CreateDistributionResponse

    /**
     * Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you
     * want content to be delivered from, and the details about how to track and manage content delivery. Send a POST request to the
     * /CloudFront API version/distribution/distribution ID resource.
     * When you update a distribution, there are more required fields than when you create a distribution.
     * When you update your distribution by using
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution,
     * follow the steps included
     * in the documentation to get the current configuration
     * and then make your updates. This helps to make sure that you include all of the required fields. To view a summary,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required
     * Fields for Create Distribution and Update Distribution in the Amazon CloudFront Developer Guide.
     */
    suspend fun createDistribution(block: CreateDistributionRequest.DslBuilder.() -> Unit) = createDistribution(CreateDistributionRequest.builder().apply(block).build())

    /**
     * Create a new distribution with tags.
     */
    suspend fun createDistributionWithTags(input: CreateDistributionWithTagsRequest): CreateDistributionWithTagsResponse

    /**
     * Create a new distribution with tags.
     */
    suspend fun createDistributionWithTags(block: CreateDistributionWithTagsRequest.DslBuilder.() -> Unit) = createDistributionWithTags(CreateDistributionWithTagsRequest.builder().apply(block).build())

    /**
     * Create a new field-level encryption configuration.
     */
    suspend fun createFieldLevelEncryptionConfig(input: CreateFieldLevelEncryptionConfigRequest): CreateFieldLevelEncryptionConfigResponse

    /**
     * Create a new field-level encryption configuration.
     */
    suspend fun createFieldLevelEncryptionConfig(block: CreateFieldLevelEncryptionConfigRequest.DslBuilder.() -> Unit) = createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest.builder().apply(block).build())

    /**
     * Create a field-level encryption profile.
     */
    suspend fun createFieldLevelEncryptionProfile(input: CreateFieldLevelEncryptionProfileRequest): CreateFieldLevelEncryptionProfileResponse

    /**
     * Create a field-level encryption profile.
     */
    suspend fun createFieldLevelEncryptionProfile(block: CreateFieldLevelEncryptionProfileRequest.DslBuilder.() -> Unit) = createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest.builder().apply(block).build())

    /**
     * Creates a CloudFront function.
     * To create a function, you provide the function code and some configuration information
     * about the function. The response contains an Amazon Resource Name (ARN) that uniquely
     * identifies the function.
     * When you create a function, it’s in the DEVELOPMENT stage. In this stage, you
     * can test the function with TestFunction, and update it with
     * UpdateFunction.
     * When you’re ready to use your function with a CloudFront distribution, use
     * PublishFunction to copy the function from the DEVELOPMENT
     * stage to LIVE. When it’s live, you can attach the function to a
     * distribution’s cache behavior, using the function’s ARN.
     */
    suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse

    /**
     * Creates a CloudFront function.
     * To create a function, you provide the function code and some configuration information
     * about the function. The response contains an Amazon Resource Name (ARN) that uniquely
     * identifies the function.
     * When you create a function, it’s in the DEVELOPMENT stage. In this stage, you
     * can test the function with TestFunction, and update it with
     * UpdateFunction.
     * When you’re ready to use your function with a CloudFront distribution, use
     * PublishFunction to copy the function from the DEVELOPMENT
     * stage to LIVE. When it’s live, you can attach the function to a
     * distribution’s cache behavior, using the function’s ARN.
     */
    suspend fun createFunction(block: CreateFunctionRequest.DslBuilder.() -> Unit) = createFunction(CreateFunctionRequest.builder().apply(block).build())

    /**
     * Create a new invalidation.
     */
    suspend fun createInvalidation(input: CreateInvalidationRequest): CreateInvalidationResponse

    /**
     * Create a new invalidation.
     */
    suspend fun createInvalidation(block: CreateInvalidationRequest.DslBuilder.() -> Unit) = createInvalidation(CreateInvalidationRequest.builder().apply(block).build())

    /**
     * Creates a key group that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies.
     * To create a key group, you must specify at least one public key for the key group. After you
     * create a key group, you can reference it from one or more cache behaviors. When you
     * reference a key group in a cache behavior, CloudFront requires signed URLs or signed cookies
     * for all requests that match the cache behavior. The URLs or cookies must be signed with
     * a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the
     * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
     */
    suspend fun createKeyGroup(input: CreateKeyGroupRequest): CreateKeyGroupResponse

    /**
     * Creates a key group that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies.
     * To create a key group, you must specify at least one public key for the key group. After you
     * create a key group, you can reference it from one or more cache behaviors. When you
     * reference a key group in a cache behavior, CloudFront requires signed URLs or signed cookies
     * for all requests that match the cache behavior. The URLs or cookies must be signed with
     * a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the
     * signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content in the Amazon CloudFront Developer Guide.
     */
    suspend fun createKeyGroup(block: CreateKeyGroupRequest.DslBuilder.() -> Unit) = createKeyGroup(CreateKeyGroupRequest.builder().apply(block).build())

    /**
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The
     * additional metrics incur an additional cost.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional">Viewing additional CloudFront distribution metrics in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun createMonitoringSubscription(input: CreateMonitoringSubscriptionRequest): CreateMonitoringSubscriptionResponse

    /**
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The
     * additional metrics incur an additional cost.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional">Viewing additional CloudFront distribution metrics in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun createMonitoringSubscription(block: CreateMonitoringSubscriptionRequest.DslBuilder.() -> Unit) = createMonitoringSubscription(CreateMonitoringSubscriptionRequest.builder().apply(block).build())

    /**
     * Creates an origin request policy.
     * After you create an origin request policy, you can attach it to one or more cache behaviors.
     * When it’s attached to a cache behavior, the origin request policy determines the values
     * that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends
     * to the origin includes the following:
     * The request body and the URL path (without the domain name) from the viewer
     * request.
     * The headers that CloudFront automatically includes in every origin request, including
     * Host, User-Agent, and X-Amz-Cf-Id.
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or
     * the origin request policy. These can include items from the viewer request and,
     * in the case of headers, additional ones that are added by CloudFront.
     * CloudFront sends a request when it can’t find a valid object in its cache that matches the
     * request. If you want to send values to the origin and also include them in the cache
     * key, use CachePolicy.
     * For more information about origin request policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html">Controlling origin requests in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun createOriginRequestPolicy(input: CreateOriginRequestPolicyRequest): CreateOriginRequestPolicyResponse

    /**
     * Creates an origin request policy.
     * After you create an origin request policy, you can attach it to one or more cache behaviors.
     * When it’s attached to a cache behavior, the origin request policy determines the values
     * that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends
     * to the origin includes the following:
     * The request body and the URL path (without the domain name) from the viewer
     * request.
     * The headers that CloudFront automatically includes in every origin request, including
     * Host, User-Agent, and X-Amz-Cf-Id.
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or
     * the origin request policy. These can include items from the viewer request and,
     * in the case of headers, additional ones that are added by CloudFront.
     * CloudFront sends a request when it can’t find a valid object in its cache that matches the
     * request. If you want to send values to the origin and also include them in the cache
     * key, use CachePolicy.
     * For more information about origin request policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html">Controlling origin requests in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun createOriginRequestPolicy(block: CreateOriginRequestPolicyRequest.DslBuilder.() -> Unit) = createOriginRequestPolicy(CreateOriginRequestPolicyRequest.builder().apply(block).build())

    /**
     * Uploads a public key to CloudFront that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
     */
    suspend fun createPublicKey(input: CreatePublicKeyRequest): CreatePublicKeyResponse

    /**
     * Uploads a public key to CloudFront that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption.
     */
    suspend fun createPublicKey(block: CreatePublicKeyRequest.DslBuilder.() -> Unit) = createPublicKey(CreatePublicKeyRequest.builder().apply(block).build())

    /**
     * Creates a real-time log configuration.
     * After you create a real-time log configuration, you can attach it to one or more cache
     * behaviors to send real-time log data to the specified Amazon Kinesis data stream.
     * For more information about real-time log configurations, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs in the Amazon CloudFront Developer Guide.
     */
    suspend fun createRealtimeLogConfig(input: CreateRealtimeLogConfigRequest): CreateRealtimeLogConfigResponse

    /**
     * Creates a real-time log configuration.
     * After you create a real-time log configuration, you can attach it to one or more cache
     * behaviors to send real-time log data to the specified Amazon Kinesis data stream.
     * For more information about real-time log configurations, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs in the Amazon CloudFront Developer Guide.
     */
    suspend fun createRealtimeLogConfig(block: CreateRealtimeLogConfigRequest.DslBuilder.() -> Unit) = createRealtimeLogConfig(CreateRealtimeLogConfigRequest.builder().apply(block).build())

    /**
     * This API is deprecated.
     * Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020.
     * For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement on the Amazon CloudFront discussion forum.
     */
    suspend fun createStreamingDistribution(input: CreateStreamingDistributionRequest): CreateStreamingDistributionResponse

    /**
     * This API is deprecated.
     * Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020.
     * For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement on the Amazon CloudFront discussion forum.
     */
    suspend fun createStreamingDistribution(block: CreateStreamingDistributionRequest.DslBuilder.() -> Unit) = createStreamingDistribution(CreateStreamingDistributionRequest.builder().apply(block).build())

    /**
     * This API is deprecated.
     * Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020.
     * For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement on the Amazon CloudFront discussion forum.
     */
    suspend fun createStreamingDistributionWithTags(input: CreateStreamingDistributionWithTagsRequest): CreateStreamingDistributionWithTagsResponse

    /**
     * This API is deprecated.
     * Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020.
     * For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement on the Amazon CloudFront discussion forum.
     */
    suspend fun createStreamingDistributionWithTags(block: CreateStreamingDistributionWithTagsRequest.DslBuilder.() -> Unit) = createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest.builder().apply(block).build())

    /**
     * Deletes a cache policy.
     * You cannot delete a cache policy if it’s attached to a cache behavior. First update your
     * distributions to remove the cache policy from all cache behaviors, then delete the cache
     * policy.
     * To delete a cache policy, you must provide the policy’s identifier and version. To get these
     * values, you can use ListCachePolicies or
     * GetCachePolicy.
     */
    suspend fun deleteCachePolicy(input: DeleteCachePolicyRequest): DeleteCachePolicyResponse

    /**
     * Deletes a cache policy.
     * You cannot delete a cache policy if it’s attached to a cache behavior. First update your
     * distributions to remove the cache policy from all cache behaviors, then delete the cache
     * policy.
     * To delete a cache policy, you must provide the policy’s identifier and version. To get these
     * values, you can use ListCachePolicies or
     * GetCachePolicy.
     */
    suspend fun deleteCachePolicy(block: DeleteCachePolicyRequest.DslBuilder.() -> Unit) = deleteCachePolicy(DeleteCachePolicyRequest.builder().apply(block).build())

    /**
     * Delete an origin access identity.
     */
    suspend fun deleteCloudFrontOriginAccessIdentity(input: DeleteCloudFrontOriginAccessIdentityRequest): DeleteCloudFrontOriginAccessIdentityResponse

    /**
     * Delete an origin access identity.
     */
    suspend fun deleteCloudFrontOriginAccessIdentity(block: DeleteCloudFrontOriginAccessIdentityRequest.DslBuilder.() -> Unit) = deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest.builder().apply(block).build())

    /**
     * Delete a distribution.
     */
    suspend fun deleteDistribution(input: DeleteDistributionRequest): DeleteDistributionResponse

    /**
     * Delete a distribution.
     */
    suspend fun deleteDistribution(block: DeleteDistributionRequest.DslBuilder.() -> Unit) = deleteDistribution(DeleteDistributionRequest.builder().apply(block).build())

    /**
     * Remove a field-level encryption configuration.
     */
    suspend fun deleteFieldLevelEncryptionConfig(input: DeleteFieldLevelEncryptionConfigRequest): DeleteFieldLevelEncryptionConfigResponse

    /**
     * Remove a field-level encryption configuration.
     */
    suspend fun deleteFieldLevelEncryptionConfig(block: DeleteFieldLevelEncryptionConfigRequest.DslBuilder.() -> Unit) = deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest.builder().apply(block).build())

    /**
     * Remove a field-level encryption profile.
     */
    suspend fun deleteFieldLevelEncryptionProfile(input: DeleteFieldLevelEncryptionProfileRequest): DeleteFieldLevelEncryptionProfileResponse

    /**
     * Remove a field-level encryption profile.
     */
    suspend fun deleteFieldLevelEncryptionProfile(block: DeleteFieldLevelEncryptionProfileRequest.DslBuilder.() -> Unit) = deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest.builder().apply(block).build())

    /**
     * Deletes a CloudFront function.
     * You cannot delete a function if it’s associated with a cache behavior. First, update your
     * distributions to remove the function association from all cache behaviors, then delete
     * the function.
     * To delete a function, you must provide the function’s name and version
     * (ETag value). To get these values, you can use ListFunctions
     * and DescribeFunction.
     */
    suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse

    /**
     * Deletes a CloudFront function.
     * You cannot delete a function if it’s associated with a cache behavior. First, update your
     * distributions to remove the function association from all cache behaviors, then delete
     * the function.
     * To delete a function, you must provide the function’s name and version
     * (ETag value). To get these values, you can use ListFunctions
     * and DescribeFunction.
     */
    suspend fun deleteFunction(block: DeleteFunctionRequest.DslBuilder.() -> Unit) = deleteFunction(DeleteFunctionRequest.builder().apply(block).build())

    /**
     * Deletes a key group.
     * You cannot delete a key group that is referenced in a cache behavior. First update
     * your distributions to remove the key group from all cache behaviors, then delete the key
     * group.
     * To delete a key group, you must provide the key group’s identifier and version. To get
     * these values, use ListKeyGroups followed by GetKeyGroup or
     * GetKeyGroupConfig.
     */
    suspend fun deleteKeyGroup(input: DeleteKeyGroupRequest): DeleteKeyGroupResponse

    /**
     * Deletes a key group.
     * You cannot delete a key group that is referenced in a cache behavior. First update
     * your distributions to remove the key group from all cache behaviors, then delete the key
     * group.
     * To delete a key group, you must provide the key group’s identifier and version. To get
     * these values, use ListKeyGroups followed by GetKeyGroup or
     * GetKeyGroupConfig.
     */
    suspend fun deleteKeyGroup(block: DeleteKeyGroupRequest.DslBuilder.() -> Unit) = deleteKeyGroup(DeleteKeyGroupRequest.builder().apply(block).build())

    /**
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     */
    suspend fun deleteMonitoringSubscription(input: DeleteMonitoringSubscriptionRequest): DeleteMonitoringSubscriptionResponse

    /**
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     */
    suspend fun deleteMonitoringSubscription(block: DeleteMonitoringSubscriptionRequest.DslBuilder.() -> Unit) = deleteMonitoringSubscription(DeleteMonitoringSubscriptionRequest.builder().apply(block).build())

    /**
     * Deletes an origin request policy.
     * You cannot delete an origin request policy if it’s attached to any cache behaviors. First
     * update your distributions to remove the origin request policy from all cache behaviors,
     * then delete the origin request policy.
     * To delete an origin request policy, you must provide the policy’s identifier and version. To
     * get the identifier, you can use ListOriginRequestPolicies or
     * GetOriginRequestPolicy.
     */
    suspend fun deleteOriginRequestPolicy(input: DeleteOriginRequestPolicyRequest): DeleteOriginRequestPolicyResponse

    /**
     * Deletes an origin request policy.
     * You cannot delete an origin request policy if it’s attached to any cache behaviors. First
     * update your distributions to remove the origin request policy from all cache behaviors,
     * then delete the origin request policy.
     * To delete an origin request policy, you must provide the policy’s identifier and version. To
     * get the identifier, you can use ListOriginRequestPolicies or
     * GetOriginRequestPolicy.
     */
    suspend fun deleteOriginRequestPolicy(block: DeleteOriginRequestPolicyRequest.DslBuilder.() -> Unit) = deleteOriginRequestPolicy(DeleteOriginRequestPolicyRequest.builder().apply(block).build())

    /**
     * Remove a public key you previously added to CloudFront.
     */
    suspend fun deletePublicKey(input: DeletePublicKeyRequest): DeletePublicKeyResponse

    /**
     * Remove a public key you previously added to CloudFront.
     */
    suspend fun deletePublicKey(block: DeletePublicKeyRequest.DslBuilder.() -> Unit) = deletePublicKey(DeletePublicKeyRequest.builder().apply(block).build())

    /**
     * Deletes a real-time log configuration.
     * You cannot delete a real-time log configuration if it’s attached to a cache behavior.
     * First update your distributions to remove the real-time log configuration from all cache
     * behaviors, then delete the real-time log configuration.
     * To delete a real-time log configuration, you can provide the configuration’s name or its
     * Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront
     * uses the name to identify the real-time log configuration to delete.
     */
    suspend fun deleteRealtimeLogConfig(input: DeleteRealtimeLogConfigRequest): DeleteRealtimeLogConfigResponse

    /**
     * Deletes a real-time log configuration.
     * You cannot delete a real-time log configuration if it’s attached to a cache behavior.
     * First update your distributions to remove the real-time log configuration from all cache
     * behaviors, then delete the real-time log configuration.
     * To delete a real-time log configuration, you can provide the configuration’s name or its
     * Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront
     * uses the name to identify the real-time log configuration to delete.
     */
    suspend fun deleteRealtimeLogConfig(block: DeleteRealtimeLogConfigRequest.DslBuilder.() -> Unit) = deleteRealtimeLogConfig(DeleteRealtimeLogConfigRequest.builder().apply(block).build())

    /**
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API,
     * perform the following steps.
     * To delete an RTMP distribution using the CloudFront
     * API:
     * <ol>
     * Disable the RTMP distribution.
     * Submit a GET Streaming Distribution Config request to get the current
     * configuration and the Etag header for the distribution.
     * Update the XML document that was returned in the response to your GET
     * Streaming Distribution Config request to change the value of Enabled
     * to false.
     * Submit a PUT Streaming Distribution Config request to update the
     * configuration for your distribution. In the request body, include the XML document that
     * you updated in Step 3. Then set the value of the HTTP If-Match header to the
     * value of the ETag header that CloudFront returned when you submitted the GET
     * Streaming Distribution Config request in Step 2.
     * Review the response to the PUT Streaming Distribution Config request
     * to confirm that the distribution was successfully disabled.
     * Submit a GET Streaming Distribution Config request to confirm that
     * your changes have propagated. When propagation is complete, the value of
     * Status is Deployed.
     * Submit a DELETE Streaming Distribution request. Set the value of the
     * HTTP If-Match header to the value of the ETag header that CloudFront
     * returned when you submitted the GET Streaming Distribution Config request in
     * Step 2.
     * Review the response to your DELETE Streaming Distribution request to
     * confirm that the distribution was successfully deleted.
     * </ol>
     * For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun deleteStreamingDistribution(input: DeleteStreamingDistributionRequest): DeleteStreamingDistributionResponse

    /**
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API,
     * perform the following steps.
     * To delete an RTMP distribution using the CloudFront
     * API:
     * <ol>
     * Disable the RTMP distribution.
     * Submit a GET Streaming Distribution Config request to get the current
     * configuration and the Etag header for the distribution.
     * Update the XML document that was returned in the response to your GET
     * Streaming Distribution Config request to change the value of Enabled
     * to false.
     * Submit a PUT Streaming Distribution Config request to update the
     * configuration for your distribution. In the request body, include the XML document that
     * you updated in Step 3. Then set the value of the HTTP If-Match header to the
     * value of the ETag header that CloudFront returned when you submitted the GET
     * Streaming Distribution Config request in Step 2.
     * Review the response to the PUT Streaming Distribution Config request
     * to confirm that the distribution was successfully disabled.
     * Submit a GET Streaming Distribution Config request to confirm that
     * your changes have propagated. When propagation is complete, the value of
     * Status is Deployed.
     * Submit a DELETE Streaming Distribution request. Set the value of the
     * HTTP If-Match header to the value of the ETag header that CloudFront
     * returned when you submitted the GET Streaming Distribution Config request in
     * Step 2.
     * Review the response to your DELETE Streaming Distribution request to
     * confirm that the distribution was successfully deleted.
     * </ol>
     * For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution in the
     * Amazon CloudFront Developer Guide.
     */
    suspend fun deleteStreamingDistribution(block: DeleteStreamingDistributionRequest.DslBuilder.() -> Unit) = deleteStreamingDistribution(DeleteStreamingDistributionRequest.builder().apply(block).build())

    /**
     * Gets configuration information and metadata about a CloudFront function, but not the function’s
     * code. To get a function’s code, use GetFunction.
     * To get configuration information and metadata about a function, you must provide the
     * function’s name and stage. To get these values, you can use
     * ListFunctions.
     */
    suspend fun describeFunction(input: DescribeFunctionRequest): DescribeFunctionResponse

    /**
     * Gets configuration information and metadata about a CloudFront function, but not the function’s
     * code. To get a function’s code, use GetFunction.
     * To get configuration information and metadata about a function, you must provide the
     * function’s name and stage. To get these values, you can use
     * ListFunctions.
     */
    suspend fun describeFunction(block: DescribeFunctionRequest.DslBuilder.() -> Unit) = describeFunction(DescribeFunctionRequest.builder().apply(block).build())

    /**
     * Gets a cache policy, including the following metadata:
     * The policy’s identifier.
     * The date and time when the policy was last modified.
     * To get a cache policy, you must provide the policy’s identifier. If the cache policy is
     * attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * ListDistributions or GetDistribution. If the cache policy is
     * not attached to a cache behavior, you can get the identifier using
     * ListCachePolicies.
     */
    suspend fun getCachePolicy(input: GetCachePolicyRequest): GetCachePolicyResponse

    /**
     * Gets a cache policy, including the following metadata:
     * The policy’s identifier.
     * The date and time when the policy was last modified.
     * To get a cache policy, you must provide the policy’s identifier. If the cache policy is
     * attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * ListDistributions or GetDistribution. If the cache policy is
     * not attached to a cache behavior, you can get the identifier using
     * ListCachePolicies.
     */
    suspend fun getCachePolicy(block: GetCachePolicyRequest.DslBuilder.() -> Unit) = getCachePolicy(GetCachePolicyRequest.builder().apply(block).build())

    /**
     * Gets a cache policy configuration.
     * To get a cache policy configuration, you must provide the policy’s identifier. If the cache
     * policy is attached to a distribution’s cache behavior, you can get the policy’s
     * identifier using ListDistributions or GetDistribution. If the
     * cache policy is not attached to a cache behavior, you can get the identifier using
     * ListCachePolicies.
     */
    suspend fun getCachePolicyConfig(input: GetCachePolicyConfigRequest): GetCachePolicyConfigResponse

    /**
     * Gets a cache policy configuration.
     * To get a cache policy configuration, you must provide the policy’s identifier. If the cache
     * policy is attached to a distribution’s cache behavior, you can get the policy’s
     * identifier using ListDistributions or GetDistribution. If the
     * cache policy is not attached to a cache behavior, you can get the identifier using
     * ListCachePolicies.
     */
    suspend fun getCachePolicyConfig(block: GetCachePolicyConfigRequest.DslBuilder.() -> Unit) = getCachePolicyConfig(GetCachePolicyConfigRequest.builder().apply(block).build())

    /**
     * Get the information about an origin access identity.
     */
    suspend fun getCloudFrontOriginAccessIdentity(input: GetCloudFrontOriginAccessIdentityRequest): GetCloudFrontOriginAccessIdentityResponse

    /**
     * Get the information about an origin access identity.
     */
    suspend fun getCloudFrontOriginAccessIdentity(block: GetCloudFrontOriginAccessIdentityRequest.DslBuilder.() -> Unit) = getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest.builder().apply(block).build())

    /**
     * Get the configuration information about an origin access identity.
     */
    suspend fun getCloudFrontOriginAccessIdentityConfig(input: GetCloudFrontOriginAccessIdentityConfigRequest): GetCloudFrontOriginAccessIdentityConfigResponse

    /**
     * Get the configuration information about an origin access identity.
     */
    suspend fun getCloudFrontOriginAccessIdentityConfig(block: GetCloudFrontOriginAccessIdentityConfigRequest.DslBuilder.() -> Unit) = getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest.builder().apply(block).build())

    /**
     * Get the information about a distribution.
     */
    suspend fun getDistribution(input: GetDistributionRequest): GetDistributionResponse

    /**
     * Get the information about a distribution.
     */
    suspend fun getDistribution(block: GetDistributionRequest.DslBuilder.() -> Unit) = getDistribution(GetDistributionRequest.builder().apply(block).build())

    /**
     * Get the configuration information about a distribution.
     */
    suspend fun getDistributionConfig(input: GetDistributionConfigRequest): GetDistributionConfigResponse

    /**
     * Get the configuration information about a distribution.
     */
    suspend fun getDistributionConfig(block: GetDistributionConfigRequest.DslBuilder.() -> Unit) = getDistributionConfig(GetDistributionConfigRequest.builder().apply(block).build())

    /**
     * Get the field-level encryption configuration information.
     */
    suspend fun getFieldLevelEncryption(input: GetFieldLevelEncryptionRequest): GetFieldLevelEncryptionResponse

    /**
     * Get the field-level encryption configuration information.
     */
    suspend fun getFieldLevelEncryption(block: GetFieldLevelEncryptionRequest.DslBuilder.() -> Unit) = getFieldLevelEncryption(GetFieldLevelEncryptionRequest.builder().apply(block).build())

    /**
     * Get the field-level encryption configuration information.
     */
    suspend fun getFieldLevelEncryptionConfig(input: GetFieldLevelEncryptionConfigRequest): GetFieldLevelEncryptionConfigResponse

    /**
     * Get the field-level encryption configuration information.
     */
    suspend fun getFieldLevelEncryptionConfig(block: GetFieldLevelEncryptionConfigRequest.DslBuilder.() -> Unit) = getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest.builder().apply(block).build())

    /**
     * Get the field-level encryption profile information.
     */
    suspend fun getFieldLevelEncryptionProfile(input: GetFieldLevelEncryptionProfileRequest): GetFieldLevelEncryptionProfileResponse

    /**
     * Get the field-level encryption profile information.
     */
    suspend fun getFieldLevelEncryptionProfile(block: GetFieldLevelEncryptionProfileRequest.DslBuilder.() -> Unit) = getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest.builder().apply(block).build())

    /**
     * Get the field-level encryption profile configuration information.
     */
    suspend fun getFieldLevelEncryptionProfileConfig(input: GetFieldLevelEncryptionProfileConfigRequest): GetFieldLevelEncryptionProfileConfigResponse

    /**
     * Get the field-level encryption profile configuration information.
     */
    suspend fun getFieldLevelEncryptionProfileConfig(block: GetFieldLevelEncryptionProfileConfigRequest.DslBuilder.() -> Unit) = getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest.builder().apply(block).build())

    /**
     * Gets the code of a CloudFront function. To get configuration information and metadata about
     * a function, use DescribeFunction.
     * To get a function’s code, you must provide the function’s name and stage. To get these
     * values, you can use ListFunctions.
     */
    suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse

    /**
     * Gets the code of a CloudFront function. To get configuration information and metadata about
     * a function, use DescribeFunction.
     * To get a function’s code, you must provide the function’s name and stage. To get these
     * values, you can use ListFunctions.
     */
    suspend fun getFunction(block: GetFunctionRequest.DslBuilder.() -> Unit) = getFunction(GetFunctionRequest.builder().apply(block).build())

    /**
     * Get the information about an invalidation.
     */
    suspend fun getInvalidation(input: GetInvalidationRequest): GetInvalidationResponse

    /**
     * Get the information about an invalidation.
     */
    suspend fun getInvalidation(block: GetInvalidationRequest.DslBuilder.() -> Unit) = getInvalidation(GetInvalidationRequest.builder().apply(block).build())

    /**
     * Gets a key group, including the date and time when the key group was last modified.
     * To get a key group, you must provide the key group’s identifier. If the key group is
     * referenced in a distribution’s cache behavior, you can get the key group’s identifier
     * using ListDistributions or GetDistribution. If the key group
     * is not referenced in a cache behavior, you can get the identifier using
     * ListKeyGroups.
     */
    suspend fun getKeyGroup(input: GetKeyGroupRequest): GetKeyGroupResponse

    /**
     * Gets a key group, including the date and time when the key group was last modified.
     * To get a key group, you must provide the key group’s identifier. If the key group is
     * referenced in a distribution’s cache behavior, you can get the key group’s identifier
     * using ListDistributions or GetDistribution. If the key group
     * is not referenced in a cache behavior, you can get the identifier using
     * ListKeyGroups.
     */
    suspend fun getKeyGroup(block: GetKeyGroupRequest.DslBuilder.() -> Unit) = getKeyGroup(GetKeyGroupRequest.builder().apply(block).build())

    /**
     * Gets a key group configuration.
     * To get a key group configuration, you must provide the key group’s identifier. If the
     * key group is referenced in a distribution’s cache behavior, you can get the key group’s
     * identifier using ListDistributions or GetDistribution. If the
     * key group is not referenced in a cache behavior, you can get the identifier using
     * ListKeyGroups.
     */
    suspend fun getKeyGroupConfig(input: GetKeyGroupConfigRequest): GetKeyGroupConfigResponse

    /**
     * Gets a key group configuration.
     * To get a key group configuration, you must provide the key group’s identifier. If the
     * key group is referenced in a distribution’s cache behavior, you can get the key group’s
     * identifier using ListDistributions or GetDistribution. If the
     * key group is not referenced in a cache behavior, you can get the identifier using
     * ListKeyGroups.
     */
    suspend fun getKeyGroupConfig(block: GetKeyGroupConfigRequest.DslBuilder.() -> Unit) = getKeyGroupConfig(GetKeyGroupConfigRequest.builder().apply(block).build())

    /**
     * Gets information about whether additional CloudWatch metrics are enabled for the specified
     * CloudFront distribution.
     */
    suspend fun getMonitoringSubscription(input: GetMonitoringSubscriptionRequest): GetMonitoringSubscriptionResponse

    /**
     * Gets information about whether additional CloudWatch metrics are enabled for the specified
     * CloudFront distribution.
     */
    suspend fun getMonitoringSubscription(block: GetMonitoringSubscriptionRequest.DslBuilder.() -> Unit) = getMonitoringSubscription(GetMonitoringSubscriptionRequest.builder().apply(block).build())

    /**
     * Gets an origin request policy, including the following metadata:
     * The policy’s identifier.
     * The date and time when the policy was last modified.
     * To get an origin request policy, you must provide the policy’s identifier. If the origin
     * request policy is attached to a distribution’s cache behavior, you can get the policy’s
     * identifier using ListDistributions or GetDistribution. If the
     * origin request policy is not attached to a cache behavior, you can get the identifier
     * using ListOriginRequestPolicies.
     */
    suspend fun getOriginRequestPolicy(input: GetOriginRequestPolicyRequest): GetOriginRequestPolicyResponse

    /**
     * Gets an origin request policy, including the following metadata:
     * The policy’s identifier.
     * The date and time when the policy was last modified.
     * To get an origin request policy, you must provide the policy’s identifier. If the origin
     * request policy is attached to a distribution’s cache behavior, you can get the policy’s
     * identifier using ListDistributions or GetDistribution. If the
     * origin request policy is not attached to a cache behavior, you can get the identifier
     * using ListOriginRequestPolicies.
     */
    suspend fun getOriginRequestPolicy(block: GetOriginRequestPolicyRequest.DslBuilder.() -> Unit) = getOriginRequestPolicy(GetOriginRequestPolicyRequest.builder().apply(block).build())

    /**
     * Gets an origin request policy configuration.
     * To get an origin request policy configuration, you must provide the policy’s identifier. If
     * the origin request policy is attached to a distribution’s cache behavior, you can get
     * the policy’s identifier using ListDistributions or
     * GetDistribution. If the origin request policy is not attached to a cache
     * behavior, you can get the identifier using
     * ListOriginRequestPolicies.
     */
    suspend fun getOriginRequestPolicyConfig(input: GetOriginRequestPolicyConfigRequest): GetOriginRequestPolicyConfigResponse

    /**
     * Gets an origin request policy configuration.
     * To get an origin request policy configuration, you must provide the policy’s identifier. If
     * the origin request policy is attached to a distribution’s cache behavior, you can get
     * the policy’s identifier using ListDistributions or
     * GetDistribution. If the origin request policy is not attached to a cache
     * behavior, you can get the identifier using
     * ListOriginRequestPolicies.
     */
    suspend fun getOriginRequestPolicyConfig(block: GetOriginRequestPolicyConfigRequest.DslBuilder.() -> Unit) = getOriginRequestPolicyConfig(GetOriginRequestPolicyConfigRequest.builder().apply(block).build())

    /**
     * Gets a public key.
     */
    suspend fun getPublicKey(input: GetPublicKeyRequest): GetPublicKeyResponse

    /**
     * Gets a public key.
     */
    suspend fun getPublicKey(block: GetPublicKeyRequest.DslBuilder.() -> Unit) = getPublicKey(GetPublicKeyRequest.builder().apply(block).build())

    /**
     * Gets a public key configuration.
     */
    suspend fun getPublicKeyConfig(input: GetPublicKeyConfigRequest): GetPublicKeyConfigResponse

    /**
     * Gets a public key configuration.
     */
    suspend fun getPublicKeyConfig(block: GetPublicKeyConfigRequest.DslBuilder.() -> Unit) = getPublicKeyConfig(GetPublicKeyConfigRequest.builder().apply(block).build())

    /**
     * Gets a real-time log configuration.
     * To get a real-time log configuration, you can provide the configuration’s name or its Amazon
     * Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the
     * name to identify the real-time log configuration to get.
     */
    suspend fun getRealtimeLogConfig(input: GetRealtimeLogConfigRequest): GetRealtimeLogConfigResponse

    /**
     * Gets a real-time log configuration.
     * To get a real-time log configuration, you can provide the configuration’s name or its Amazon
     * Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the
     * name to identify the real-time log configuration to get.
     */
    suspend fun getRealtimeLogConfig(block: GetRealtimeLogConfigRequest.DslBuilder.() -> Unit) = getRealtimeLogConfig(GetRealtimeLogConfigRequest.builder().apply(block).build())

    /**
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     */
    suspend fun getStreamingDistribution(input: GetStreamingDistributionRequest): GetStreamingDistributionResponse

    /**
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     */
    suspend fun getStreamingDistribution(block: GetStreamingDistributionRequest.DslBuilder.() -> Unit) = getStreamingDistribution(GetStreamingDistributionRequest.builder().apply(block).build())

    /**
     * Get the configuration information about a streaming distribution.
     */
    suspend fun getStreamingDistributionConfig(input: GetStreamingDistributionConfigRequest): GetStreamingDistributionConfigResponse

    /**
     * Get the configuration information about a streaming distribution.
     */
    suspend fun getStreamingDistributionConfig(block: GetStreamingDistributionConfigRequest.DslBuilder.() -> Unit) = getStreamingDistributionConfig(GetStreamingDistributionConfigRequest.builder().apply(block).build())

    /**
     * Gets a list of cache policies.
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or
     * only the custom policies created in your account.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listCachePolicies(input: ListCachePoliciesRequest): ListCachePoliciesResponse

    /**
     * Gets a list of cache policies.
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or
     * only the custom policies created in your account.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listCachePolicies(block: ListCachePoliciesRequest.DslBuilder.() -> Unit) = listCachePolicies(ListCachePoliciesRequest.builder().apply(block).build())

    /**
     * Lists origin access identities.
     */
    suspend fun listCloudFrontOriginAccessIdentities(input: ListCloudFrontOriginAccessIdentitiesRequest): ListCloudFrontOriginAccessIdentitiesResponse

    /**
     * Lists origin access identities.
     */
    suspend fun listCloudFrontOriginAccessIdentities(block: ListCloudFrontOriginAccessIdentitiesRequest.DslBuilder.() -> Unit) = listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.builder().apply(block).build())

    /**
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or
     * overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services
     * accounts for each conflicting alias. In the returned list, the distribution and account
     * IDs are partially hidden, which allows you to identify the distributions and accounts
     * that you own, but helps to protect the information of ones that you don’t own.
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap
     * with the provided alias. For example, if you provide www.example.com as
     * input, the returned list can include www.example.com and the overlapping
     * wildcard alternate domain name (*.example.com), if they exist. If you
     * provide *.example.com as input, the returned list can include
     * *.example.com and any alternate domain names covered by that wildcard (for
     * example, www.example.com, test.example.com,
     * dev.example.com, and so on), if they exist.
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in
     * your account that has an attached SSL/TLS certificate that includes the provided alias.
     * For more information, including how to set up the distribution and certificate, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution
     * in the Amazon CloudFront Developer Guide.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listConflictingAliases(input: ListConflictingAliasesRequest): ListConflictingAliasesResponse

    /**
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or
     * overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services
     * accounts for each conflicting alias. In the returned list, the distribution and account
     * IDs are partially hidden, which allows you to identify the distributions and accounts
     * that you own, but helps to protect the information of ones that you don’t own.
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap
     * with the provided alias. For example, if you provide www.example.com as
     * input, the returned list can include www.example.com and the overlapping
     * wildcard alternate domain name (*.example.com), if they exist. If you
     * provide *.example.com as input, the returned list can include
     * *.example.com and any alternate domain names covered by that wildcard (for
     * example, www.example.com, test.example.com,
     * dev.example.com, and so on), if they exist.
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in
     * your account that has an attached SSL/TLS certificate that includes the provided alias.
     * For more information, including how to set up the distribution and certificate, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution
     * in the Amazon CloudFront Developer Guide.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listConflictingAliases(block: ListConflictingAliasesRequest.DslBuilder.() -> Unit) = listConflictingAliases(ListConflictingAliasesRequest.builder().apply(block).build())

    /**
     * List CloudFront distributions.
     */
    suspend fun listDistributions(input: ListDistributionsRequest): ListDistributionsResponse

    /**
     * List CloudFront distributions.
     */
    suspend fun listDistributions(block: ListDistributionsRequest.DslBuilder.() -> Unit) = listDistributions(ListDistributionsRequest.builder().apply(block).build())

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s
     * associated with the specified cache policy.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listDistributionsByCachePolicyId(input: ListDistributionsByCachePolicyIdRequest): ListDistributionsByCachePolicyIdResponse

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s
     * associated with the specified cache policy.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listDistributionsByCachePolicyId(block: ListDistributionsByCachePolicyIdRequest.DslBuilder.() -> Unit) = listDistributionsByCachePolicyId(ListDistributionsByCachePolicyIdRequest.builder().apply(block).build())

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that references
     * the specified key group.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listDistributionsByKeyGroup(input: ListDistributionsByKeyGroupRequest): ListDistributionsByKeyGroupResponse

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that references
     * the specified key group.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listDistributionsByKeyGroup(block: ListDistributionsByKeyGroupRequest.DslBuilder.() -> Unit) = listDistributionsByKeyGroup(ListDistributionsByKeyGroupRequest.builder().apply(block).build())

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s
     * associated with the specified origin request policy.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listDistributionsByOriginRequestPolicyId(input: ListDistributionsByOriginRequestPolicyIdRequest): ListDistributionsByOriginRequestPolicyIdResponse

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s
     * associated with the specified origin request policy.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listDistributionsByOriginRequestPolicyId(block: ListDistributionsByOriginRequestPolicyIdRequest.DslBuilder.() -> Unit) = listDistributionsByOriginRequestPolicyId(ListDistributionsByOriginRequestPolicyIdRequest.builder().apply(block).build())

    /**
     * Gets a list of distributions that have a cache behavior that’s associated with the specified
     * real-time log configuration.
     * You can specify the real-time log configuration by its name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to
     * identify the real-time log configuration to list distributions for.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listDistributionsByRealtimeLogConfig(input: ListDistributionsByRealtimeLogConfigRequest): ListDistributionsByRealtimeLogConfigResponse

    /**
     * Gets a list of distributions that have a cache behavior that’s associated with the specified
     * real-time log configuration.
     * You can specify the real-time log configuration by its name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to
     * identify the real-time log configuration to list distributions for.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listDistributionsByRealtimeLogConfig(block: ListDistributionsByRealtimeLogConfigRequest.DslBuilder.() -> Unit) = listDistributionsByRealtimeLogConfig(ListDistributionsByRealtimeLogConfigRequest.builder().apply(block).build())

    /**
     * List the distributions that are associated with a specified WAF web ACL.
     */
    suspend fun listDistributionsByWebAclId(input: ListDistributionsByWebAclIdRequest): ListDistributionsByWebAclIdResponse

    /**
     * List the distributions that are associated with a specified WAF web ACL.
     */
    suspend fun listDistributionsByWebAclId(block: ListDistributionsByWebAclIdRequest.DslBuilder.() -> Unit) = listDistributionsByWebAclId(ListDistributionsByWebAclIdRequest.builder().apply(block).build())

    /**
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     */
    suspend fun listFieldLevelEncryptionConfigs(input: ListFieldLevelEncryptionConfigsRequest): ListFieldLevelEncryptionConfigsResponse

    /**
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     */
    suspend fun listFieldLevelEncryptionConfigs(block: ListFieldLevelEncryptionConfigsRequest.DslBuilder.() -> Unit) = listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest.builder().apply(block).build())

    /**
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     */
    suspend fun listFieldLevelEncryptionProfiles(input: ListFieldLevelEncryptionProfilesRequest): ListFieldLevelEncryptionProfilesResponse

    /**
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     */
    suspend fun listFieldLevelEncryptionProfiles(block: ListFieldLevelEncryptionProfilesRequest.DslBuilder.() -> Unit) = listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest.builder().apply(block).build())

    /**
     * Gets a list of all CloudFront functions in your account.
     * You can optionally apply a filter to return only the functions that are in the
     * specified stage, either DEVELOPMENT or LIVE.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse

    /**
     * Gets a list of all CloudFront functions in your account.
     * You can optionally apply a filter to return only the functions that are in the
     * specified stage, either DEVELOPMENT or LIVE.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listFunctions(block: ListFunctionsRequest.DslBuilder.() -> Unit) = listFunctions(ListFunctionsRequest.builder().apply(block).build())

    /**
     * Lists invalidation batches.
     */
    suspend fun listInvalidations(input: ListInvalidationsRequest): ListInvalidationsResponse

    /**
     * Lists invalidation batches.
     */
    suspend fun listInvalidations(block: ListInvalidationsRequest.DslBuilder.() -> Unit) = listInvalidations(ListInvalidationsRequest.builder().apply(block).build())

    /**
     * Gets a list of key groups.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listKeyGroups(input: ListKeyGroupsRequest): ListKeyGroupsResponse

    /**
     * Gets a list of key groups.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listKeyGroups(block: ListKeyGroupsRequest.DslBuilder.() -> Unit) = listKeyGroups(ListKeyGroupsRequest.builder().apply(block).build())

    /**
     * Gets a list of origin request policies.
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or
     * only the custom policies created in your account.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listOriginRequestPolicies(input: ListOriginRequestPoliciesRequest): ListOriginRequestPoliciesResponse

    /**
     * Gets a list of origin request policies.
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or
     * only the custom policies created in your account.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listOriginRequestPolicies(block: ListOriginRequestPoliciesRequest.DslBuilder.() -> Unit) = listOriginRequestPolicies(ListOriginRequestPoliciesRequest.builder().apply(block).build())

    /**
     * List all public keys that have been added to CloudFront for this account.
     */
    suspend fun listPublicKeys(input: ListPublicKeysRequest): ListPublicKeysResponse

    /**
     * List all public keys that have been added to CloudFront for this account.
     */
    suspend fun listPublicKeys(block: ListPublicKeysRequest.DslBuilder.() -> Unit) = listPublicKeys(ListPublicKeysRequest.builder().apply(block).build())

    /**
     * Gets a list of real-time log configurations.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listRealtimeLogConfigs(input: ListRealtimeLogConfigsRequest): ListRealtimeLogConfigsResponse

    /**
     * Gets a list of real-time log configurations.
     * You can optionally specify the maximum number of items to receive in the response. If
     * the total number of items in the list exceeds the maximum that you specify, or the
     * default maximum, the response is paginated. To get the next page of items, send a
     * subsequent request that specifies the NextMarker value from the current
     * response as the Marker value in the subsequent request.
     */
    suspend fun listRealtimeLogConfigs(block: ListRealtimeLogConfigsRequest.DslBuilder.() -> Unit) = listRealtimeLogConfigs(ListRealtimeLogConfigsRequest.builder().apply(block).build())

    /**
     * List streaming distributions.
     */
    suspend fun listStreamingDistributions(input: ListStreamingDistributionsRequest): ListStreamingDistributionsResponse

    /**
     * List streaming distributions.
     */
    suspend fun listStreamingDistributions(block: ListStreamingDistributionsRequest.DslBuilder.() -> Unit) = listStreamingDistributions(ListStreamingDistributionsRequest.builder().apply(block).build())

    /**
     * List tags for a CloudFront resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List tags for a CloudFront resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Publishes a CloudFront function by copying the function code from the DEVELOPMENT
     * stage to LIVE. This automatically updates all cache behaviors that are
     * using this function to use the newly published copy in the LIVE
     * stage.
     * When a function is published to the LIVE stage, you can attach the function to
     * a distribution’s cache behavior, using the function’s Amazon Resource Name (ARN).
     * To publish a function, you must provide the function’s name and version (ETag
     * value). To get these values, you can use ListFunctions and
     * DescribeFunction.
     */
    suspend fun publishFunction(input: PublishFunctionRequest): PublishFunctionResponse

    /**
     * Publishes a CloudFront function by copying the function code from the DEVELOPMENT
     * stage to LIVE. This automatically updates all cache behaviors that are
     * using this function to use the newly published copy in the LIVE
     * stage.
     * When a function is published to the LIVE stage, you can attach the function to
     * a distribution’s cache behavior, using the function’s Amazon Resource Name (ARN).
     * To publish a function, you must provide the function’s name and version (ETag
     * value). To get these values, you can use ListFunctions and
     * DescribeFunction.
     */
    suspend fun publishFunction(block: PublishFunctionRequest.DslBuilder.() -> Unit) = publishFunction(PublishFunctionRequest.builder().apply(block).build())

    /**
     * Add tags to a CloudFront resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Add tags to a CloudFront resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Tests a CloudFront function.
     * To test a function, you provide an event object that represents an HTTP
     * request or response that your CloudFront distribution could receive in production. CloudFront runs
     * the function, passing it the event object that you provided, and returns the function’s
     * result (the modified event object) in the response. The response also contains function
     * logs and error messages, if any exist. For more information about testing functions, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions in the Amazon CloudFront Developer Guide.
     * To test a function, you provide the function’s name and version (ETag value)
     * along with the event object. To get the function’s name and version, you can use
     * ListFunctions and DescribeFunction.
     */
    suspend fun testFunction(input: TestFunctionRequest): TestFunctionResponse

    /**
     * Tests a CloudFront function.
     * To test a function, you provide an event object that represents an HTTP
     * request or response that your CloudFront distribution could receive in production. CloudFront runs
     * the function, passing it the event object that you provided, and returns the function’s
     * result (the modified event object) in the response. The response also contains function
     * logs and error messages, if any exist. For more information about testing functions, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions in the Amazon CloudFront Developer Guide.
     * To test a function, you provide the function’s name and version (ETag value)
     * along with the event object. To get the function’s name and version, you can use
     * ListFunctions and DescribeFunction.
     */
    suspend fun testFunction(block: TestFunctionRequest.DslBuilder.() -> Unit) = testFunction(TestFunctionRequest.builder().apply(block).build())

    /**
     * Remove tags from a CloudFront resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Remove tags from a CloudFront resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates a cache policy configuration.
     * When you update a cache policy configuration, all the fields are updated with the
     * values provided in the request. You cannot update some fields independent of others. To
     * update a cache policy configuration:
     * <ol>
     * Use GetCachePolicyConfig to get the current configuration.
     * Locally modify the fields in the cache policy configuration that you want to
     * update.
     * Call UpdateCachePolicy by providing the entire cache policy
     * configuration, including the fields that you modified and those that you
     * didn’t.
     * </ol>
     */
    suspend fun updateCachePolicy(input: UpdateCachePolicyRequest): UpdateCachePolicyResponse

    /**
     * Updates a cache policy configuration.
     * When you update a cache policy configuration, all the fields are updated with the
     * values provided in the request. You cannot update some fields independent of others. To
     * update a cache policy configuration:
     * <ol>
     * Use GetCachePolicyConfig to get the current configuration.
     * Locally modify the fields in the cache policy configuration that you want to
     * update.
     * Call UpdateCachePolicy by providing the entire cache policy
     * configuration, including the fields that you modified and those that you
     * didn’t.
     * </ol>
     */
    suspend fun updateCachePolicy(block: UpdateCachePolicyRequest.DslBuilder.() -> Unit) = updateCachePolicy(UpdateCachePolicyRequest.builder().apply(block).build())

    /**
     * Update an origin access identity.
     */
    suspend fun updateCloudFrontOriginAccessIdentity(input: UpdateCloudFrontOriginAccessIdentityRequest): UpdateCloudFrontOriginAccessIdentityResponse

    /**
     * Update an origin access identity.
     */
    suspend fun updateCloudFrontOriginAccessIdentity(block: UpdateCloudFrontOriginAccessIdentityRequest.DslBuilder.() -> Unit) = updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest.builder().apply(block).build())

    /**
     * Updates the configuration for a web distribution.
     * When you update a distribution, there are more required fields than when you create a distribution.
     * When you update your distribution by using this API action, follow the steps here to get the current configuration
     * and then make your updates, to make sure that you include all of the required fields. To view a summary,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required
     * Fields for Create Distribution and Update Distribution in the Amazon CloudFront Developer Guide.
     * The update process includes getting the current distribution configuration, updating the XML document that is
     * returned to make your changes, and then submitting an UpdateDistribution request to make the updates.
     * For information about updating a distribution using the CloudFront console instead, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html">Creating a
     * Distribution in the Amazon CloudFront Developer Guide.
     * To update a web distribution using the CloudFront API
     * <ol>
     * Submit a
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">GetDistributionConfig
     * request to get the current configuration and an Etag header
     * for the distribution.
     * If you update the distribution again, you must get a new Etag header.
     * Update the XML document that was returned in the response to your GetDistributionConfig request to include
     * your changes.
     * When you edit the XML file, be aware of the following:
     * You must strip out the ETag parameter that is returned.
     * Additional fields are required when you update a distribution. There may be fields included in the
     * XML file for features that you haven't configured for your distribution. This is expected and required to
     * successfully update the distribution.
     * You can't change the value of CallerReference. If you try to change this value, CloudFront returns an
     * IllegalUpdate error.
     * The new configuration replaces the existing configuration; the values that you specify in an
     * UpdateDistribution request are not merged into your existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, CNAME), you must specify all of the
     * values that you want to appear in the updated distribution. In addition,
     * you must update the corresponding Quantity element.
     * Submit an UpdateDistribution request to update the configuration for your distribution:
     * In the request body, include the XML document that you updated in Step 2. The request body must include an
     * XML document with a DistributionConfig element.
     * Set the value of the HTTP If-Match header to the value of the ETag header that CloudFront returned
     * when you submitted the GetDistributionConfig request in Step 1.
     * Review the response to the UpdateDistribution request to confirm that the configuration was
     * successfully updated.
     * Optional: Submit a
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution
     * request to confirm that your changes have propagated.
     * When propagation is complete, the value of Status is Deployed.
     * </ol>
     */
    suspend fun updateDistribution(input: UpdateDistributionRequest): UpdateDistributionResponse

    /**
     * Updates the configuration for a web distribution.
     * When you update a distribution, there are more required fields than when you create a distribution.
     * When you update your distribution by using this API action, follow the steps here to get the current configuration
     * and then make your updates, to make sure that you include all of the required fields. To view a summary,
     * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required
     * Fields for Create Distribution and Update Distribution in the Amazon CloudFront Developer Guide.
     * The update process includes getting the current distribution configuration, updating the XML document that is
     * returned to make your changes, and then submitting an UpdateDistribution request to make the updates.
     * For information about updating a distribution using the CloudFront console instead, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html">Creating a
     * Distribution in the Amazon CloudFront Developer Guide.
     * To update a web distribution using the CloudFront API
     * <ol>
     * Submit a
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">GetDistributionConfig
     * request to get the current configuration and an Etag header
     * for the distribution.
     * If you update the distribution again, you must get a new Etag header.
     * Update the XML document that was returned in the response to your GetDistributionConfig request to include
     * your changes.
     * When you edit the XML file, be aware of the following:
     * You must strip out the ETag parameter that is returned.
     * Additional fields are required when you update a distribution. There may be fields included in the
     * XML file for features that you haven't configured for your distribution. This is expected and required to
     * successfully update the distribution.
     * You can't change the value of CallerReference. If you try to change this value, CloudFront returns an
     * IllegalUpdate error.
     * The new configuration replaces the existing configuration; the values that you specify in an
     * UpdateDistribution request are not merged into your existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, CNAME), you must specify all of the
     * values that you want to appear in the updated distribution. In addition,
     * you must update the corresponding Quantity element.
     * Submit an UpdateDistribution request to update the configuration for your distribution:
     * In the request body, include the XML document that you updated in Step 2. The request body must include an
     * XML document with a DistributionConfig element.
     * Set the value of the HTTP If-Match header to the value of the ETag header that CloudFront returned
     * when you submitted the GetDistributionConfig request in Step 1.
     * Review the response to the UpdateDistribution request to confirm that the configuration was
     * successfully updated.
     * Optional: Submit a
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution
     * request to confirm that your changes have propagated.
     * When propagation is complete, the value of Status is Deployed.
     * </ol>
     */
    suspend fun updateDistribution(block: UpdateDistributionRequest.DslBuilder.() -> Unit) = updateDistribution(UpdateDistributionRequest.builder().apply(block).build())

    /**
     * Update a field-level encryption configuration.
     */
    suspend fun updateFieldLevelEncryptionConfig(input: UpdateFieldLevelEncryptionConfigRequest): UpdateFieldLevelEncryptionConfigResponse

    /**
     * Update a field-level encryption configuration.
     */
    suspend fun updateFieldLevelEncryptionConfig(block: UpdateFieldLevelEncryptionConfigRequest.DslBuilder.() -> Unit) = updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest.builder().apply(block).build())

    /**
     * Update a field-level encryption profile.
     */
    suspend fun updateFieldLevelEncryptionProfile(input: UpdateFieldLevelEncryptionProfileRequest): UpdateFieldLevelEncryptionProfileResponse

    /**
     * Update a field-level encryption profile.
     */
    suspend fun updateFieldLevelEncryptionProfile(block: UpdateFieldLevelEncryptionProfileRequest.DslBuilder.() -> Unit) = updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest.builder().apply(block).build())

    /**
     * Updates a CloudFront function.
     * You can update a function’s code or the comment that describes the function. You
     * cannot update a function’s name.
     * To update a function, you provide the function’s name and version (ETag value)
     * along with the updated function code. To get the name and version, you can use
     * ListFunctions and DescribeFunction.
     */
    suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse

    /**
     * Updates a CloudFront function.
     * You can update a function’s code or the comment that describes the function. You
     * cannot update a function’s name.
     * To update a function, you provide the function’s name and version (ETag value)
     * along with the updated function code. To get the name and version, you can use
     * ListFunctions and DescribeFunction.
     */
    suspend fun updateFunction(block: UpdateFunctionRequest.DslBuilder.() -> Unit) = updateFunction(UpdateFunctionRequest.builder().apply(block).build())

    /**
     * Updates a key group.
     * When you update a key group, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update a key
     * group:
     * <ol>
     * Get the current key group with GetKeyGroup or
     * GetKeyGroupConfig.
     * Locally modify the fields in the key group that you want to update. For
     * example, add or remove public key IDs.
     * Call UpdateKeyGroup with the entire key group object, including
     * the fields that you modified and those that you didn’t.
     * </ol>
     */
    suspend fun updateKeyGroup(input: UpdateKeyGroupRequest): UpdateKeyGroupResponse

    /**
     * Updates a key group.
     * When you update a key group, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update a key
     * group:
     * <ol>
     * Get the current key group with GetKeyGroup or
     * GetKeyGroupConfig.
     * Locally modify the fields in the key group that you want to update. For
     * example, add or remove public key IDs.
     * Call UpdateKeyGroup with the entire key group object, including
     * the fields that you modified and those that you didn’t.
     * </ol>
     */
    suspend fun updateKeyGroup(block: UpdateKeyGroupRequest.DslBuilder.() -> Unit) = updateKeyGroup(UpdateKeyGroupRequest.builder().apply(block).build())

    /**
     * Updates an origin request policy configuration.
     * When you update an origin request policy configuration, all the fields are updated
     * with the values provided in the request. You cannot update some fields independent of
     * others. To update an origin request policy configuration:
     * <ol>
     * Use GetOriginRequestPolicyConfig to get the current configuration.
     * Locally modify the fields in the origin request policy configuration that you
     * want to update.
     * Call UpdateOriginRequestPolicy by providing the entire origin
     * request policy configuration, including the fields that you modified and those
     * that you didn’t.
     * </ol>
     */
    suspend fun updateOriginRequestPolicy(input: UpdateOriginRequestPolicyRequest): UpdateOriginRequestPolicyResponse

    /**
     * Updates an origin request policy configuration.
     * When you update an origin request policy configuration, all the fields are updated
     * with the values provided in the request. You cannot update some fields independent of
     * others. To update an origin request policy configuration:
     * <ol>
     * Use GetOriginRequestPolicyConfig to get the current configuration.
     * Locally modify the fields in the origin request policy configuration that you
     * want to update.
     * Call UpdateOriginRequestPolicy by providing the entire origin
     * request policy configuration, including the fields that you modified and those
     * that you didn’t.
     * </ol>
     */
    suspend fun updateOriginRequestPolicy(block: UpdateOriginRequestPolicyRequest.DslBuilder.() -> Unit) = updateOriginRequestPolicy(UpdateOriginRequestPolicyRequest.builder().apply(block).build())

    /**
     * Update public key information. Note that the only value you can change is the comment.
     */
    suspend fun updatePublicKey(input: UpdatePublicKeyRequest): UpdatePublicKeyResponse

    /**
     * Update public key information. Note that the only value you can change is the comment.
     */
    suspend fun updatePublicKey(block: UpdatePublicKeyRequest.DslBuilder.() -> Unit) = updatePublicKey(UpdatePublicKeyRequest.builder().apply(block).build())

    /**
     * Updates a real-time log configuration.
     * When you update a real-time log configuration, all the parameters are updated with the
     * values provided in the request. You cannot update some parameters independent of others.
     * To update a real-time log configuration:
     * <ol>
     * Call GetRealtimeLogConfig to get the current real-time log
     * configuration.
     * Locally modify the parameters in the real-time log configuration that you want
     * to update.
     * Call this API (UpdateRealtimeLogConfig) by providing the entire
     * real-time log configuration, including the parameters that you modified and
     * those that you didn’t.
     * </ol>
     * You cannot update a real-time log configuration’s Name or
     * ARN.
     */
    suspend fun updateRealtimeLogConfig(input: UpdateRealtimeLogConfigRequest): UpdateRealtimeLogConfigResponse

    /**
     * Updates a real-time log configuration.
     * When you update a real-time log configuration, all the parameters are updated with the
     * values provided in the request. You cannot update some parameters independent of others.
     * To update a real-time log configuration:
     * <ol>
     * Call GetRealtimeLogConfig to get the current real-time log
     * configuration.
     * Locally modify the parameters in the real-time log configuration that you want
     * to update.
     * Call this API (UpdateRealtimeLogConfig) by providing the entire
     * real-time log configuration, including the parameters that you modified and
     * those that you didn’t.
     * </ol>
     * You cannot update a real-time log configuration’s Name or
     * ARN.
     */
    suspend fun updateRealtimeLogConfig(block: UpdateRealtimeLogConfigRequest.DslBuilder.() -> Unit) = updateRealtimeLogConfig(UpdateRealtimeLogConfigRequest.builder().apply(block).build())

    /**
     * Update a streaming distribution.
     */
    suspend fun updateStreamingDistribution(input: UpdateStreamingDistributionRequest): UpdateStreamingDistributionResponse

    /**
     * Update a streaming distribution.
     */
    suspend fun updateStreamingDistribution(block: UpdateStreamingDistributionRequest.DslBuilder.() -> Unit) = updateStreamingDistribution(UpdateStreamingDistributionRequest.builder().apply(block).build())
}
