// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentPolicy
import aws.sdk.kotlin.services.cloudfront.model.UpdateContinuousDeploymentPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateContinuousDeploymentPolicyOperationDeserializer: HttpDeserializer.NonStreaming<UpdateContinuousDeploymentPolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateContinuousDeploymentPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateContinuousDeploymentPolicyError(context, call, payload)
        }
        val builder = UpdateContinuousDeploymentPolicyResponse.Builder()

        builder.eTag = response.headers["ETag"]

        if (payload != null) {
            builder.continuousDeploymentPolicy = deserializeContinuousDeploymentPolicyPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateContinuousDeploymentPolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchContinuousDeploymentPolicy" -> NoSuchContinuousDeploymentPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionFailed" -> PreconditionFailedDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidIfMatchVersion" -> InvalidIfMatchVersionDeserializer().deserialize(context, wrappedCall, payload)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedCall, payload)
        "StagingDistributionInUse" -> StagingDistributionInUseDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
