// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.PublicKey
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializePublicKeyDocument(reader: XmlTagReader): PublicKey {
    val builder = PublicKey.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Id com.amazonaws.cloudfront#PublicKey$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // CreatedTime com.amazonaws.cloudfront#PublicKey$CreatedTime
            "CreatedTime" -> builder.createdTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudfront#timestamp`)" }
            // PublicKeyConfig com.amazonaws.cloudfront#PublicKey$PublicKeyConfig
            "PublicKeyConfig" -> builder.publicKeyConfig = deserializePublicKeyConfigDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
