// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.Origin
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeOriginDocument(reader: XmlTagReader): Origin {
    val builder = Origin.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Id com.amazonaws.cloudfront#Origin$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // DomainName com.amazonaws.cloudfront#Origin$DomainName
            "DomainName" -> builder.domainName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // OriginPath com.amazonaws.cloudfront#Origin$OriginPath
            "OriginPath" -> builder.originPath = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // CustomHeaders com.amazonaws.cloudfront#Origin$CustomHeaders
            "CustomHeaders" -> builder.customHeaders = deserializeCustomHeadersDocument(curr)
            // S3OriginConfig com.amazonaws.cloudfront#Origin$S3OriginConfig
            "S3OriginConfig" -> builder.s3OriginConfig = deserializeS3OriginConfigDocument(curr)
            // CustomOriginConfig com.amazonaws.cloudfront#Origin$CustomOriginConfig
            "CustomOriginConfig" -> builder.customOriginConfig = deserializeCustomOriginConfigDocument(curr)
            // ConnectionAttempts com.amazonaws.cloudfront#Origin$ConnectionAttempts
            "ConnectionAttempts" -> builder.connectionAttempts = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudfront#integer`)" }
            // ConnectionTimeout com.amazonaws.cloudfront#Origin$ConnectionTimeout
            "ConnectionTimeout" -> builder.connectionTimeout = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudfront#integer`)" }
            // OriginShield com.amazonaws.cloudfront#Origin$OriginShield
            "OriginShield" -> builder.originShield = deserializeOriginShieldDocument(curr)
            // OriginAccessControlId com.amazonaws.cloudfront#Origin$OriginAccessControlId
            "OriginAccessControlId" -> builder.originAccessControlId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
