// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.FunctionMetadata
import aws.sdk.kotlin.services.cloudfront.model.FunctionStage
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeFunctionMetadataDocument(reader: XmlTagReader): FunctionMetadata {
    val builder = FunctionMetadata.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // FunctionARN com.amazonaws.cloudfront#FunctionMetadata$FunctionARN
            "FunctionARN" -> builder.functionArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Stage com.amazonaws.cloudfront#FunctionMetadata$Stage
            "Stage" -> builder.stage = curr.tryData()
                .parse { FunctionStage.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#FunctionStage`)" }
            // CreatedTime com.amazonaws.cloudfront#FunctionMetadata$CreatedTime
            "CreatedTime" -> builder.createdTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudfront#timestamp`)" }
            // LastModifiedTime com.amazonaws.cloudfront#FunctionMetadata$LastModifiedTime
            "LastModifiedTime" -> builder.lastModifiedTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudfront#timestamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
