// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.Distribution
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDistributionDocument(reader: XmlTagReader): Distribution {
    val builder = Distribution.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Id com.amazonaws.cloudfront#Distribution$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ARN com.amazonaws.cloudfront#Distribution$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Status com.amazonaws.cloudfront#Distribution$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // LastModifiedTime com.amazonaws.cloudfront#Distribution$LastModifiedTime
            "LastModifiedTime" -> builder.lastModifiedTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudfront#timestamp`)" }
            // InProgressInvalidationBatches com.amazonaws.cloudfront#Distribution$InProgressInvalidationBatches
            "InProgressInvalidationBatches" -> builder.inProgressInvalidationBatches = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudfront#integer`)" }
            // DomainName com.amazonaws.cloudfront#Distribution$DomainName
            "DomainName" -> builder.domainName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ActiveTrustedSigners com.amazonaws.cloudfront#Distribution$ActiveTrustedSigners
            "ActiveTrustedSigners" -> builder.activeTrustedSigners = deserializeActiveTrustedSignersDocument(curr)
            // ActiveTrustedKeyGroups com.amazonaws.cloudfront#Distribution$ActiveTrustedKeyGroups
            "ActiveTrustedKeyGroups" -> builder.activeTrustedKeyGroups = deserializeActiveTrustedKeyGroupsDocument(curr)
            // DistributionConfig com.amazonaws.cloudfront#Distribution$DistributionConfig
            "DistributionConfig" -> builder.distributionConfig = deserializeDistributionConfigDocument(curr)
            // AliasICPRecordals com.amazonaws.cloudfront#Distribution$AliasICPRecordals
            "AliasICPRecordals" -> builder.aliasIcpRecordals = deserializeAliasICPRecordalsShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
