// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior
import aws.sdk.kotlin.services.cloudfront.model.ViewerProtocolPolicy
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeDefaultCacheBehaviorDocument(reader: XmlTagReader): DefaultCacheBehavior {
    val builder = DefaultCacheBehavior.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // TargetOriginId com.amazonaws.cloudfront#DefaultCacheBehavior$TargetOriginId
            "TargetOriginId" -> builder.targetOriginId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // TrustedSigners com.amazonaws.cloudfront#DefaultCacheBehavior$TrustedSigners
            "TrustedSigners" -> builder.trustedSigners = deserializeTrustedSignersDocument(curr)
            // TrustedKeyGroups com.amazonaws.cloudfront#DefaultCacheBehavior$TrustedKeyGroups
            "TrustedKeyGroups" -> builder.trustedKeyGroups = deserializeTrustedKeyGroupsDocument(curr)
            // ViewerProtocolPolicy com.amazonaws.cloudfront#DefaultCacheBehavior$ViewerProtocolPolicy
            "ViewerProtocolPolicy" -> builder.viewerProtocolPolicy = curr.tryData()
                .parse { ViewerProtocolPolicy.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#ViewerProtocolPolicy`)" }
            // AllowedMethods com.amazonaws.cloudfront#DefaultCacheBehavior$AllowedMethods
            "AllowedMethods" -> builder.allowedMethods = deserializeAllowedMethodsDocument(curr)
            // SmoothStreaming com.amazonaws.cloudfront#DefaultCacheBehavior$SmoothStreaming
            "SmoothStreaming" -> builder.smoothStreaming = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // Compress com.amazonaws.cloudfront#DefaultCacheBehavior$Compress
            "Compress" -> builder.compress = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // LambdaFunctionAssociations com.amazonaws.cloudfront#DefaultCacheBehavior$LambdaFunctionAssociations
            "LambdaFunctionAssociations" -> builder.lambdaFunctionAssociations = deserializeLambdaFunctionAssociationsDocument(curr)
            // FunctionAssociations com.amazonaws.cloudfront#DefaultCacheBehavior$FunctionAssociations
            "FunctionAssociations" -> builder.functionAssociations = deserializeFunctionAssociationsDocument(curr)
            // FieldLevelEncryptionId com.amazonaws.cloudfront#DefaultCacheBehavior$FieldLevelEncryptionId
            "FieldLevelEncryptionId" -> builder.fieldLevelEncryptionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // RealtimeLogConfigArn com.amazonaws.cloudfront#DefaultCacheBehavior$RealtimeLogConfigArn
            "RealtimeLogConfigArn" -> builder.realtimeLogConfigArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // CachePolicyId com.amazonaws.cloudfront#DefaultCacheBehavior$CachePolicyId
            "CachePolicyId" -> builder.cachePolicyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // OriginRequestPolicyId com.amazonaws.cloudfront#DefaultCacheBehavior$OriginRequestPolicyId
            "OriginRequestPolicyId" -> builder.originRequestPolicyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ResponseHeadersPolicyId com.amazonaws.cloudfront#DefaultCacheBehavior$ResponseHeadersPolicyId
            "ResponseHeadersPolicyId" -> builder.responseHeadersPolicyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ForwardedValues com.amazonaws.cloudfront#DefaultCacheBehavior$ForwardedValues
            "ForwardedValues" -> builder.forwardedValues = deserializeForwardedValuesDocument(curr)
            // MinTTL com.amazonaws.cloudfront#DefaultCacheBehavior$MinTTL
            "MinTTL" -> builder.minTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            // DefaultTTL com.amazonaws.cloudfront#DefaultCacheBehavior$DefaultTTL
            "DefaultTTL" -> builder.defaultTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            // MaxTTL com.amazonaws.cloudfront#DefaultCacheBehavior$MaxTTL
            "MaxTTL" -> builder.maxTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
