// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig
import aws.sdk.kotlin.services.cloudfront.model.OriginProtocolPolicy
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeCustomOriginConfigDocument(reader: XmlTagReader): CustomOriginConfig {
    val builder = CustomOriginConfig.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // HTTPPort com.amazonaws.cloudfront#CustomOriginConfig$HTTPPort
            "HTTPPort" -> builder.httpPort = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudfront#integer`)" }
            // HTTPSPort com.amazonaws.cloudfront#CustomOriginConfig$HTTPSPort
            "HTTPSPort" -> builder.httpsPort = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudfront#integer`)" }
            // OriginProtocolPolicy com.amazonaws.cloudfront#CustomOriginConfig$OriginProtocolPolicy
            "OriginProtocolPolicy" -> builder.originProtocolPolicy = curr.tryData()
                .parse { OriginProtocolPolicy.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#OriginProtocolPolicy`)" }
            // OriginSslProtocols com.amazonaws.cloudfront#CustomOriginConfig$OriginSslProtocols
            "OriginSslProtocols" -> builder.originSslProtocols = deserializeOriginSslProtocolsDocument(curr)
            // OriginReadTimeout com.amazonaws.cloudfront#CustomOriginConfig$OriginReadTimeout
            "OriginReadTimeout" -> builder.originReadTimeout = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudfront#integer`)" }
            // OriginKeepaliveTimeout com.amazonaws.cloudfront#CustomOriginConfig$OriginKeepaliveTimeout
            "OriginKeepaliveTimeout" -> builder.originKeepaliveTimeout = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudfront#integer`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
