// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentity
import aws.sdk.kotlin.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateCloudFrontOriginAccessIdentityOperationDeserializer: HttpDeserializer.NonStreaming<CreateCloudFrontOriginAccessIdentityResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateCloudFrontOriginAccessIdentityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCloudFrontOriginAccessIdentityError(context, call, payload)
        }
        val builder = CreateCloudFrontOriginAccessIdentityResponse.Builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        if (payload != null) {
            builder.cloudFrontOriginAccessIdentity = deserializeCloudFrontOriginAccessIdentityPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateCloudFrontOriginAccessIdentityError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MissingBody" -> MissingBodyDeserializer().deserialize(context, wrappedCall, payload)
        "CloudFrontOriginAccessIdentityAlreadyExists" -> CloudFrontOriginAccessIdentityAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyCloudFrontOriginAccessIdentities" -> TooManyCloudFrontOriginAccessIdentitiesDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
