// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the information for a CloudFront streaming distribution.
 */
public class StreamingDistributionSummary private constructor(builder: Builder) {
    /**
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming distribution.
     */
    public val aliases: aws.sdk.kotlin.services.cloudfront.model.Aliases? = builder.aliases
    /**
     * The ARN (Amazon Resource Name) for the streaming distribution. For example: `arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5`, where `123456789012` is your Amazon Web Services account ID.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The comment originally specified when this distribution was created.
     */
    public val comment: kotlin.String = requireNotNull(builder.comment) { "A non-null value must be provided for comment" }
    /**
     * The domain name corresponding to the distribution, for example, `d111111abcdef8.cloudfront.net`.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * Whether the distribution is enabled to accept end user requests for content.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * The identifier for the distribution, for example, `EDFDVBD632BHDS5`.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date and time the distribution was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * A complex type that contains information about price class for this streaming distribution.
     */
    public val priceClass: aws.sdk.kotlin.services.cloudfront.model.PriceClass = requireNotNull(builder.priceClass) { "A non-null value must be provided for priceClass" }
    /**
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.
     */
    public val s3Origin: aws.sdk.kotlin.services.cloudfront.model.S3Origin? = builder.s3Origin
    /**
     * Indicates the current status of the distribution. When the status is `Deployed`, the distribution's information is fully propagated throughout the Amazon CloudFront system.
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A complex type that specifies the Amazon Web Services accounts, if any, that you want to allow to create signed URLs for private content. If you want to require signed URLs in requests for objects in the target origin that match the `PathPattern` for this cache behavior, specify `true` for `Enabled`, and specify the applicable values for `Quantity` and `Items`.If you don't want to require signed URLs in requests for objects that match `PathPattern`, specify `false` for `Enabled` and `0` for `Quantity`. Omit `Items`. To add, change, or remove one or more trusted signers, change `Enabled` to `true` (if it's currently `false`), change `Quantity` as applicable, and specify all of the trusted signers that you want to include in the updated distribution.
     *
     * For more information, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val trustedSigners: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners? = builder.trustedSigners

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingDistributionSummary(")
        append("aliases=$aliases,")
        append("arn=$arn,")
        append("comment=$comment,")
        append("domainName=$domainName,")
        append("enabled=$enabled,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("priceClass=$priceClass,")
        append("s3Origin=$s3Origin,")
        append("status=$status,")
        append("trustedSigners=$trustedSigners")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases?.hashCode() ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (comment.hashCode())
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (priceClass.hashCode())
        result = 31 * result + (s3Origin?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (trustedSigners?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamingDistributionSummary

        if (aliases != other.aliases) return false
        if (arn != other.arn) return false
        if (comment != other.comment) return false
        if (domainName != other.domainName) return false
        if (enabled != other.enabled) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (priceClass != other.priceClass) return false
        if (s3Origin != other.s3Origin) return false
        if (status != other.status) return false
        if (trustedSigners != other.trustedSigners) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming distribution.
         */
        public var aliases: aws.sdk.kotlin.services.cloudfront.model.Aliases? = null
        /**
         * The ARN (Amazon Resource Name) for the streaming distribution. For example: `arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5`, where `123456789012` is your Amazon Web Services account ID.
         */
        public var arn: kotlin.String? = null
        /**
         * The comment originally specified when this distribution was created.
         */
        public var comment: kotlin.String? = null
        /**
         * The domain name corresponding to the distribution, for example, `d111111abcdef8.cloudfront.net`.
         */
        public var domainName: kotlin.String? = null
        /**
         * Whether the distribution is enabled to accept end user requests for content.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The identifier for the distribution, for example, `EDFDVBD632BHDS5`.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time the distribution was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A complex type that contains information about price class for this streaming distribution.
         */
        public var priceClass: aws.sdk.kotlin.services.cloudfront.model.PriceClass? = null
        /**
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.
         */
        public var s3Origin: aws.sdk.kotlin.services.cloudfront.model.S3Origin? = null
        /**
         * Indicates the current status of the distribution. When the status is `Deployed`, the distribution's information is fully propagated throughout the Amazon CloudFront system.
         */
        public var status: kotlin.String? = null
        /**
         * A complex type that specifies the Amazon Web Services accounts, if any, that you want to allow to create signed URLs for private content. If you want to require signed URLs in requests for objects in the target origin that match the `PathPattern` for this cache behavior, specify `true` for `Enabled`, and specify the applicable values for `Quantity` and `Items`.If you don't want to require signed URLs in requests for objects that match `PathPattern`, specify `false` for `Enabled` and `0` for `Quantity`. Omit `Items`. To add, change, or remove one or more trusted signers, change `Enabled` to `true` (if it's currently `false`), change `Quantity` as applicable, and specify all of the trusted signers that you want to include in the updated distribution.
         *
         * For more information, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var trustedSigners: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionSummary) : this() {
            this.aliases = x.aliases
            this.arn = x.arn
            this.comment = x.comment
            this.domainName = x.domainName
            this.enabled = x.enabled
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.priceClass = x.priceClass
            this.s3Origin = x.s3Origin
            this.status = x.status
            this.trustedSigners = x.trustedSigners
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionSummary = StreamingDistributionSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Aliases] inside the given [block]
         */
        public fun aliases(block: aws.sdk.kotlin.services.cloudfront.model.Aliases.Builder.() -> kotlin.Unit) {
            this.aliases = aws.sdk.kotlin.services.cloudfront.model.Aliases.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.S3Origin] inside the given [block]
         */
        public fun s3Origin(block: aws.sdk.kotlin.services.cloudfront.model.S3Origin.Builder.() -> kotlin.Unit) {
            this.s3Origin = aws.sdk.kotlin.services.cloudfront.model.S3Origin.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrustedSigners] inside the given [block]
         */
        public fun trustedSigners(block: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners.Builder.() -> kotlin.Unit) {
            this.trustedSigners = aws.sdk.kotlin.services.cloudfront.model.TrustedSigners.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (comment == null) comment = ""
            if (domainName == null) domainName = ""
            if (enabled == null) enabled = false
            if (id == null) id = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (priceClass == null) priceClass = PriceClass.SdkUnknown("no value provided")
            if (status == null) status = ""
            return this
        }
    }
}
