// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to your staging distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
 */
public class SessionStickinessConfig private constructor(builder: Builder) {
    /**
     * The amount of time after which you want sessions to cease if no requests are received. Allowed values are 300–3600 seconds (5–60 minutes).
     *
     * The value must be less than or equal to `MaximumTTL`.
     */
    public val idleTtl: kotlin.Int = requireNotNull(builder.idleTtl) { "A non-null value must be provided for idleTtl" }
    /**
     * The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed values are 300–3600 seconds (5–60 minutes).
     *
     * The value must be greater than or equal to `IdleTTL`.
     */
    public val maximumTtl: kotlin.Int = requireNotNull(builder.maximumTtl) { "A non-null value must be provided for maximumTtl" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.SessionStickinessConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionStickinessConfig(")
        append("idleTtl=$idleTtl,")
        append("maximumTtl=$maximumTtl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = idleTtl
        result = 31 * result + (maximumTtl)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionStickinessConfig

        if (idleTtl != other.idleTtl) return false
        if (maximumTtl != other.maximumTtl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.SessionStickinessConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of time after which you want sessions to cease if no requests are received. Allowed values are 300–3600 seconds (5–60 minutes).
         *
         * The value must be less than or equal to `MaximumTTL`.
         */
        public var idleTtl: kotlin.Int? = null
        /**
         * The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed values are 300–3600 seconds (5–60 minutes).
         *
         * The value must be greater than or equal to `IdleTTL`.
         */
        public var maximumTtl: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.SessionStickinessConfig) : this() {
            this.idleTtl = x.idleTtl
            this.maximumTtl = x.maximumTtl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.SessionStickinessConfig = SessionStickinessConfig(this)

        internal fun correctErrors(): Builder {
            if (idleTtl == null) idleTtl = 0
            if (maximumTtl == null) maximumTtl = 0
            return this
        }
    }
}
