// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of HTTP header names that CloudFront includes as values for the `Access-Control-Allow-Headers` HTTP response header.
 *
 * For more information about the `Access-Control-Allow-Headers` HTTP response header, see [Access-Control-Allow-Headers](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
 */
public class ResponseHeadersPolicyAccessControlAllowHeaders private constructor(builder: Builder) {
    /**
     * The list of HTTP header names. You can specify `*` to allow all headers.
     */
    public val items: List<String> = requireNotNull(builder.items) { "A non-null value must be provided for items" }
    /**
     * The number of HTTP header names in the list.
     */
    public val quantity: kotlin.Int = requireNotNull(builder.quantity) { "A non-null value must be provided for quantity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseHeadersPolicyAccessControlAllowHeaders(")
        append("items=$items,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = items.hashCode()
        result = 31 * result + (quantity)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseHeadersPolicyAccessControlAllowHeaders

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of HTTP header names. You can specify `*` to allow all headers.
         */
        public var items: List<String>? = null
        /**
         * The number of HTTP header names in the list.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders = ResponseHeadersPolicyAccessControlAllowHeaders(this)

        internal fun correctErrors(): Builder {
            if (items == null) items = emptyList()
            if (quantity == null) quantity = 0
            return this
        }
    }
}
