// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of real-time log configurations.
 */
public class RealtimeLogConfigs private constructor(builder: Builder) {
    /**
     * A flag that indicates whether there are more real-time log configurations than are contained in this list.
     */
    public val isTruncated: kotlin.Boolean = requireNotNull(builder.isTruncated) { "A non-null value must be provided for isTruncated" }
    /**
     * Contains the list of real-time log configurations.
     */
    public val items: List<RealtimeLogConfig>? = builder.items
    /**
     * This parameter indicates where this list of real-time log configurations begins. This list includes real-time log configurations that occur after the marker.
     */
    public val marker: kotlin.String = requireNotNull(builder.marker) { "A non-null value must be provided for marker" }
    /**
     * The maximum number of real-time log configurations requested.
     */
    public val maxItems: kotlin.Int = requireNotNull(builder.maxItems) { "A non-null value must be provided for maxItems" }
    /**
     * If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the `Marker` field of a subsequent request to continue listing real-time log configurations where you left off.
     */
    public val nextMarker: kotlin.String? = builder.nextMarker

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfigs = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RealtimeLogConfigs(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker.hashCode())
        result = 31 * result + (maxItems)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RealtimeLogConfigs

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfigs = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag that indicates whether there are more real-time log configurations than are contained in this list.
         */
        public var isTruncated: kotlin.Boolean? = null
        /**
         * Contains the list of real-time log configurations.
         */
        public var items: List<RealtimeLogConfig>? = null
        /**
         * This parameter indicates where this list of real-time log configurations begins. This list includes real-time log configurations that occur after the marker.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of real-time log configurations requested.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the `Marker` field of a subsequent request to continue listing real-time log configurations where you left off.
         */
        public var nextMarker: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfigs) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfigs = RealtimeLogConfigs(this)

        internal fun correctErrors(): Builder {
            if (isTruncated == null) isTruncated = false
            if (marker == null) marker = ""
            if (maxItems == null) maxItems = 0
            return this
        }
    }
}
