// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about a CloudFront function.
 */
public class FunctionMetadata private constructor(builder: Builder) {
    /**
     * The date and time when the function was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
     */
    public val functionArn: kotlin.String = requireNotNull(builder.functionArn) { "A non-null value must be provided for functionArn" }
    /**
     * The date and time when the function was most recently updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The stage that the function is in, either `DEVELOPMENT` or `LIVE`.
     *
     * When a function is in the `DEVELOPMENT` stage, you can test the function with `TestFunction`, and update it with `UpdateFunction`.
     *
     * When a function is in the `LIVE` stage, you can attach the function to a distribution's cache behavior, using the function's ARN.
     */
    public val stage: aws.sdk.kotlin.services.cloudfront.model.FunctionStage? = builder.stage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.FunctionMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionMetadata(")
        append("createdTime=$createdTime,")
        append("functionArn=$functionArn,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("stage=$stage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime?.hashCode() ?: 0
        result = 31 * result + (functionArn.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionMetadata

        if (createdTime != other.createdTime) return false
        if (functionArn != other.functionArn) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (stage != other.stage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.FunctionMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time when the function was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
         */
        public var functionArn: kotlin.String? = null
        /**
         * The date and time when the function was most recently updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The stage that the function is in, either `DEVELOPMENT` or `LIVE`.
         *
         * When a function is in the `DEVELOPMENT` stage, you can test the function with `TestFunction`, and update it with `UpdateFunction`.
         *
         * When a function is in the `LIVE` stage, you can attach the function to a distribution's cache behavior, using the function's ARN.
         */
        public var stage: aws.sdk.kotlin.services.cloudfront.model.FunctionStage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.FunctionMetadata) : this() {
            this.createdTime = x.createdTime
            this.functionArn = x.functionArn
            this.lastModifiedTime = x.lastModifiedTime
            this.stage = x.stage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.FunctionMetadata = FunctionMetadata(this)

        internal fun correctErrors(): Builder {
            if (functionArn == null) functionArn = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
