// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex data type of profiles for the field-level encryption.
 */
public class FieldLevelEncryptionProfileConfig private constructor(builder: Builder) {
    /**
     * A unique number that ensures that the request can't be replayed.
     */
    public val callerReference: kotlin.String = requireNotNull(builder.callerReference) { "A non-null value must be provided for callerReference" }
    /**
     * An optional comment for the field-level encryption profile. The comment cannot be longer than 128 characters.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and field patterns for specifying which fields to encrypt with this key.
     */
    public val encryptionEntities: aws.sdk.kotlin.services.cloudfront.model.EncryptionEntities? = builder.encryptionEntities
    /**
     * Profile name for the field-level encryption profile.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.FieldLevelEncryptionProfileConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FieldLevelEncryptionProfileConfig(")
        append("callerReference=$callerReference,")
        append("comment=$comment,")
        append("encryptionEntities=$encryptionEntities,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference.hashCode()
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (encryptionEntities?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FieldLevelEncryptionProfileConfig

        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (encryptionEntities != other.encryptionEntities) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.FieldLevelEncryptionProfileConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique number that ensures that the request can't be replayed.
         */
        public var callerReference: kotlin.String? = null
        /**
         * An optional comment for the field-level encryption profile. The comment cannot be longer than 128 characters.
         */
        public var comment: kotlin.String? = null
        /**
         * A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and field patterns for specifying which fields to encrypt with this key.
         */
        public var encryptionEntities: aws.sdk.kotlin.services.cloudfront.model.EncryptionEntities? = null
        /**
         * Profile name for the field-level encryption profile.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.FieldLevelEncryptionProfileConfig) : this() {
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.encryptionEntities = x.encryptionEntities
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.FieldLevelEncryptionProfileConfig = FieldLevelEncryptionProfileConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.EncryptionEntities] inside the given [block]
         */
        public fun encryptionEntities(block: aws.sdk.kotlin.services.cloudfront.model.EncryptionEntities.Builder.() -> kotlin.Unit) {
            this.encryptionEntities = aws.sdk.kotlin.services.cloudfront.model.EncryptionEntities.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (callerReference == null) callerReference = ""
            if (name == null) name = ""
            return this
        }
    }
}
