// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of distribution IDs.
 */
public class DistributionIdList private constructor(builder: Builder) {
    /**
     * A flag that indicates whether more distribution IDs remain to be listed. If your results were truncated, you can make a subsequent request using the `Marker` request field to retrieve more distribution IDs in the list.
     */
    public val isTruncated: kotlin.Boolean = requireNotNull(builder.isTruncated) { "A non-null value must be provided for isTruncated" }
    /**
     * Contains the distribution IDs in the list.
     */
    public val items: List<String>? = builder.items
    /**
     * The value provided in the `Marker` request field.
     */
    public val marker: kotlin.String = requireNotNull(builder.marker) { "A non-null value must be provided for marker" }
    /**
     * The maximum number of distribution IDs requested.
     */
    public val maxItems: kotlin.Int = requireNotNull(builder.maxItems) { "A non-null value must be provided for maxItems" }
    /**
     * Contains the value that you should use in the `Marker` field of a subsequent request to continue listing distribution IDs where you left off.
     */
    public val nextMarker: kotlin.String? = builder.nextMarker
    /**
     * The total number of distribution IDs returned in the response.
     */
    public val quantity: kotlin.Int = requireNotNull(builder.quantity) { "A non-null value must be provided for quantity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.DistributionIdList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionIdList(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker.hashCode())
        result = 31 * result + (maxItems)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DistributionIdList

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.DistributionIdList = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag that indicates whether more distribution IDs remain to be listed. If your results were truncated, you can make a subsequent request using the `Marker` request field to retrieve more distribution IDs in the list.
         */
        public var isTruncated: kotlin.Boolean? = null
        /**
         * Contains the distribution IDs in the list.
         */
        public var items: List<String>? = null
        /**
         * The value provided in the `Marker` request field.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of distribution IDs requested.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * Contains the value that you should use in the `Marker` field of a subsequent request to continue listing distribution IDs where you left off.
         */
        public var nextMarker: kotlin.String? = null
        /**
         * The total number of distribution IDs returned in the response.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.DistributionIdList) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.DistributionIdList = DistributionIdList(this)

        internal fun correctErrors(): Builder {
            if (isTruncated == null) isTruncated = false
            if (marker == null) marker = ""
            if (maxItems == null) maxItems = 0
            if (quantity == null) quantity = 0
            return this
        }
    }
}
