// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CertificateSource
import aws.sdk.kotlin.services.cloudfront.model.MinimumProtocolVersion
import aws.sdk.kotlin.services.cloudfront.model.SslSupportMethod
import aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeViewerCertificateDocument(reader: XmlTagReader): ViewerCertificate {
    val builder = ViewerCertificate.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CloudFrontDefaultCertificate com.amazonaws.cloudfront#ViewerCertificate$CloudFrontDefaultCertificate
            "CloudFrontDefaultCertificate" -> builder.cloudFrontDefaultCertificate = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // IAMCertificateId com.amazonaws.cloudfront#ViewerCertificate$IAMCertificateId
            "IAMCertificateId" -> builder.iamCertificateId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ACMCertificateArn com.amazonaws.cloudfront#ViewerCertificate$ACMCertificateArn
            "ACMCertificateArn" -> builder.acmCertificateArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // SSLSupportMethod com.amazonaws.cloudfront#ViewerCertificate$SSLSupportMethod
            "SSLSupportMethod" -> builder.sslSupportMethod = curr.tryData()
                .parse { SslSupportMethod.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#SSLSupportMethod`)" }
            // MinimumProtocolVersion com.amazonaws.cloudfront#ViewerCertificate$MinimumProtocolVersion
            "MinimumProtocolVersion" -> builder.minimumProtocolVersion = curr.tryData()
                .parse { MinimumProtocolVersion.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#MinimumProtocolVersion`)" }
            // Certificate com.amazonaws.cloudfront#ViewerCertificate$Certificate
            "Certificate" -> builder.certificate = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // CertificateSource com.amazonaws.cloudfront#ViewerCertificate$CertificateSource
            "CertificateSource" -> builder.certificateSource = curr.tryData()
                .parse { CertificateSource.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#CertificateSource`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
