// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.PriceClass
import aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStreamingDistributionSummaryDocument(reader: XmlTagReader): StreamingDistributionSummary {
    val builder = StreamingDistributionSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Id com.amazonaws.cloudfront#StreamingDistributionSummary$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ARN com.amazonaws.cloudfront#StreamingDistributionSummary$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Status com.amazonaws.cloudfront#StreamingDistributionSummary$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // LastModifiedTime com.amazonaws.cloudfront#StreamingDistributionSummary$LastModifiedTime
            "LastModifiedTime" -> builder.lastModifiedTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudfront#timestamp`)" }
            // DomainName com.amazonaws.cloudfront#StreamingDistributionSummary$DomainName
            "DomainName" -> builder.domainName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // S3Origin com.amazonaws.cloudfront#StreamingDistributionSummary$S3Origin
            "S3Origin" -> builder.s3Origin = deserializeS3OriginDocument(curr)
            // Aliases com.amazonaws.cloudfront#StreamingDistributionSummary$Aliases
            "Aliases" -> builder.aliases = deserializeAliasesDocument(curr)
            // TrustedSigners com.amazonaws.cloudfront#StreamingDistributionSummary$TrustedSigners
            "TrustedSigners" -> builder.trustedSigners = deserializeTrustedSignersDocument(curr)
            // Comment com.amazonaws.cloudfront#StreamingDistributionSummary$Comment
            "Comment" -> builder.comment = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // PriceClass com.amazonaws.cloudfront#StreamingDistributionSummary$PriceClass
            "PriceClass" -> builder.priceClass = curr.tryData()
                .parse { PriceClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#PriceClass`)" }
            // Enabled com.amazonaws.cloudfront#StreamingDistributionSummary$Enabled
            "Enabled" -> builder.enabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
