// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.GetRealtimeLogConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfig
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetRealtimeLogConfigOperationDeserializer: HttpDeserializer.NonStreaming<GetRealtimeLogConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetRealtimeLogConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRealtimeLogConfigError(context, call, payload)
        }
        val builder = GetRealtimeLogConfigResponse.Builder()

        if (payload != null) {
            deserializeGetRealtimeLogConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetRealtimeLogConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchRealtimeLogConfig" -> NoSuchRealtimeLogConfigDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRealtimeLogConfigOperationBody(builder: GetRealtimeLogConfigResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // RealtimeLogConfig com.amazonaws.cloudfront#GetRealtimeLogConfigResult$RealtimeLogConfig
            "RealtimeLogConfig" -> builder.realtimeLogConfig = deserializeRealtimeLogConfigDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
