// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.ForwardedValues
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeForwardedValuesDocument(reader: XmlTagReader): ForwardedValues {
    val builder = ForwardedValues.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // QueryString com.amazonaws.cloudfront#ForwardedValues$QueryString
            "QueryString" -> builder.queryString = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // Cookies com.amazonaws.cloudfront#ForwardedValues$Cookies
            "Cookies" -> builder.cookies = deserializeCookiePreferenceDocument(curr)
            // Headers com.amazonaws.cloudfront#ForwardedValues$Headers
            "Headers" -> builder.headers = deserializeHeadersDocument(curr)
            // QueryStringCacheKeys com.amazonaws.cloudfront#ForwardedValues$QueryStringCacheKeys
            "QueryStringCacheKeys" -> builder.queryStringCacheKeys = deserializeQueryStringCacheKeysDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
