// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.DistributionSummary
import aws.sdk.kotlin.services.cloudfront.model.HttpVersion
import aws.sdk.kotlin.services.cloudfront.model.PriceClass
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDistributionSummaryDocument(reader: XmlTagReader): DistributionSummary {
    val builder = DistributionSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Id com.amazonaws.cloudfront#DistributionSummary$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ARN com.amazonaws.cloudfront#DistributionSummary$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Status com.amazonaws.cloudfront#DistributionSummary$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // LastModifiedTime com.amazonaws.cloudfront#DistributionSummary$LastModifiedTime
            "LastModifiedTime" -> builder.lastModifiedTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudfront#timestamp`)" }
            // DomainName com.amazonaws.cloudfront#DistributionSummary$DomainName
            "DomainName" -> builder.domainName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Aliases com.amazonaws.cloudfront#DistributionSummary$Aliases
            "Aliases" -> builder.aliases = deserializeAliasesDocument(curr)
            // Origins com.amazonaws.cloudfront#DistributionSummary$Origins
            "Origins" -> builder.origins = deserializeOriginsDocument(curr)
            // OriginGroups com.amazonaws.cloudfront#DistributionSummary$OriginGroups
            "OriginGroups" -> builder.originGroups = deserializeOriginGroupsDocument(curr)
            // DefaultCacheBehavior com.amazonaws.cloudfront#DistributionSummary$DefaultCacheBehavior
            "DefaultCacheBehavior" -> builder.defaultCacheBehavior = deserializeDefaultCacheBehaviorDocument(curr)
            // CacheBehaviors com.amazonaws.cloudfront#DistributionSummary$CacheBehaviors
            "CacheBehaviors" -> builder.cacheBehaviors = deserializeCacheBehaviorsDocument(curr)
            // CustomErrorResponses com.amazonaws.cloudfront#DistributionSummary$CustomErrorResponses
            "CustomErrorResponses" -> builder.customErrorResponses = deserializeCustomErrorResponsesDocument(curr)
            // Comment com.amazonaws.cloudfront#DistributionSummary$Comment
            "Comment" -> builder.comment = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // PriceClass com.amazonaws.cloudfront#DistributionSummary$PriceClass
            "PriceClass" -> builder.priceClass = curr.tryData()
                .parse { PriceClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#PriceClass`)" }
            // Enabled com.amazonaws.cloudfront#DistributionSummary$Enabled
            "Enabled" -> builder.enabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // ViewerCertificate com.amazonaws.cloudfront#DistributionSummary$ViewerCertificate
            "ViewerCertificate" -> builder.viewerCertificate = deserializeViewerCertificateDocument(curr)
            // Restrictions com.amazonaws.cloudfront#DistributionSummary$Restrictions
            "Restrictions" -> builder.restrictions = deserializeRestrictionsDocument(curr)
            // WebACLId com.amazonaws.cloudfront#DistributionSummary$WebACLId
            "WebACLId" -> builder.webAclId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // HttpVersion com.amazonaws.cloudfront#DistributionSummary$HttpVersion
            "HttpVersion" -> builder.httpVersion = curr.tryData()
                .parse { HttpVersion.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#HttpVersion`)" }
            // IsIPV6Enabled com.amazonaws.cloudfront#DistributionSummary$IsIPV6Enabled
            "IsIPV6Enabled" -> builder.isIpv6Enabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // AliasICPRecordals com.amazonaws.cloudfront#DistributionSummary$AliasICPRecordals
            "AliasICPRecordals" -> builder.aliasIcpRecordals = deserializeAliasICPRecordalsShape(curr)
            // Staging com.amazonaws.cloudfront#DistributionSummary$Staging
            "Staging" -> builder.staging = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
