// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse
import aws.sdk.kotlin.services.cloudfront.model.StreamingDistribution
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateStreamingDistributionWithTagsOperationDeserializer: HttpDeserializer.NonStreaming<CreateStreamingDistributionWithTagsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateStreamingDistributionWithTagsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateStreamingDistributionWithTagsError(context, call, payload)
        }
        val builder = CreateStreamingDistributionWithTagsResponse.Builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        if (payload != null) {
            builder.streamingDistribution = deserializeStreamingDistributionPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateStreamingDistributionWithTagsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MissingBody" -> MissingBodyDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyStreamingDistributions" -> TooManyStreamingDistributionsDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOriginAccessControl" -> InvalidOriginAccessControlDeserializer().deserialize(context, wrappedCall, payload)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagging" -> InvalidTaggingDeserializer().deserialize(context, wrappedCall, payload)
        "TrustedSignerDoesNotExist" -> TrustedSignerDoesNotExistDeserializer().deserialize(context, wrappedCall, payload)
        "CNAMEAlreadyExists" -> CnameAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyTrustedSigners" -> TooManyTrustedSignersDeserializer().deserialize(context, wrappedCall, payload)
        "StreamingDistributionAlreadyExists" -> StreamingDistributionAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOriginAccessIdentity" -> InvalidOriginAccessIdentityDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOrigin" -> InvalidOriginDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyStreamingDistributionCNAMEs" -> TooManyStreamingDistributionCnamesDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
