// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateResponseHeadersPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicy
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateResponseHeadersPolicyOperationDeserializer: HttpDeserializer.NonStreaming<CreateResponseHeadersPolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateResponseHeadersPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateResponseHeadersPolicyError(context, call, payload)
        }
        val builder = CreateResponseHeadersPolicyResponse.Builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        if (payload != null) {
            builder.responseHeadersPolicy = deserializeResponseHeadersPolicyPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateResponseHeadersPolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyCustomHeadersInResponseHeadersPolicy" -> TooManyCustomHeadersInResponseHeadersPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedCall, payload)
        "TooLongCSPInResponseHeadersPolicy" -> TooLongCspInResponseHeadersPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRemoveHeadersInResponseHeadersPolicy" -> TooManyRemoveHeadersInResponseHeadersPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyResponseHeadersPolicies" -> TooManyResponseHeadersPoliciesDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        "ResponseHeadersPolicyAlreadyExists" -> ResponseHeadersPolicyAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
